C This file contain the following BLOCKS :
C    -- LISTS{}
C    -- SYMKQ{}
C    -- SYMME{}
C    -- count{}
C    -- COUNT{}
C    -- REDUCE{}
C    -- REDU1{}
C    -- REDU2{}
C    -- ALLKQ{}
C    -- symme{}
C    -- SHIFT{}
C    -- INFINI{}
C    -- NUMBER{}
C    -- ZERO{}
C    -- RATNOM{K,m1,m2}
C    -- RAT{K,m1}
C    -- RATKQ{K,m1,KQ,m2,Q,m3}
C    -- nota{}
C    -- NOTA{}
C    -- g5g5{}
C    --color{}
BLOCK LISTS{}
P ni
P no
Outlimit 4000000
C Algebraic symbols :
A Mw,Mz,PM,Mb,Ms,Mc,Mt,m,Mu,N,N_,EP,x,z,xxx,yyy,zzz,TIPI2,Pi,PP2,KQ2,k2,q2
A m1,m2,m3,Mx,N00,N33,N55,N45,N54,N44,My,J,J_
C Vectors :
V P,K,Q,R,S,V,KQ,KP,K1,K2,K3,K4,QP,Q1,Q2,Q3,Q4,P1,P2,P3,P4,PP

C Lorentz indices :
C I AL,BE,GA,DE,SI,RO,ETA,MU4,MU,NU,NU1,NU2,NU3,NU4,NU5,NU6
I AL=N,BE=N,GA=N,DE=N,SI=N,RO=N,ETA=N,MU4=N,NU=N,MU=N,NU3,NU2,NU1

C spin indices :
I s0,s1,s2,s3,s4,s5,s6,s7,s8,s9,s10,NU5,NU6,MU5

C Color indices : fondamental representation ;   
I c0=3,c1=3,c2=3,c3=3,c4=3,c5=3,c6=3,c7=3,c8=3,c9=3,c10=3
C I c0=n,c1=n,c2=n,c3=n,c4=n,c5=n,c6=n,c7=n,c8=n,c9=n

C Color indices in Adjoint representation : J=n^2-1
I a0=8,a1=8,a2=8,a3=8,a4=8,a5=8,a6=8,a7=8,a8=8,a9=8
C I a0=J,a1=J,a2=J,a3=J,a4=J,a5=J,a6=J,a7=J,a8=J,a9=J

F gam,gam5,gam6,gam7,Sgam,Tgam,Sgam6,Sgam7,Tgam6,Tgam7,NOM,FFF,Fk,Fkq,Fk,Fx,Fy,f,T,ddd,log,F,fff

X DEDE4(AL,BE,GA,DE)=
   D(AL,BE)*D(GA,DE)
  +D(AL,GA)*D(BE,DE)
  +D(AL,DE)*D(BE,GA)
X DEDE6(AL,BE,GA,DE,SI,RO)=
    D(AL,BE)*DEDE4(GA,DE,SI,RO)
   +D(AL,GA)*DEDE4(BE,DE,SI,RO)
   +D(AL,DE)*DEDE4(GA,BE,SI,RO)
   +D(AL,SI)*DEDE4(GA,DE,BE,RO)
   +D(AL,RO)*DEDE4(GA,DE,SI,BE)
X DEDE8(MU,NU,AL,BE,GA,DE,SI,RO)=
    D(MU,NU)*DEDE6(AL,BE,GA,DE,SI,RO)
   +D(MU,AL)*DEDE6(NU,BE,GA,DE,SI,RO)
   +D(MU,BE)*DEDE6(NU,AL,GA,DE,SI,RO)
   +D(MU,GA)*DEDE6(NU,BE,AL,DE,SI,RO)
   +D(MU,DE)*DEDE6(NU,BE,GA,AL,SI,RO)
   +D(MU,SI)*DEDE6(NU,BE,GA,DE,AL,RO)
   +D(MU,RO)*DEDE6(NU,BE,GA,DE,SI,AL)

C TTT24 is completely symmetric in (arg1,arg2) and (arg3,arg4,arg5,arg6)
X TTT24(GA,DE,SI,RO,MU,NU)=
   +D(GA,SI)*DEDE4(DE,RO,MU,NU)
   +D(GA,RO)*DEDE4(DE,SI,MU,NU)
   +D(GA,MU)*DEDE4(DE,RO,SI,NU)
   +D(GA,NU)*DEDE4(DE,RO,MU,SI)

   +D(DE,SI)*DEDE4(GA,RO,MU,NU)
   +D(DE,RO)*DEDE4(GA,SI,MU,NU)
   +D(DE,MU)*DEDE4(GA,RO,SI,NU)
   +D(DE,NU)*DEDE4(GA,RO,MU,SI)

C TTT44 is completely symmetric in (arg1,arg2,arg3,arg4) 
  and in (arg5,arg6,arg7,arg8)   : there are 72 different terms !( is different
  from SSS44 above .)
X TTT44(AL,BE,GA,DE,SI,RO,MU,NU)=
   +D(AL,BE)*TTT24(GA,DE,SI,RO,MU,NU)
   +D(AL,GA)*TTT24(BE,DE,SI,RO,MU,NU)
   +D(AL,DE)*TTT24(GA,BE,SI,RO,MU,NU)
   +D(BE,GA)*TTT24(AL,DE,SI,RO,MU,NU)
   +D(BE,DE)*TTT24(GA,AL,SI,RO,MU,NU)
   +D(GA,DE)*TTT24(AL,BE,SI,RO,MU,NU)   


C SSS22 is completely symmetric in (arg1,arg2) and in (arg3,arg4)
X SSS22(GA,DE,MU,NU)=
  D(GA,MU)*D(DE,NU)+D(GA,NU)*D(DE,MU)

C SSS23 is completely symmetric in (arg2,arg3) and in (arg4,arg5,arg6)
X SSS23(BE,GA,DE,RO,MU,NU)=
  +D(BE,RO)*SSS22(GA,DE,MU,NU)
  +D(BE,MU)*SSS22(GA,DE,RO,NU)
  +D(BE,NU)*SSS22(GA,DE,MU,RO)

C SSS33 is completely symmetric in (arg1,arg2,arg3) and in (arg4,arg5,arg6)
X SSS33(BE,GA,DE,RO,MU,NU)=
    +SSS23(BE,GA,DE,RO,MU,NU)
    +SSS23(GA,BE,DE,RO,MU,NU)
    +SSS23(DE,BE,GA,RO,MU,NU)

C SSS44 is completely symmetric in (arg1,arg2,arg3,arg4) 
  and in (arg5,arg6,arg7,arg8)   : there are 24 different terms !
X SSS44(AL,BE,GA,DE,SI,RO,MU,NU)=
   +D(AL,SI)*SSS33(BE,GA,DE,RO,MU,NU)
   +D(AL,RO)*SSS33(BE,GA,DE,SI,MU,NU)
   +D(AL,MU)*SSS33(BE,GA,DE,RO,SI,NU)
   +D(AL,NU)*SSS33(BE,GA,DE,RO,MU,SI)  

X qq(s2,s1,P,Ms)=(i*gam(s2,s1,P)+Ms*D(s2,s1) )*NOM(P,Ms)
X qqG(be,al,a,s2,s1,MU)=i*g*gam(s2,s1,MU)*T(be,al,a)
X qqA(be,al,a,s2,s1,MU)=i*g*gam(s2,s1,MU)*D(be,al)
X GG(K,MU,NU)=NOM(K,PM)*NOM(K,PM)*D(MU,NU)*KDK
            - K(MU)*K(NU)*[1-aa]*NOM(K,PM)*NOM(K,PM)
X GGG(P,LA,l,Q,MU,m,R,NU,n)=
   i*g*f(l,m,n)*( (P(NU)-Q(NU))*D(LA,MU) + (Q(LA)-R(LA))*D(MU,NU)
                            + (R(MU)-P(MU))*D(NU,LA)  )

X FFF0(AL,BE,GA,DE,s1,s2,s3,s4,MU) =1
X O13(AL,BE,GA,DE,s1,s2,s3,s4,MU) =-
    D(AL,DE)*D(BE,GA)*gam(s3,NU5,MU)*gam6(NU5,s2)*gam(s4,NU6,MU)*gam6(NU6,s1)
X O14(AL,BE,GA,DE,s1,s2,s3,s4,MU) =-
    D(AL,GA)*D(BE,DE)*gam(s3,NU5,MU)*gam6(NU5,s2)*gam(s4,NU6,MU)*gam6(NU6,s1) 
X O15(AL,BE,GA,DE,s1,s2,s3,s4,MU) =
    D(AL,GA)*D(BE,DE)*gam(s3,NU5,MU)*gam6(NU5,s1)*gam(s4,NU6,MU)*gam6(NU6,s2)
X O16(AL,BE,GA,DE,s1,s2,s3,s4,MU) =
    D(AL,DE)*D(BE,GA)*gam(s3,NU5,MU)*gam6(NU5,s1)*gam(s4,NU6,MU)*gam6(NU6,s2)
X O17(AL,BE,GA,DE,s1,s2,s3,s4,MU) =
    D(AL,GA)*D(BE,DE)*gam(s3,NU5,MU)*gam6(NU5,s1)*gam(s4,NU6,MU)*gam7(NU6,s2)
X O18(AL,BE,GA,DE,s1,s2,s3,s4,MU) =
    D(AL,DE)*D(BE,GA)*gam(s3,NU5,MU)*gam6(NU5,s1)*gam(s4,NU6,MU)*gam7(NU6,s2)


X bs1(FFF,m) = FFF(c1,c2,c3,c4,s1,s2,s3,s4,MU4)*qq(s2,s5,K,m)
              *qqG(c2,c5,a0,s5,s6,MU)*qq(s6,s7,KQ,m)
              *qqG(c5,c4,a0,s7,s8,NU)*qq(s8,s4,K,m)*GG(Q,MU,NU)

X bs3(FFF,m) = FFF(c5,c2,c3,c4,s5,s2,s3,s4,MU4)*qq(s2,s7,KQ,m)
              *qqG(c2,c4,a0,s7,s8,MU)*qq(s8,s4,K,m)
              *qq(s5,s6,-QP,Mb)*qqG(c5,c1,a0,s6,s1,NU)
              *GG(Q,MU,NU)

C Notation for the vectors used :
C   K and Q are integration momenta ,  ( KQ = K + Q )
    P1 and P2 are the b-quark and gluon momenta, ( P3 = P1 + P2 )
    Q1 = Q + P1
    Q2 = Q - P2
    Q3 = Q + P3     
    Q4 = Q - P3
    K2 = K + P2

X bsG1(FFF,m) = qqG(c3,c6,a1,s3,s10,BE)*qq(s10,s9,-Q3,Ms)
              *qqG(c6,c4,a0,s9,s8,MU)*qq(s8,s4,-Q1,Ms)
              *FFF(c1,c2,c4,c5,s1,s2,s4,s5,MU4)*qq(s2,s6,K,m)
              *qqG(c2,c5,a1,s6,s7,AL)*qq(s7,s5,KQ,m)
              *GG(Q,AL,BE)

X bsG2(FFF,m) =FFF(c4,c5,c3,c2,s4,s5,s3,s2,MU4)*qq(s5,s7,KQ,m)
              *qqG(c5,c2,a1,s7,s6,AL)*qq(s6,s2,K,m)
              *qq(s4,s8,-Q3,Mb)*qqG(c4,c6,a0,s8,s9,MU)
              *qq(s9,s10,-Q1,Mb)*qqG(c6,c1,a1,s10,s1,BE)
              *GG(Q,AL,BE)

X bsG3(FFF,m) = qqG(c3,c4,a2,s3,s8,DE)*qq(s8,s4,-Q1,Ms)
              *FFF(c1,c2,c4,c5,s1,s2,s4,s5,MU4)*qq(s2,s6,K,m)
              *qqG(c2,c5,a1,s6,s7,AL)*qq(s7,s5,KQ,m)
              *GG(Q,AL,BE)*GGG(-Q,BE,a1,P2,MU,a0,Q2,GA,a2)*GG(Q2,GA,DE)

X bsG4(FFF,m) =FFF(c4,c5,c3,c2,s4,s5,s3,s2,MU4)*qq(s5,s7,K,m)
              *qqG(c5,c2,a1,s7,s6,AL)*qq(s6,s2,KQ,m)
              *qq(s4,s8,Q4,Mb)*qqG(c4,c1,a2,s8,s1,DE)
              *GG(Q,AL,BE)*GGG(-Q,BE,a1,P2,MU,a0,Q2,GA,a2)*GG(Q2,GA,DE)

X bsG5(FFF,m) =
               qqG(c3,c5,a1,s3,s9,BE)*qq(s9,s5,-Q3,Ms)
              *FFF(c2,c4,c5,c6,s2,s4,s5,s6,MU4)*qq(s4,s7,K,m)
              *qqG(c4,c6,a0,s7,s8,MU)*qq(s8,s6,K2,m)
              *qq(s2,s10,-Q1,Mb)*qqG(c2,c1,a1,s10,s1,AL)
              *GG(Q,AL,BE)

X bsG6(FFF,m) =FFF(c2,c5,c3,c4,s2,s5,s3,s4,MU4)*qq(s5,s6,KQ,m)
              *qqG(c5,c6,a1,s6,s7,AL)*qq(s7,s8,K,m)
              *qqG(c6,c4,a0,s8,s9,MU)*qq(s9,s4,K2,m)
              *qq(s2,s10,-Q1,Mb)*qqG(c2,c1,a1,s10,s1,BE)
              *GG(Q,AL,BE)

X bsG7(FFF,m) =
              qqG(c3,c4,a1,s3,s10,BE)*qq(s10,s4,Q4,Ms)
              *FFF(c1,c2,c4,c5,s1,s2,s4,s5,MU4)*qq(s2,s9,-K2,m)
              *qqG(c2,c6,a0,s9,s8,MU)*qq(s8,s7,-K,m)
              *qqG(c6,c5,a1,s7,s6,AL)*qq(s6,s5,-KQ,m)
              *GG(Q,AL,BE)

X bsG8(FFF,m) =FFF(c2,c5,c3,c4,s2,s5,s3,s4,MU4)*qq(s5,s6,-K2,m)
              *qqG(c5,c6,a0,s6,s7,MU)*qq(s7,s8,-K,m)
              *qqG(c6,c4,a1,s8,s9,AL)*qq(s9,s4,-KQ,m)
              *qq(s2,s10,-Q1,Mb)*qqG(c2,c1,a1,s10,s1,BE)
              *GG(Q,AL,BE)

X bsG9(FFF,m) =
              qqG(c3,c4,a1,s3,s10,BE)*qq(s10,s4,Q4,Ms)
              *FFF(c1,c2,c4,c5,s1,s2,s4,s5,MU4)*qq(s2,s9,KQ,m)
              *qqG(c2,c6,a1,s9,s8,AL)*qq(s8,s7,K,m)
              *qqG(c6,c5,a0,s7,s6,MU)*qq(s6,s5,K2,m)
              *GG(Q,AL,BE)

ENDBLOCK

BLOCK SYMKQ{}
Id,Funct,G,Q(MU~)=zzz*Q(MU)
Al,Funct,G,K(MU~)=zzz*K(MU)
Al,Funct,gam,Q(MU~)=zzz*Q(MU)
Al,Funct,gam,K(MU~)=zzz*K(MU)
Id,Count,zzz,Q,1,K,1
Id,Multi,zzz^2=1
Id,zzz=0
ENDBLOCK

BLOCK SYMME{}
IF NOT NOM(KQ,Mb~)
Id,Funct,G,Q(MU~)=zzz*Q(MU)
Al,Funct,G,K(MU~)=yyy*K(MU)
Id,Funct,gam,Q(MU~)=zzz*Q(MU)
Al,Funct,gam,K(MU~)=yyy*K(MU)
Id,Count,zzz,Q,1
Al,Count,yyy,K,1
Id,Multi,zzz^2=1
Al,Multi,yyy^2=1
Id,zzz=0 ; yyy=0
ENDIF
ENDBLOCK

BLOCK count{}
Id,NOM(K,Mb~)=xk^2*XXKQ^2*NOM(K,Mb)
Al,NOM(Q,Mb~)=xq^2*XXKQ^2*NOM(Q,Mb)
Al,NOM(KQ,Mb~)=xk^2*xq^2*XXKQ^2*NOM(KQ,Mb)
Al,KDK=xk^-2*XXKQ^-2*KDK
Al,QDQ=xq^-2*XXKQ^-2*QDQ
Al,KDQ=xk^-1*xq^-1*XXKQ^-2*KDQ
Al,Addfa,xk^-4*xq^-4*XXKQ^-8

IF xk
AND xq
AND XXKQ
Id,Addfa,0
ELSE
Al,xq^n~=1 ;xk^n~=1 ; XXKQ^n~=1 
ENDIF
ENDBLOCK

BLOCK COUNT{}
Id,Funct,gam,Q(MU~)=xq^-1*XXKQ^-1*Q(MU)
Al,Funct,gam,K(MU~)=xk^-1*XXKQ^-1*K(MU)
Al,Funct,G,Q(MU~)=xq^-1*XXKQ^-1*Q(MU)
Al,Funct,G,K(MU~)=xk^-1*XXKQ^-1*K(MU)
Al,Count,xk,K,-1 
Al,Count,xq,Q,-1
Al,Count,XXKQ,K,-1,Q,-1 
Al,NOM(K,Mb~)=xk^2*XXKQ^2*NOM(K,Mb)
Al,NOM(Q,Mb~)=xq^2*XXKQ^2*NOM(Q,Mb)
Al,NOM(KQ,Mb~)=xk^2*xq^2*XXKQ^2*NOM(KQ,Mb)
Al,Addfa,xk^-4*xq^-4*XXKQ^-8

IF xk
AND xq
AND XXKQ
Id,Addfa,0
ELSE
Al,xq^n~=1 ;xk^n~=1 ; XXKQ^n~=1 
ENDIF

ENDBLOCK

BLOCK REDUCE{} 
Id,Adiso,KDQ^5*NOM(K,m1~)*NOM(KQ,m2~)*NOM(Q,m3~) = 
 + NOM(K,m1)*NOM(Q,m3)
  * ( - 3/8*m1^2*m2^2*m3^2*KDQ - 3/8*m1^2*m2^2*m3^4 - 1/4*m1^2*m2^2
  *KDQ^2 + 3/8*m1^2*m2^4*m3^2 + 3/16*m1^2*m2^4*KDQ - 1/8*m1^2*m2^6
   + 1/4*m1^2*m3^2*KDQ^2 + 3/16*m1^2*m3^4*KDQ + 1/8*m1^2*m3^6
  + 1/4*m1^2*KDQ^3 - 3/8*m1^4*m2^2*m3^2 - 3/16*m1^4*m2^2*KDQ
  + 3/16*m1^4*m2^4 + 3/16*m1^4*m3^2*KDQ + 3/16*m1^4*m3^4 + 1/8*m1^4
  *KDQ^2 - 1/8*m1^6*m2^2 + 1/8*m1^6*m3^2 + 1/16*m1^6*KDQ + 1/32*m1^8
   - 1/4*m2^2*m3^2*KDQ^2 - 3/16*m2^2*m3^4*KDQ - 1/8*m2^2*m3^6
  - 1/4*m2^2*KDQ^3 + 3/16*m2^4*m3^2*KDQ + 3/16*m2^4*m3^4 + 1/8*m2^4
  *KDQ^2 - 1/8*m2^6*m3^2 - 1/16*m2^6*KDQ + 1/32*m2^8 + 1/4*m3^2*KDQ^3
   + 1/8*m3^4*KDQ^2 + 1/16*m3^6*KDQ + 1/32*m3^8 + 1/2*KDQ^4 )
 
 + NOM(K,m1)*NOM(Q,m3)*NOM(KQ,m2)
  * ( - 5/8*m1^2*m2^2*m3^6 + 15/16*m1^2*m2^4*m3^4 - 5/8*m1^2*m2^6*m3^2
   + 5/32*m1^2*m2^8 + 5/32*m1^2*m3^8 - 15/16*m1^4*m2^2*m3^4
  + 15/16*m1^4*m2^4*m3^2 - 5/16*m1^4*m2^6 + 5/16*m1^4*m3^6
  - 5/8*m1^6*m2^2*m3^2 + 5/16*m1^6*m2^4 + 5/16*m1^6*m3^4 - 5/32*m1^8
  *m2^2 + 5/32*m1^8*m3^2 + 1/32*m1^10 - 5/32*m2^2*m3^8 + 5/16*m2^4
  *m3^6 - 5/16*m2^6*m3^4 + 5/32*m2^8*m3^2 - 1/32*m2^10 + 1/32*m3^10 )
 
 + NOM(K,m1)*NOM(KQ,m2)
  * ( 3/8*m1^2*m2^2*m3^2*KDQ + 3/8*m1^2*m2^2*m3^4 + 1/4*m1^2*m2^2*KDQ^2
   - 3/8*m1^2*m2^4*m3^2 - 3/16*m1^2*m2^4*KDQ + 1/8*m1^2*m2^6
  - 1/4*m1^2*m3^2*KDQ^2 - 3/16*m1^2*m3^4*KDQ - 1/8*m1^2*m3^6
  - 1/4*m1^2*KDQ^3 + 3/8*m1^4*m2^2*m3^2 + 3/16*m1^4*m2^2*KDQ
  - 3/16*m1^4*m2^4 - 3/16*m1^4*m3^2*KDQ - 3/16*m1^4*m3^4 - 1/8*m1^4
  *KDQ^2 + 1/8*m1^6*m2^2 - 1/8*m1^6*m3^2 - 1/16*m1^6*KDQ - 1/32*m1^8
   + 1/4*m2^2*m3^2*KDQ^2 + 3/16*m2^2*m3^4*KDQ + 1/8*m2^2*m3^6
  + 1/4*m2^2*KDQ^3 - 3/16*m2^4*m3^2*KDQ - 3/16*m2^4*m3^4 - 1/8*m2^4
  *KDQ^2 + 1/8*m2^6*m3^2 + 1/16*m2^6*KDQ - 1/32*m2^8 - 1/4*m3^2*KDQ^3
   - 1/8*m3^4*KDQ^2 - 1/16*m3^6*KDQ - 1/32*m3^8 - 1/2*KDQ^4 )
 
 + NOM(Q,m3)*NOM(KQ,m2)
  * ( 3/8*m1^2*m2^2*m3^2*KDQ + 3/8*m1^2*m2^2*m3^4 + 1/4*m1^2*m2^2*KDQ^2
   - 3/8*m1^2*m2^4*m3^2 - 3/16*m1^2*m2^4*KDQ + 1/8*m1^2*m2^6
  - 1/4*m1^2*m3^2*KDQ^2 - 3/16*m1^2*m3^4*KDQ - 1/8*m1^2*m3^6
  - 1/4*m1^2*KDQ^3 + 3/8*m1^4*m2^2*m3^2 + 3/16*m1^4*m2^2*KDQ
  - 3/16*m1^4*m2^4 - 3/16*m1^4*m3^2*KDQ - 3/16*m1^4*m3^4 - 1/8*m1^4
  *KDQ^2 + 1/8*m1^6*m2^2 - 1/8*m1^6*m3^2 - 1/16*m1^6*KDQ - 1/32*m1^8
   + 1/4*m2^2*m3^2*KDQ^2 + 3/16*m2^2*m3^4*KDQ + 1/8*m2^2*m3^6
  + 1/4*m2^2*KDQ^3 - 3/16*m2^4*m3^2*KDQ - 3/16*m2^4*m3^4 - 1/8*m2^4
  *KDQ^2 + 1/8*m2^6*m3^2 + 1/16*m2^6*KDQ - 1/32*m2^8 - 1/4*m3^2*KDQ^3
   - 1/8*m3^4*KDQ^2 - 1/16*m3^6*KDQ - 1/32*m3^8 - 1/2*KDQ^4 )
 
Id,Adiso,KDQ^4*NOM(K,m1~)*NOM(KQ,m2~)*NOM(Q,m3~) = 
 + NOM(K,m1)*NOM(Q,m3)
  * ( - 3/8*m1^2*m2^2*m3^2 - 1/4*m1^2*m2^2*KDQ + 3/16*m1^2*m2^4
  + 1/4*m1^2*m3^2*KDQ + 3/16*m1^2*m3^4 + 1/4*m1^2*KDQ^2 - 3/16*m1^4
  *m2^2 + 3/16*m1^4*m3^2 + 1/8*m1^4*KDQ + 1/16*m1^6 - 1/4*m2^2*m3^2
  *KDQ - 3/16*m2^2*m3^4 - 1/4*m2^2*KDQ^2 + 3/16*m2^4*m3^2
  + 1/8*m2^4*KDQ - 1/16*m2^6 + 1/4*m3^2*KDQ^2 + 1/8*m3^4*KDQ
  + 1/16*m3^6 + 1/2*KDQ^3 )
 
 + NOM(K,m1)*NOM(Q,m3)*NOM(KQ,m2)
  * ( - 3/4*m1^2*m2^2*m3^4 + 3/4*m1^2*m2^4*m3^2 - 1/4*m1^2*m2^6
  + 1/4*m1^2*m3^6 - 3/4*m1^4*m2^2*m3^2 + 3/8*m1^4*m2^4 + 3/8*m1^4*m3^4
   - 1/4*m1^6*m2^2 + 1/4*m1^6*m3^2 + 1/16*m1^8 - 1/4*m2^2*m3^6
  + 3/8*m2^4*m3^4 - 1/4*m2^6*m3^2 + 1/16*m2^8 + 1/16*m3^8 )
 
 + NOM(K,m1)*NOM(KQ,m2)
  * ( 3/8*m1^2*m2^2*m3^2 + 1/4*m1^2*m2^2*KDQ - 3/16*m1^2*m2^4
  - 1/4*m1^2*m3^2*KDQ - 3/16*m1^2*m3^4 - 1/4*m1^2*KDQ^2 + 3/16*m1^4
  *m2^2 - 3/16*m1^4*m3^2 - 1/8*m1^4*KDQ - 1/16*m1^6 + 1/4*m2^2*m3^2
  *KDQ + 3/16*m2^2*m3^4 + 1/4*m2^2*KDQ^2 - 3/16*m2^4*m3^2
  - 1/8*m2^4*KDQ + 1/16*m2^6 - 1/4*m3^2*KDQ^2 - 1/8*m3^4*KDQ
  - 1/16*m3^6 - 1/2*KDQ^3 )
 
 + NOM(Q,m3)*NOM(KQ,m2)
  * ( 3/8*m1^2*m2^2*m3^2 + 1/4*m1^2*m2^2*KDQ - 3/16*m1^2*m2^4
  - 1/4*m1^2*m3^2*KDQ - 3/16*m1^2*m3^4 - 1/4*m1^2*KDQ^2 + 3/16*m1^4
  *m2^2 - 3/16*m1^4*m3^2 - 1/8*m1^4*KDQ - 1/16*m1^6 + 1/4*m2^2*m3^2
  *KDQ + 3/16*m2^2*m3^4 + 1/4*m2^2*KDQ^2 - 3/16*m2^4*m3^2
  - 1/8*m2^4*KDQ + 1/16*m2^6 - 1/4*m3^2*KDQ^2 - 1/8*m3^4*KDQ
  - 1/16*m3^6 - 1/2*KDQ^3 )
 
Id,Adiso,KDQ^3*NOM(K,m1~)*NOM(KQ,m2~)*NOM(Q,m3~) = 
 + NOM(K,m1)*NOM(Q,m3)
  * ( - 1/4*m1^2*m2^2 + 1/4*m1^2*m3^2 + 1/4*m1^2*KDQ + 1/8*m1^4
  - 1/4*m2^2*m3^2 - 1/4*m2^2*KDQ + 1/8*m2^4 + 1/4*m3^2*KDQ
  + 1/8*m3^4 + 1/2*KDQ^2 )
 
 + NOM(K,m1)*NOM(Q,m3)*NOM(KQ,m2)
  * ( - 3/4*m1^2*m2^2*m3^2 + 3/8*m1^2*m2^4 + 3/8*m1^2*m3^4
  - 3/8*m1^4*m2^2 + 3/8*m1^4*m3^2 + 1/8*m1^6 - 3/8*m2^2*m3^4
  + 3/8*m2^4*m3^2 - 1/8*m2^6 + 1/8*m3^6 )
 
 + NOM(K,m1)*NOM(KQ,m2)
  * ( 1/4*m1^2*m2^2 - 1/4*m1^2*m3^2 - 1/4*m1^2*KDQ - 1/8*m1^4
  + 1/4*m2^2*m3^2 + 1/4*m2^2*KDQ - 1/8*m2^4 - 1/4*m3^2*KDQ
  - 1/8*m3^4 - 1/2*KDQ^2 )
 
 + NOM(Q,m3)*NOM(KQ,m2)
  * ( 1/4*m1^2*m2^2 - 1/4*m1^2*m3^2 - 1/4*m1^2*KDQ - 1/8*m1^4
  + 1/4*m2^2*m3^2 + 1/4*m2^2*KDQ - 1/8*m2^4 - 1/4*m3^2*KDQ
  - 1/8*m3^4 - 1/2*KDQ^2 )
 
Id,Adiso,KDQ^2*NOM(K,m1~)*NOM(KQ,m2~)*NOM(Q,m3~) = 
 + NOM(K,m1)*NOM(Q,m3)
  * ( 1/4*m1^2 - 1/4*m2^2 + 1/4*m3^2 + 1/2*KDQ )
 
 + NOM(K,m1)*NOM(Q,m3)*NOM(KQ,m2)
  * ( - 1/2*m1^2*m2^2 + 1/2*m1^2*m3^2 + 1/4*m1^4 - 1/2*m2^2*m3^2
  + 1/4*m2^4 + 1/4*m3^4 )
 
 + NOM(K,m1)*NOM(KQ,m2)
  * ( - 1/4*m1^2 + 1/4*m2^2 - 1/4*m3^2 - 1/2*KDQ )
 
 + NOM(Q,m3)*NOM(KQ,m2)
  * ( - 1/4*m1^2 + 1/4*m2^2 - 1/4*m3^2 - 1/2*KDQ )
 
Id,Adiso,KDQ*NOM(K,m1~)*NOM(KQ,m2~)*NOM(Q,m3~) = 
 + 1/2*NOM(K,m1)*NOM(Q,m3)
 
 + NOM(K,m1)*NOM(Q,m3)*NOM(KQ,m2)
  * ( 1/2*m1^2 - 1/2*m2^2 + 1/2*m3^2 )
 
 - 1/2*NOM(K,m1)*NOM(KQ,m2)
 
 - 1/2*NOM(Q,m3)*NOM(KQ,m2)

Id,KDK^5*NOM(K,m1~) =  - m1^2*KDK^3 + m1^4*KDK^2 - m1^6*KDK + m1^8 + KDK^4
   + NOM(K,m1)  * ( - m1^10 )
 
Al,QDQ^5*NOM(Q,m3~) =   - m3^2*QDQ^3 + m3^4*QDQ^2 - m3^6*QDQ + m3^8 + QDQ^4
   + NOM(Q,m3)  * ( - m3^10 )
 
Id,KDK^4*NOM(K,m1~) =-m1^2*KDK^2 + m1^4*KDK - m1^6 + KDK^3 + NOM(K,m1)*( m1^8 )
 
Al,QDQ^4*NOM(Q,m3~) =  - m3^2*QDQ^2 + m3^4*QDQ - m3^6 + QDQ^3
  + NOM(Q,m3)  * ( m3^8 )
 
Id,KDK^3*NOM(K,m1~) =   - m1^2*KDK + m1^4 + KDK^2 + NOM(K,m1)  * ( - m1^6 )
 
Al,QDQ^3*NOM(Q,m3~) =  - m3^2*QDQ + m3^4 + QDQ^2
  + NOM(Q,m3)  * ( - m3^6 )
 
Id,KDK^2*NOM(K,m1~) =   - m1^2 + KDK+ NOM(K,m1) * ( m1^4 )
 
Al,QDQ^2*NOM(Q,m3~) =  - m3^2 + QDQ + NOM(Q,m3)  * ( m3^4 )
 
Id,KDK*NOM(K,m1~) =  + 1 + NOM(K,m1)  * ( - m1^2 )
 
Al,QDQ*NOM(Q,m3~) =  + 1 + NOM(Q,m3)  * ( - m3^2 ) 
count{}
Id,Commu,NOM
*yep 
ENDBLOCK


BLOCK REDU1{}
Id,KDK^5*NOM(K,m1~) =  - m1^2*KDK^3 + m1^4*KDK^2 - m1^6*KDK + m1^8 + KDK^4
   + NOM(K,m1)  * ( - m1^10 )
 
Al,QDQ^5*NOM(Q,m3~) =   - m3^2*QDQ^3 + m3^4*QDQ^2 - m3^6*QDQ + m3^8 + QDQ^4
   + NOM(Q,m3)  * ( - m3^10 )
 
Id,KDK^4*NOM(K,m1~) =-m1^2*KDK^2 + m1^4*KDK - m1^6 + KDK^3 + NOM(K,m1)*( m1^8 )
 
Al,QDQ^4*NOM(Q,m3~) =  - m3^2*QDQ^2 + m3^4*QDQ - m3^6 + QDQ^3
  + NOM(Q,m3)  * ( m3^8 )
 
Id,KDK^3*NOM(K,m1~) =   - m1^2*KDK + m1^4 + KDK^2 + NOM(K,m1)  * ( - m1^6 )
 
Al,QDQ^3*NOM(Q,m3~) =  - m3^2*QDQ + m3^4 + QDQ^2
  + NOM(Q,m3)  * ( - m3^6 )
 
Id,KDK^2*NOM(K,m1~) =   - m1^2 + KDK+ NOM(K,m1) * ( m1^4 )
 
Al,QDQ^2*NOM(Q,m3~) =  - m3^2 + QDQ + NOM(Q,m3)  * ( m3^4 )
 
Id,KDK*NOM(K,m1~) =  + 1 + NOM(K,m1)  * ( - m1^2 )
 
Al,QDQ*NOM(Q,m3~) =  + 1 + NOM(Q,m3)  * ( - m3^2 ) 
count{}
Id,Commu,NOM
*yep
ENDBLOCK

BLOCK REDU2{}
 
Id,QDQ^5*NOM(Q,m3~) =   - m3^2*QDQ^3 + m3^4*QDQ^2 - m3^6*QDQ + m3^8 + QDQ^4
   + NOM(Q,m3)  * ( - m3^10 )
 
Id,QDQ^4*NOM(Q,m3~) =  - m3^2*QDQ^2 + m3^4*QDQ - m3^6 + QDQ^3
  + NOM(Q,m3)  * ( m3^8 )
 
Id,QDQ^3*NOM(Q,m3~) =  - m3^2*QDQ + m3^4 + QDQ^2
  + NOM(Q,m3)  * ( - m3^6 )
 
Id,QDQ^2*NOM(Q,m3~) =  - m3^2 + QDQ + NOM(Q,m3)  * ( m3^4 )
 
Id,QDQ*NOM(Q,m3~) =  + 1 + NOM(Q,m3)  * ( - m3^2 ) 
count{}
ENDBLOCK

BLOCK ALLKQ{}
Id,NOM(K,m~)=NOM(K1,m)
Al,NOM(Q,m~)=NOM(Q1,m)
Al,KDK=KK2 ; QDQ=QQ2 ; KDQ=KQ2
Id,All,K,N,Fx
Id,All,Q,N,Fy
Id,NOM(K1,m~)=NOM(K,m)
Al,NOM(Q1,m~)=NOM(Q,m)
Al,KK2=KDK ; QQ2=QDQ ; KQ2=KDQ

Id,Adiso,Fx(AL~,BE~)*Fy(GA~,DE~,RO~,SI~,MU~,NU~)=
    D(AL,BE)*DEDE6(GA,DE,RO,SI,MU,NU)*
  ( N77*KDQ^2*QDQ^2 +N79*KDK*QDQ^3)
   + (N97*KDQ^2*QDQ^2 +N99*KDK*QDQ^3)  *(
  + D(AL,GA)*DEDE6(BE,DE,RO,SI,MU,NU)
  + D(AL,DE)*DEDE6(BE,GA,RO,SI,MU,NU)
  + D(AL,RO)*DEDE6(BE,DE,GA,SI,MU,NU)
  + D(AL,SI)*DEDE6(BE,DE,RO,GA,MU,NU)
  + D(AL,MU)*DEDE6(BE,DE,RO,SI,GA,NU)
  + D(AL,NU)*DEDE6(BE,DE,RO,SI,MU,GA)  )

Al,Adiso,Fy(AL~,BE~)*Fx(GA~,DE~,RO~,SI~,MU~,NU~)=
    D(AL,BE)*DEDE6(GA,DE,RO,SI,MU,NU)*
  ( N77*KDQ^2*KDK^2 +N79*KDK^3*QDQ)
   + (N97*KDQ^2*KDK^2 +N99*KDK^3*QDQ)  *(
  + D(AL,GA)*DEDE6(BE,DE,RO,SI,MU,NU)
  + D(AL,DE)*DEDE6(BE,GA,RO,SI,MU,NU)
  + D(AL,RO)*DEDE6(BE,DE,GA,SI,MU,NU)
  + D(AL,SI)*DEDE6(BE,DE,RO,GA,MU,NU)
  + D(AL,MU)*DEDE6(BE,DE,RO,SI,GA,NU)
  + D(AL,NU)*DEDE6(BE,DE,RO,SI,MU,GA)  )

C N77=(-6)/N/[N-1]/[N+2]/[N+4]/[N+6]
C N79=(N+5)/N/[N-1]/[N+2]/[N+4]/[N+6]
C N97=(N)/N/[N-1]/[N+2]/[N+4]/[N+6]
C N99=(-1)/N/[N-1]/[N+2]/[N+4]/[N+6]

Al,Adiso,Fx(AL~,BE~,GA~,DE~)*Fy(RO~,SI~,MU~,NU~)=
    ( nn11*KDK^2*QDQ^2 + nn12*KDK*KDQ^2*QDQ + nn13*KDQ^4 )
    *DEDE4(AL,BE,GA,DE)*DEDE4(SI,RO,MU,NU)*ddd44
   +( nn21*KDK^2*QDQ^2 + nn22*KDK*KDQ^2*QDQ + nn23*KDQ^4 )
    *TTT44(AL,BE,GA,DE,SI,RO,MU,NU)
   +( nn31*KDK^2*QDQ^2 + nn32*KDK*KDQ^2*QDQ + nn33*KDQ^4 )
    *SSS44(AL,BE,GA,DE,SI,RO,MU,NU)

C nn11= ( 90 + 48*N + 6*N^2 ) /6/[N-1]/N/[N+1]/[N+2]/[N+4]/[N+6]
C nn12= ( - 144 - 48*N ) /6/[N-1]/N/[N+1]/[N+2]/[N+4]/[N+6]
C nn13= 48/ 6/[N-1]/N/[N+1]/[N+2]/[N+4]/[N+6]

C nn21= ( - 9 - 3*N ) /6/[N-1]/N/[N+1]/[N+2]/[N+4]/[N+6]
C nn22= ( 18 + 9*N + 3*N^2 ) /6/[N-1]/N/[N+1]/[N+2]/[N+4]/[N+6]
C nn23= ( - 12 - 6*N ) /6/[N-1]/N/[N+1]/[N+2]/[N+4]/[N+6]

C nn31= 6 /6/[N-1]/N/[N+1]/[N+2]/[N+4]/[N+6]
C nn32= ( - 24 - 12*N ) /6/[N-1]/N/[N+1]/[N+2]/[N+4]/[N+6]
C nn33= ( 16 + 12*N + 2*N^2 ) /6/[N-1]/N/[N+1]/[N+2]/[N+4]/[N+6]

Al,Adiso,Fx(AL~,BE~,GA~)*Fy(DE~,RO~,SI~,MU~,NU~)=
   ( nn44*KDK*KDQ*QDQ^2 + nn45*KDQ^3*QDQ )*
  ( D(AL,BE)*DEDE6(GA,DE,RO,SI,MU,NU)
   +D(AL,GA)*DEDE6(BE,DE,RO,SI,MU,NU)
   +D(BE,GA)*DEDE6(AL,DE,RO,SI,MU,NU)  )

  + ( nn54*KDK*KDQ*QDQ^2 + nn55*KDQ^3*QDQ )*
  ( D(AL,DE)*DEDE6(BE,GA,RO,SI,MU,NU)
  + D(AL,RO)*DEDE6(BE,DE,GA,SI,MU,NU)
  + D(AL,SI)*DEDE6(BE,DE,RO,GA,MU,NU)
  + D(AL,MU)*DEDE6(BE,DE,RO,SI,GA,NU)
  + D(AL,NU)*DEDE6(BE,DE,RO,SI,MU,GA)  )

Al,Adiso,Fy(AL~,BE~,GA~)*Fx(DE~,RO~,SI~,MU~,NU~)=
   ( nn44*KDK^2*KDQ*QDQ + nn45*KDQ^3*KDK )*
  ( D(AL,BE)*DEDE6(GA,DE,RO,SI,MU,NU)
   +D(AL,GA)*DEDE6(BE,DE,RO,SI,MU,NU)
   +D(BE,GA)*DEDE6(AL,DE,RO,SI,MU,NU)  )

  + ( nn54*KDK^2*KDQ*QDQ + nn55*KDQ^3*KDK )*
  ( D(AL,DE)*DEDE6(BE,GA,RO,SI,MU,NU)
  + D(AL,RO)*DEDE6(BE,DE,GA,SI,MU,NU)
  + D(AL,SI)*DEDE6(BE,DE,RO,GA,MU,NU)
  + D(AL,MU)*DEDE6(BE,DE,RO,SI,GA,NU)
  + D(AL,NU)*DEDE6(BE,DE,RO,SI,MU,GA)  )

C nn44= (N+4) /[N-1]/N/[N+2]/[N+4]/[N+7] 
C nn45= -5 /[N-1]/N/[N+2]/[N+4]/[N+7]
C nn54= -3 /[N-1]/N/[N+2]/[N+4]/[N+7]
C nn55= (N+2) /[N-1]/N/[N+2]/[N+4]/[N+7]

Al,Adiso,Fx(Naa~)*Fy(Nab~,Nac~,Nad~,Nae~,Naf~,Nag~,Nah~)=
     KDQ*QDQ^3*N88*DEDE8(Naa,Nab,Nac,Nad,Nae,Naf,Nag,Nah)
Al,Adiso,Fy(Naa~)*Fx(Nab~,Nac~,Nad~,Nae~,Naf~,Nag~,Nah~)=
     KDQ*KDK^3*N88*DEDE8(Naa,Nab,Nac,Nad,Nae,Naf,Nag,Nah)
Al,Fy(Naa~,Nab~,Nac~,Nad~,Nae~,Naf~,Nag~,Nah~)=
     QDQ^4*N88*DEDE8(Naa,Nab,Nac,Nad,Nae,Naf,Nag,Nah)
Al,Fx(Naa~,Nab~,Nac~,Nad~,Nae~,Naf~,Nag~,Nah~)=
     KDK^4*N88*DEDE8(Naa,Nab,Nac,Nad,Nae,Naf,Nag,Nah)

C N88=1/N/[N+2]/[N+4]/[N+6]

P output
P output
P lists

*yep
Id,Adiso,Fx(AL~,BE~)*Fy(GA~,DE~,SI~,RO~)=
    D(AL,BE)*DEDE4(GA,DE,RO,SI)*( KDK*QDQ^2*N54 + KDQ^2*QDQ*N55)
   +( KDK*QDQ^2*N44 + KDQ^2*QDQ*N45)*(
  + D(AL,GA)*DEDE4(BE,DE,RO,SI)
  + D(AL,DE)*DEDE4(GA,BE,RO,SI)
  + D(AL,RO)*DEDE4(GA,DE,BE,SI)
  + D(AL,SI)*DEDE4(GA,DE,RO,BE) )

Al,Adiso,Fy(AL~,BE~)*Fx(GA~,DE~,SI~,RO~)=
    D(AL,BE)*DEDE4(GA,DE,RO,SI)*( KDK^2*QDQ*N54 + KDQ^2*KDK*N55)
   +( KDK^2*QDQ*N44 + KDQ^2*KDK*N45)*(
  + D(AL,GA)*DEDE4(BE,DE,RO,SI)
  + D(AL,DE)*DEDE4(GA,BE,RO,SI)
  + D(AL,RO)*DEDE4(GA,DE,BE,SI)
  + D(AL,SI)*DEDE4(GA,DE,RO,BE) )

C N44 = -1/[(N-1)*N*(N+2)*N+4)]
C N45 = N /[(N-1)*N*(N+2)*N+4)]
C N54 = (N+3)/[(N-1)*N*(N+2)*N+4)]
C N55 = -4/[(N-1)*N*(N+2)*N+4)]

Al,Adiso,Fx(AL~,BE~,GA~)*Fy(DE~,RO~,SI~)=
   ( nn66*KDK*QDQ*KDQ + nn67*KDQ^3 )
  *( D(AL,BE)*DEDE4(GA,DE,RO,SI)
    +D(AL,GA)*DEDE4(BE,DE,RO,SI)
    +D(BE,GA)*DEDE4(AL,DE,RO,SI)  )

   + ( nn76*KDK*QDQ*KDQ + nn77*KDQ^3 )
  *( D(AL,DE)*DEDE4(BE,GA,RO,SI)
   + D(AL,RO)*DEDE4(BE,DE,GA,SI)
   + D(AL,SI)*DEDE4(BE,DE,RO,GA)  )

C nn66 = (N+2) /[N-1]/N/[N+2]/[N+5]
C nn67 = -3 /[N-1]/N/[N+2]/[N+5]
C nn76 = -3 /[N-1]/N/[N+2]/[N+5]
C nn77 = (N+2) /[N-1]/N/[N+2]/[N+5]

Al,Adiso,Fx(Naa~)*Fy(Nab~,Nac~,Nad~,Nae~,Naf~)=
     KDQ*QDQ^2*N00*DEDE6(Naa,Nab,Nac,Nad,Nae,Naf)
Al,Adiso,Fy(Naa~)*Fx(Nab~,Nac~,Nad~,Nae~,Naf~)=
     KDQ*KDK^2*N00*DEDE6(Naa,Nab,Nac,Nad,Nae,Naf)
Al,Fy(Naa~,Nab~,Nac~,Nad~,Nae~,Naf~)=
     QDQ^3*N00*DEDE6(Naa,Nab,Nac,Nad,Nae,Naf)
Al,Fx(Naa~,Nab~,Nac~,Nad~,Nae~,Naf~)=
     KDK^3*N00*DEDE6(Naa,Nab,Nac,Nad,Nae,Naf)

C N00=[N*(N+2)*(N+4)]^-1

Al,Adiso,Fx(Naa~,Nab~)*Fy(Nac~,Nad~)=
  D(Naa,Nab)*D(Nac,Nad)*( N11*KDK*QDQ +N12*KDQ^2 )
 +(D(Naa,Nac)*D(Nab,Nad)+D(Naa,Nad)*D(Nac,Nab))*( N21*KDK*QDQ +N22*KDQ^2 )
C N11 = (N+1/N)/[(N-1)*(N+2)]
C N12 = (-2/N)/[(N-1)*(N+2)]
C N21 = (-1/N)/[(N-1)*(N+2)]
C N22 = 1/[(N-1)*(N+2)]

Al,Adiso,Fx(Naa~)*Fy(Nab~,Nac~,Nad~)=
   DEDE4(Naa,Nab,Nac,Nad)*KDQ*QDQ*N30
Al,Adiso,Fy(Naa~)*Fx(Nab~,Nac~,Nad~)=
   DEDE4(Naa,Nab,Nac,Nad)*KDQ*KDK*N30
Al,Fy(Naa~,Nab~,Nac~,Nad~)=
   DEDE4(Naa,Nab,Nac,Nad)*QDQ^2*N30
Al,Fx(Naa~,Nab~,Nac~,Nad~)=
   DEDE4(Naa,Nab,Nac,Nad)*KDK^2*N30
C N30 = [N*(N+2)]^-1

Al,Adiso,Fx(Naa~)*Fy(Nab~)=KDQ*D(Naa,Nab)/N
Al,Fx(Naa~,Nab~)=KDK*D(Naa,Nab)/N
Al,Fy(Naa~,Nab~)=QDQ*D(Naa,Nab)/N
*yep

ENDBLOCK

BLOCK SHIFT{}
IF NOM(KQ,Mb~)
AND NOT NOM(Q,m~)
Id,NOM(KQ,m~)=NOM(Q,m)
Al,Q(MU~)=Q(MU)-K(MU)
Al,Dotpr,Q(MU~)=Q(MU)-K(MU)
Al,Funct,gam,Q(MU~)=Q(MU)-K(MU)
Al,Funct,G,Q(MU~)=Q(MU)-K(MU)
ENDIF

IF NOM(KQ,Mb~)
AND NOT NOM(K,m~)
Id,NOM(KQ,m~)=NOM(K,m)
Al,K(MU~)=-Q(MU)+K(MU)
Al,Dotpr,K(MU~)=-Q(MU)+K(MU)
Al,Funct,gam,K(MU~)=-Q(MU)+K(MU)
Al,Funct,G,K(MU~)=-Q(MU)+K(MU)
ENDIF

ENDBLOCK

BLOCK symme{}
IF NOT NOM(KQ,m~)
Id,KDQ^7=0
Al,KDQ^6=15*N00*KDK^3*QDQ^3
Id,KDQ^5=0
Al,KDQ^4=KDK^2*QDQ^2*N30*3
Al,KDQ^3=0
Al,KDQ^2=KDK*QDQ*N^-1
Al,KDQ=0
ENDIF
ENDBLOCK


BLOCK INFINI{}
P input
Id,Adiso,NOM(K,m~)*NOM(K,m~)*NOM(K,m~)*NOM(K,m~)*NOM(K,m~)*NOM(K,m~)*NOM(K,m~)=
             Fk(7,m)
Al,Adiso,NOM(Q,m~)*NOM(Q,m~)*NOM(Q,m~)*NOM(Q,m~)*NOM(Q,m~)*NOM(Q,m~)*NOM(Q,m~)=
             Fq(7,m)
Id,Adiso,NOM(K,m~)*NOM(K,m~)*NOM(K,m~)*NOM(K,m~)*NOM(K,m~)*NOM(K,m~)=Fk(6,m)
Al,Adiso,NOM(Q,m~)*NOM(Q,m~)*NOM(Q,m~)*NOM(Q,m~)*NOM(Q,m~)*NOM(Q,m~)=Fq(6,m)
Id,Adiso,NOM(K,m~)*NOM(K,m~)*NOM(K,m~)*NOM(K,m~)*NOM(K,m~)=Fk(5,m)
Al,Adiso,NOM(Q,m~)*NOM(Q,m~)*NOM(Q,m~)*NOM(Q,m~)*NOM(Q,m~)=Fq(5,m)
Id,Adiso,NOM(K,m~)*NOM(K,m~)*NOM(K,m~)*NOM(K,m~)=Fk(4,m)
Al,Adiso,NOM(Q,m~)*NOM(Q,m~)*NOM(Q,m~)*NOM(Q,m~)=Fq(4,m)
Id,Adiso,NOM(K,m~)*NOM(K,m~)*NOM(K,m~)=Fk(3,m)
Al,Adiso,NOM(Q,m~)*NOM(Q,m~)*NOM(Q,m~)=Fq(3,m)
Id,Adiso,NOM(K,m~)*NOM(K,m~)=Fk(2,m)
Al,Adiso,NOM(Q,m~)*NOM(Q,m~)=Fq(2,m)
Id,NOM(K,m~)=Fk(1,m)
Al,NOM(Q,m~)=Fq(1,m)
Al,NOM(KQ,m~)=Fkq(1,m)
*yep
DO J4=1,7
Id,Adiso,Fk(n~,Mb~)*Fk(l~,Ms~)=
   difInv(Ms,Mb)*Fk(n,Mb)*Fk(l-1,Ms)
  -difInv(Ms,Mb)*Fk(n-1,Mb)*Fk(l,Ms)
Al,Adiso,Fq(n~,Mb~)*Fq(l~,Ms~)=
   difInv(Ms,Mb)*Fq(n,Mb)*Fq(l-1,Ms)
  -difInv(Ms,Mb)*Fq(n-1,Mb)*Fq(l,Ms)
Id,Asymme,difInv,1,2
Al,Fk(0,m~)=1 ;Fq(0,Mb~)=1
ENDDO
Id,Commu,Fk,Fkq,Fq
Al,difInv(PM~,PM~)=zero1
Al,difInv(Ms~,PM)=Ms^-2
Al,difInv(PM,Ms~)=-Ms^-2
*yep
IF NOT Fkq(n~,m~)
Id,Fk(n~,m~)=F(n,m)
Al,Fq(n~,m~)=F(n,m)
ENDIF
Id,Adiso,Fk(1,m~)*Fq(1,Mb~)*Fkq(1,Ms~)=f111(m,Mb,Ms)
Id,Adiso,Fk(1,m~)*Fq(n~,Mb~)*Fkq(1,Ms~)=fff(n,Mb)
Id,Adiso,Fk(n~,m~)*Fq(1,Mb~)*Fkq(1,Ms~)=fff(n,m)
Id,Adiso,Fk(1,m~)*Fq(1,Mb~)*Fkq(n~,Ms~)=fff(n,Ms)

Id,fff(2,Mt~) =  - 2*EP^-2*Pi4 + EP^-1*Pi4 - 2*EP^-1*Pi4*Euler
  - 2*EP^-1*Pi4*xpi
 
 + log(Mt)
  * ( - 2*EP^-1*Pi4 )
 
Al,fff(3,Mt~) =  + Mt^-2*EP^-1*Pi4
 
Al,fff(4,Mt~) =  + 1/3*Mt^-4*EP^-1*Pi4
 
Al,fff(5,Mt~) =  + 1/6*Mt^-6*EP^-1*Pi4 + 0.

Al,fff(6,Mt~) =  + 1/10*Mt^-8*EP^-1*Pi4 

Al,fff(7,Mt~) =  + 1/15*Mt^-10*EP^-1*Pi4 
 
Al,f111(m1~,m2~,m3~) = 
  + 2*EP^-2*Pi4*m1^2 + 2*EP^-2*Pi4*m2^2 + 2*EP^-2*Pi4*m3^2
  - 3*EP^-1*Pi4*m1^2 - 3*EP^-1*Pi4*m2^2 - 3*EP^-1*Pi4*m3^2
  + 2*EP^-1*Pi4*Euler*m1^2 + 2*EP^-1*Pi4*Euler*m2^2 + 2*EP^-1*Pi4*Euler
  *m3^2 + 2*EP^-1*Pi4*xpi*m1^2 + 2*EP^-1*Pi4*xpi*m2^2 + 2*EP^-1*Pi4
  *xpi*m3^2
 
 + log(m1)
  * ( 2*EP^-1*Pi4*m1^2 )
 
 + log(m2)
  * ( 2*EP^-1*Pi4*m2^2 )
 
 + log(m3)
  * ( 2*EP^-1*Pi4*m3^2 ) + 0.

Al,F(1,m~) =  + 2*i*EP^-1*Pi^2*m^2 - i*Pi^2*m^2 + i*Pi^2*Euler*m^2
  + i*Pi^2*xpi*m^2
 
 + log(m)
  * ( i*Pi^2*m^2 )
 
Al,F(2,m~) =  - 2*i*EP^-1*Pi^2 - i*Pi^2*Euler - i*Pi^2*xpi
 
 + log(m)
  * ( - i*Pi^2 )
 
Al,F(3,m~) =  + 1/2*i*Pi^2*m^-2
 
Al,F(4,m~) =  + 1/6*i*Pi^2*m^-4
 
Al,F(5,m~) =  + 1/12*i*Pi^2*m^-6 

Al,F(6,m~) =  + 1/20*i*Pi^2*m^-8

Al,F(7,m~) =  + 1/30*i*Pi^2*m^-10
 
Id,PM=0
Al,Pi4=Pi^4
Al,Commu,log
IF NOT Multi,EP^-1
Id,Addfa,0
ENDIF
*yep
ENDBLOCK

BLOCK NUMBER{}
IF EP^-2
Id,N88=N00*N6
C N6 =[N+6]^-1
Al,N^4 =  + 256 + 256*EP
Al,N^3 =  + 64 +48*EP
Al,N^2 =  + 16 + 8*EP
Id,N =  + 4 + EP
Al,Multi,N^-1 =  + 1/4 - 1/16*EP
Al,N77 =  - 1/960 + 13/12800*EP
Al,N79 =  + 1/640 - 311/230400*EP
Al,N97 =  + 1/1440 - 29/57600*EP
Al,N99 =  - 1/5760 + 13/76800*EP 
Al,N44 =  - 1/576 + 7/4608*EP
Al,N45 =  + 1/144 - 5/1152*EP
Al,N54 =  + 7/576 - 41/4608*EP
Al,N55 =  - 1/144 + 7/1152*EP
Al,N00 =  + 1/192 - 13/4608*EP
Al,N11 =  + 5/72 - 11/288*EP 
Al,N12 =  - 1/36 + 1/48*EP
Al,N21 =  - 1/72 + 1/96*EP
Al,N22 =  + 1/18 - 1/36*EP
Al,N30 =  + 1/24 - 5/288*EP
Al,N6  = 1/10 - 1/100*EP
ENDIF

IF NOT Multi,EP^-1
Id,Addfa,0
ENDIF
*yep

IF EP^-2
Id,nn11 =  + 7/3200 - 2321/1152000*EP
Al,nn12 =  - 7/3600 + 289/144000*EP
Al,nn13 =  + 1/3600 - 47/144000*EP
Al,nn21 =  - 7/57600 + 289/2304000*EP
Al,nn22 =  + 17/28800 - 193/384000*EP
Al,nn23 =  - 1/4800 + 121/576000*EP
Al,nn31 =  + 1/28800 - 47/1152000*EP
Al,nn32 =  - 1/2400 + 121/288000*EP
Al,nn33 =  + 1/1800 - 53/108000*EP
Al,nn44 =  + 1/792 - 37/34848*EP
Al,nn45 =  - 5/6336 + 425/557568*EP
Al,nn54 =  - 1/2112 + 85/185856*EP
Al,nn55 =  + 1/1056 - 211/278784*EP
Al,nn66 =  + 1/108 - 25/3888*EP
Al,nn67 =  - 1/216 + 31/7776*EP
Al,nn76 =  - 1/216 + 31/7776*EP
Al,nn77 =  + 1/108 - 25/3888*EP + 0.

ENDIF

IF NOT Multi,EP^-1
Id,Addfa,0
ENDIF
*yep

IF EP^-1
Id,N88=N00*N6
C N6 =[N+6]^-1
Al,N^4 =  + 256 
Al,N^3 =  + 64 
Al,N^2 =  + 16 
Id,N =  + 4 
Al,Multi,N^-1 =  + 1/4 
Al,N77 =  - 1/960 
Al,N79 =  + 1/640 
Al,N97 =  + 1/1440 
Al,N99 =  - 1/5760 
Al,N44 =  - 1/576 
Al,N45 =  + 1/144 
Al,N54 =  + 7/576 
Al,N55 =  - 1/144 
Al,N00 =  + 1/192 
Al,N11 =  + 5/72 
Al,N12 =  - 1/36 
Al,N21 =  - 1/72 
Al,N22 =  + 1/18 
Al,N30 =  + 1/24 
Al,N6  = 1/10 
ENDIF

IF NOT Multi,EP^-1
Id,Addfa,0
ENDIF
*yep

IF EP^-1
Id,nn11 =  + 7/3200 
Al,nn12 =  - 7/3600 
Al,nn13 =  + 1/3600 
Al,nn21 =  - 7/57600 
Al,nn22 =  + 17/28800 
Al,nn23 =  - 1/4800 
Al,nn31 =  + 1/28800 
Al,nn32 =  - 1/2400 
Al,nn33 =  + 1/1800 
Al,nn44 =  + 1/792 
Al,nn45 =  - 5/6336 
Al,nn54 =  - 1/2112 
Al,nn55 =  + 1/1056 
Al,nn66 =  + 1/108 
Al,nn67 =  - 1/216 
Al,nn76 =  - 1/216 
Al,nn77 =  + 1/108 

ENDIF

IF NOT Multi,EP^-1
Id,Addfa,0
ENDIF
*yep

ENDBLOCK

BLOCK ZERO{}

IF NOT NOM(KQ,Mb~)
AND NOT NOM(Q,Ms~)
Id,Addfa,0
ENDIF

IF NOT NOM(KQ,Mb~)
AND NOT NOM(K,Ms~)
Id,Addfa,0
ENDIF

IF NOT NOM(K,Mb~)
AND NOT NOM(Q,Ms~)
Id,Addfa,0
ENDIF

ENDBLOCK

BLOCK RATNOM{K,m1,m2}
IF Adiso,NOM('K','m1')*NOM('K','m2')
Id,NOM('K','m1')=['K'+X'm1']^-1
Al,NOM('K','m2')=['K'+X'm2']^-1
Id,Ratio,['K'+X'm1'],['K'+X'm2'],['m2'^2-'m1'^2]
Id,Multi,['K'+X'm1']^-1=NOM('K','m1')
Id,Multi,['K'+X'm2']^-1=NOM('K','m2')
ENDIF
ENDBLOCK

BLOCK RAT{K,m1}
IF 'K'D'K'^n~*NOM('K','m1')
Id,NOM('K','m1')=['K'+X'm1']^-1
Al,'K'D'K'^n~=X'K'^n
Id,Ratio,X'K',['K'+X'm1'],X'm1'
Id,Multi,['K'+X'm1']^-1=NOM('K','m1')
Al,X'm1'^n~='m1'^(2*n)
Al,X'K'^n~='K'D'K'^n
ENDIF
ENDBLOCK

BLOCK RATKQ{K,m1,KQ,m2,Q,m3}

Id,'K'D'Q'^n~=2^(-n)*
    DS{J1,0,n,
    ( ['K''KQ'+X'm1''m2']^J1*['Q'+'m1''m2''m3']^(n-J1) ),((n+1-J1)/J1)
      }
Id,NOM('K','m1')=['K'+X'm1']^-1
Al,NOM('KQ','m2')=['KQ'+X'm2']^-1
Al,NOM('Q','m3')=['Q'+X'm3']^-1
Al,['K''KQ'+X'm1''m2']^n~=
    DS{J1,0,n,
     ( ['KQ'+X'm2']^J1*(-1)^(n-J1)*['K'+X'm1']^(n-J1) ),((n+1-J1)/J1)
      }
Al,['Q'+'m1''m2''m3']^n~=
    DS{J1,0,n,
     (['Q'+X'm3']^J1*(-1)^J1*['m1''m2''m3']^(n-J1) ),((n+1-J1)/J1)
      }
Al,'K'D'K'^n~=DS{J1,0,n,((-1)^J1*X'm1'^J1*['K'+X'm1']^(n-J1) ),((n+1-J1)/J1) }
Al,'Q'D'Q'^n~=DS{J1,0,n,((-1)^J1*X'm3'^J1*['Q'+X'm3']^(n-J1) ),((n+1-J1)/J1) }

IF NOT Multi,['KQ'+X'm2']^-1
AND NOT Multi,['K'+X'm1']^-1
Id,Addfa,0
ENDIF

IF NOT Multi,['KQ'+X'm2']^-1
AND NOT Multi,['Q'+X'm3']^-1
Al,Addfa,0
ENDIF

IF NOT Multi,['K'+X'm1']^-1
AND NOT Multi,['Q'+X'm3']^-1
Al,Addfa,0
ENDIF

Id,Count,xk,['K'+X'm1'],-2,['KQ'+X'm2'],-2
Al,Count,xq,['Q'+X'm3'],-2,['KQ'+X'm2'],-2
Al,Count,XXKQ,['Q'+X'm3'],-2,['KQ'+X'm2'],-2,['K'+X'm1'],-2
Al,Addfa,xk^-4*xq^-4*XXKQ^-8

IF xq
AND xk
AND XXKQ
Id,Addfa,0
ELSE
Al,xk^n~=1 ;xq^n~=1 ;XXKQ^n~=1
ENDIF

C Now we shift :

IF Multi,['KQ'+X'm2']^-1
AND NOT Multi,['K'+X'm1']^-1
Al,['KQ'+X'm2']^n~=['K'+X'm2']^n
Al,['K'+X'm1']^l~=['KQ'+X'm1']^l
ENDIF

IF Multi,['KQ'+X'm2']^-1
AND NOT Multi,['Q'+X'm3']^-1
Al,['KQ'+X'm2']^n~=['Q'+X'm2']^n
Al,['Q'+X'm3']^l~=['KQ'+X'm3']^l
ENDIF

IF ['KQ'+X'm1']
Al,['KQ'+X'm1']^n~=
    DS{J1,0,n,
     (['K'_'Q'+X'm1']^J1*FlagA^(n-J1)*X'KQ'^(n-J1)),((n+1-J1)/J1)
      }
ENDIF
IF ['KQ'+X'm2']
Al,['KQ'+X'm2']^n~=
    DS{J1,0,n,
     (['K'_'Q'+X'm2']^J1*FlagA^(n-J1)*X'KQ'^(n-J1)),((n+1-J1)/J1)
      }
ENDIF
IF ['KQ'+X'm3']
Al,['KQ'+X'm3']^n~=
    DS{J1,0,n,
     (['K'_'Q'+X'm3']^J1*FlagA^(n-J1)*X'KQ'^(n-J1)),((n+1-J1)/J1)
      }
ENDIF
Id,Multi,FlagA^2=1
Id,FlagA=0
Al,X'KQ'^n~=2^n*R(n)*'K'D'K'^(n/2)*'Q'D'Q'^(n/2)
Al,['K'_'Q'+X'm1']^n~=
    DS{J1,0,n,(X'm1'^J1*['K'_'Q']^(n-J1) ),((n+1-J1)/J1) }
Al,['K'_'Q'+X'm2']^n~=
    DS{J1,0,n,(X'm2'^J1*['K'_'Q']^(n-J1) ),((n+1-J1)/J1) }
Al,['K'_'Q'+X'm3']^n~=
    DS{J1,0,n,(X'm3'^J1*['K'_'Q']^(n-J1) ),((n+1-J1)/J1) }
Id,['K'_'Q']^n~=
  DS{J1,0,n,('K'D'K'^J1*'Q'D'Q'^(n-J1) ),((n+1-J1)/J1) }
Al,Multi,['K'+X'm1']^-1=NOM('K','m1')
Al,Multi,['K'+X'm2']^-1=NOM('K','m2')
Al,Multi,['K'+X'm3']^-1=NOM('K','m3')
Al,Multi,['Q'+X'm1']^-1=NOM('Q','m1')
Al,Multi,['Q'+X'm2']^-1=NOM('Q','m2')
Al,Multi,['Q'+X'm3']^-1=NOM('Q','m3')
Al,Multi,['KQ'+X'm1']^-1=NOM('KQ','m1')
Al,Multi,['KQ'+X'm2']^-1=NOM('KQ','m2')
Al,Multi,['KQ'+X'm3']^-1=NOM('KQ','m3')
Al,['m2''m2''m3']^n~='m3'^(2*n)
Al,['m1''m2''m2']^n~='m1'^(2*n)
Al,['m1''m2''m3']^n~=
  DS{J1,0,n,('m3'^(2*J1)*[X'm1'-X'm2']^(n-J1) ),((n+1-J1)/J1) }
Al,X'm1'^n~='m1'^(2*n)
Al,X'm2'^n~='m2'^(2*n)
Al,X'm3'^n~='m3'^(2*n)
Id,[X'm1'-X'm2']^n~=
  DS{J1,0,n,('m1'^(2*J1)*(-1)^(n-J1)*'m2'^(2*n-2*J1) ),((n+1-J1)/J1) }
*yep
RAT{'K','m1'}
RAT{'K','m2'}
RAT{'K','m3'}
ZERO{}
count{}
*yep
RAT{'Q','m1'}
RAT{'Q','m2'}
RAT{'Q','m3'}
ZERO{}
count{}
*yep

Id,NOM('K','m1')=['K'+X'm1']^-1
Al,NOM('K','m2')=['K'+X'm2']^-1
Al,NOM('K','m3')=['K'+X'm3']^-1
Al,NOM('KQ','m1')=['KQ'+X'm1']^-1
Al,NOM('KQ','m2')=['KQ'+X'm2']^-1
Al,NOM('KQ','m3')=['KQ'+X'm3']^-1
Al,NOM('Q','m1')=['Q'+X'm1']^-1
Al,NOM('Q','m2')=['Q'+X'm2']^-1
Al,NOM('Q','m3')=['Q'+X'm3']^-1

Id,['K'+X'm1']^n~=Fk(-n,'m1')
Al,['K'+X'm2']^n~=Fk(-n,'m2')
Al,['K'+X'm3']^n~=Fk(-n,'m3')
Al,['Q'+X'm1']^n~=Fq(-n,'m1')
Al,['Q'+X'm2']^n~=Fq(-n,'m2')
Al,['Q'+X'm3']^n~=Fq(-n,'m3')
Al,['KQ'+X'm1']^n~=Fkq(-n,'m1')
Al,['KQ'+X'm2']^n~=Fkq(-n,'m2')
Al,['KQ'+X'm3']^n~=Fkq(-n,'m3')

Id,Adiso,Fk(1,a~)*Fq(1,b~)*Fkq(1,c~)=f111(a,b,c)
Al,Adiso,Fk(n~,a~)*Fq(1,b~)*Fkq(1,c~)=fff(n,a)
Al,Adiso,Fk(1,a~)*Fq(n~,b~)*Fkq(1,c~)=fff(n,b)
Al,Adiso,Fk(1,a~)*Fq(1,b~)*Fkq(n~,c~)=fff(n,c)
IF NOT Fkq(n~,a~)
Id,Adiso,Fk(n~,a~)*Fq(l~,b~)=F(n,a)*F(l,b)
ENDIF
IF Fk(n~,a~)
OR Fq(n~,b~)
Id,Print,1,error line 857 in BLOCKS_1 :
Id,Addfa,ddd(error1,error2)
Id,ddd(AL~,BE~)=D(AL,BE)
ENDIF
Id,fff(2,Mt~) =  - 2*EP^-2*Pi4 + EP^-1*Pi4 - 2*EP^-1*Pi4*Euler
  - 2*EP^-1*Pi4*xpi
 
 + log(Mt)
  * ( - 2*EP^-1*Pi4 )
 
Al,fff(3,Mt~) =  + Mt^-2*EP^-1*Pi4
 
Al,fff(4,Mt~) =  + 1/3*Mt^-4*EP^-1*Pi4
 
Al,fff(5,Mt~) =  + 1/6*Mt^-6*EP^-1*Pi4 + 0.

Al,fff(6,Mt~) =  + 1/10*Mt^-8*EP^-1*Pi4 

Al,fff(7,Mt~) =  + 1/15*Mt^-10*EP^-1*Pi4 

Al,fff(8,Mt~) =  + 1/21*Mt^-12*EP^-1*Pi4 

Al,fff(9,Mt~) =  + 1/28*Mt^-14*EP^-1*Pi4 

Al,f111(m1~,m2~,m3~) = 
  + 2*EP^-2*Pi4*m1^2 + 2*EP^-2*Pi4*m2^2 + 2*EP^-2*Pi4*m3^2
  - 3*EP^-1*Pi4*m1^2 - 3*EP^-1*Pi4*m2^2 - 3*EP^-1*Pi4*m3^2
  + 2*EP^-1*Pi4*Euler*m1^2 + 2*EP^-1*Pi4*Euler*m2^2 + 2*EP^-1*Pi4*Euler
  *m3^2 + 2*EP^-1*Pi4*xpi*m1^2 + 2*EP^-1*Pi4*xpi*m2^2 + 2*EP^-1*Pi4
  *xpi*m3^2
 
 + log(m1)
  * ( 2*EP^-1*Pi4*m1^2 )
 
 + log(m2)
  * ( 2*EP^-1*Pi4*m2^2 )
 
 + log(m3)
  * ( 2*EP^-1*Pi4*m3^2 ) + 0.

Al,F(1,m~) =  + 2*i*EP^-1*Pi^2*m^2 - i*Pi^2*m^2 + i*Pi^2*Euler*m^2
  + i*Pi^2*xpi*m^2
 
 + log(m)
  * ( i*Pi^2*m^2 )
 
Al,F(2,m~) =  - 2*i*EP^-1*Pi^2 - i*Pi^2*Euler - i*Pi^2*xpi
 
 + log(m)
  * ( - i*Pi^2 )
 
Al,F(3,m~) =  + 1/2*i*Pi^2*m^-2
 
Al,F(4,m~) =  + 1/6*i*Pi^2*m^-4
 
Al,F(5,m~) =  + 1/12*i*Pi^2*m^-6 

Al,F(6,m~) =  + 1/20*i*Pi^2*m^-8

Al,F(7,m~) =  + 1/30*i*Pi^2*m^-10

Al,F(8,m~) =  + 1/42*i*Pi^2*m^-12

Al,F(9,m~) =  + 1/56*i*Pi^2*m^-14

IF NOT Multi,EP^-1
Id,Addfa,0
ENDIF
Al,Pi4=Pi^4
Al,Commu,log
*yep
Id,R(2)=N^-1
Al,R(4)=N30*3
Al,R(6)=15*N00
Al,R(8)=105*N88
Al,R(10)=hoopR0
Al,R(12)=hoopR2
NUMBER{}

ENDBLOCK

BLOCK nota{}
Id,XXX6_1=gam(MU)*gam(P2)*gam(P1)*gam6
Al,XXX6_2=gam(MU)*gam(P2)*gam6
Al,XXX6_3=gam(MU)*gam(P1)*gam6
Al,XXX6_4=gam(P1)*P1(MU)*gam6
Al,XXX6_5=gam(P1)*P2(MU)*gam6
Al,XXX6_6=gam(P2)*P1(MU)*gam6
Al,XXX6_7=gam(P2)*P2(MU)*gam6
Al,XXX6_8=gam(MU)*gam6
Al,XXX6_9=P1(MU)*gam6
Al,XXX6_0=P2(MU)*gam6

Al,XXX7_1=gam(MU)*gam(P2)*gam(P1)*gam7
Al,XXX7_2=gam(MU)*gam(P2)*gam7
Al,XXX7_3=gam(MU)*gam(P1)*gam7
Al,XXX7_4=gam(P1)*P1(MU)*gam7
Al,XXX7_5=gam(P1)*P2(MU)*gam7
Al,XXX7_6=gam(P2)*P1(MU)*gam7
Al,XXX7_7=gam(P2)*P2(MU)*gam7
Al,XXX7_8=gam(MU)*gam7
Al,XXX7_9=P1(MU)*gam7
Al,XXX7_0=P2(MU)*gam7
ENDBLOCK

BLOCK NOTA{}
Id,Adiso,G(s3,"S,"5,Naa~,Nab~)*Epf(AL~,BE~,GA~,DE~)=
     gam(Naa)*gam(Nab)*Xepf(AL,BE,GA,DE)*(gam6-gam7)
Al,Adiso,G(s3,"S,"4,Naa~,Nab~)*Epf(AL~,BE~,GA~,DE~)=
     gam(Naa)*gam(Nab)*Xepf(AL,BE,GA,DE)*(gam6+gam7)
Al,Adiso,G(s3,"S,"5,Naa~)*Epf(AL~,BE~,GA~,DE~)=
    -gam(Naa)*Xepf(AL,BE,GA,DE)*(gam6-gam7)
Al,Adiso,G(s3,"S,"4,Naa~)*Epf(AL~,BE~,GA~,DE~)=
    gam(Naa)*Xepf(AL,BE,GA,DE)*(gam6+gam7)

Id,Adiso,G(s3,"S,"5,Naa~,Nab~)=
     gam(Naa)*gam(Nab)*(gam6-gam7)
Al,Adiso,G(s3,"S,"4,Naa~,Nab~)=
     gam(Naa)*gam(Nab)*(gam6+gam7)
Al,Adiso,G(s3,"S,"5,Naa~)=
    -gam(Naa)*(gam6-gam7)
Al,Adiso,G(s3,"S,"4,Naa~)=
    gam(Naa)*(gam6+gam7)
Al,G5(s3)=gam6-gam7
Al,Gi(s3)= gam6+gam7
Id,4,gam(MU~)*gam(P1)=-gam(P1)*gam(MU)+2*P1(MU)
Id,4,gam(MU~)*gam(P2)=-gam(P2)*gam(MU)+2*P2(MU)
Id,4,gam(AL~)*gam(MU)=-gam(MU)*gam(AL)+2*D(MU,AL)
Id,Asymm,Xepf,1,2,3,4
Id,All,P1,Fx
Al,All,P2,Fy

Id,gam(MU~)*gam(NU~)*Xepf(MU~,NU~,AL~,BE~)=
 + D(AL,BE)
  * ( 2*gam5 )
 + gam(AL)*gam(BE)
  * ( - 2*gam5 ) + 0.
Al,gam(MU~)*gam(NU~)*Xepf(MU~,BE~,NU~,AL~)=
 + D(AL,BE)
  * ( 2*gam5 )
 + gam(AL)*gam(BE)
  * ( - 2*gam5 ) + 0.
Al,gam(MU~)*gam(NU~)*Xepf(MU~,AL~,BE~,NU~)=
 + D(AL,BE)
  * ( 2*gam5 )
 + gam(AL)*gam(BE)
  * ( - 2*gam5 ) + 0.

Al,gam(MU~)*gam(NU~)*Xepf(BE~,MU~,NU~,AL~)=
 + D(AL,BE)
  * ( 2*gam5 )
 + gam(AL)*gam(BE)
  * ( - 2*gam5 ) + 0.
Al,gam(MU~)*gam(NU~)*Xepf(AL~,MU~,BE~,NU~)=
 + D(AL,BE)
  * ( 2*gam5 )
 + gam(AL)*gam(BE)
  * ( - 2*gam5 ) + 0.
Al,gam(MU~)*gam(NU~)*Xepf(NU~,MU~,AL~,BE~)=
 + D(AL,BE)
  * ( 2*gam5 )
 + gam(AL)*gam(BE)
  * ( - 2*gam5 ) + 0.

Al,gam(MU~)*gam(NU~)*Xepf(AL~,BE~,MU~,NU~)=
 + D(AL,BE)
  * ( 2*gam5 )
 + gam(AL)*gam(BE)
  * ( - 2*gam5 ) + 0.
Al,gam(MU~)*gam(NU~)*Xepf(NU~,AL~,MU~,BE~)=
 + D(AL,BE)
  * ( 2*gam5 )
 + gam(AL)*gam(BE)
  * ( - 2*gam5 ) + 0.
Al,gam(MU~)*gam(NU~)*Xepf(BE~,NU~,MU~,AL~)=
 + D(AL,BE)
  * ( 2*gam5 )
 + gam(AL)*gam(BE)
  * ( - 2*gam5 ) + 0.

Al,gam(MU~)*gam(NU~)*Xepf(NU~,AL~,BE~,MU~)=
 + D(AL,BE)
  * ( 2*gam5 )
 + gam(AL)*gam(BE)
  * ( - 2*gam5 ) + 0.
Al,gam(MU~)*gam(NU~)*Xepf(BE~,NU~,AL~,MU~)=
 + D(AL,BE)
  * ( 2*gam5 )
 + gam(AL)*gam(BE)
  * ( - 2*gam5 ) + 0.
Al,gam(MU~)*gam(NU~)*Xepf(AL~,BE~,NU~,MU~)=
 + D(AL,BE)
  * ( 2*gam5 )
 + gam(AL)*gam(BE)
  * ( - 2*gam5 ) + 0.

Al,gam(MU~)*Xepf(MU~,NU~,AL~,BE~)=
 + gam(NU)*D(AL,BE)
  * ( - gam5 )
 + gam(NU)*gam(AL)*gam(BE)
  * ( gam5 )
 + gam(AL)*D(NU,BE)
  * ( gam5 )
 + gam(BE)*D(NU,AL)
  * ( - gam5 ) + 0.

Al,gam(MU~)*Xepf(BE~,MU~,NU~,AL~)=
 + gam(NU)*D(AL,BE)
  * ( - gam5 )
 + gam(NU)*gam(AL)*gam(BE)
  * ( gam5 )
 + gam(AL)*D(NU,BE)
  * ( gam5 )
 + gam(BE)*D(NU,AL)
  * ( - gam5 ) + 0.

Al,gam(MU~)*Xepf(AL~,BE~,MU~,NU~)=
 + gam(NU)*D(AL,BE)
  * ( - gam5 )
 + gam(NU)*gam(AL)*gam(BE)
  * ( gam5 )
 + gam(AL)*D(NU,BE)
  * ( gam5 )
 + gam(BE)*D(NU,AL)
  * ( - gam5 ) + 0.

Al,gam(MU~)*Xepf(NU~,AL~,BE~,MU~)=
 + gam(NU)*D(AL,BE)
  * ( - gam5 )
 + gam(NU)*gam(AL)*gam(BE)
  * ( gam5 )
 + gam(AL)*D(NU,BE)
  * ( gam5 )
 + gam(BE)*D(NU,AL)
  * ( - gam5 ) + 0.

Id,Iall,P1,Fx
Al,Iall,P2,Fy
*yep

Id,gam5=gam6-gam7

DO JO=1,5
Id,gam6*gam7=0 ;gam7*gam6=0 ;gam6*gam6=gam6 ;gam7*gam7=gam7
Al,gam6*gam(AL~)=gam(AL)*gam7
Al,gam7*gam(AL~)=gam(AL)*gam6
ENDDO
*yep
DO IJ=1,6
Id,gam(AL~)*gam(MU)=-gam(MU)*gam(AL)+2*D(AL,MU)
Al,gam(MU~)*gam(MU~)=D(MU,MU)
ENDDO
DO IK=1,6
Id,gam(P1)*gam(MU~)=-gam(MU)*gam(P1)+2*P1(MU)
Al,gam(MU~)*gam(MU~)=D(MU,MU)
ENDDO
 
ENDBLOCK

BLOCK g5g5{}
Id,gam6(s2~,s1)=gam6
Al,gam7(s2~,s1)=gam7
C Id,Commu,gam6,gam7
Id,Order,0,gam

DO I7=1,5
Id,gam(MU~)*gam(AL~)*gam(BE~)*gam(GA~)*gam(DE~)*gam(SI~)*gam(RO~)*gam(MU~)=
 + gam(AL)*gam(BE)*gam(GA)*gam(DE)*gam(SI)*gam(RO)*D(MU,MU)
 - 2*gam(AL)*gam(BE)*gam(GA)*gam(DE)*gam(SI)*gam(MU)*D(RO,MU)
 + 2*gam(AL)*gam(BE)*gam(GA)*gam(DE)*gam(RO)*gam(MU)*D(SI,MU)
 - 2*gam(AL)*gam(BE)*gam(GA)*gam(SI)*gam(RO)*gam(MU)*D(DE,MU)
 + 2*gam(AL)*gam(BE)*gam(DE)*gam(SI)*gam(RO)*gam(MU)*D(GA,MU)
 - 2*gam(AL)*gam(GA)*gam(DE)*gam(SI)*gam(RO)*gam(MU)*D(BE,MU)
 + 2*gam(BE)*gam(GA)*gam(DE)*gam(SI)*gam(RO)*gam(MU)*D(AL,MU) + 0.
Al,gam(MU~)*gam(AL~)*gam(BE~)*gam(GA~)*gam(DE~)*gam(SI~)*gam(MU~)=
 - gam(AL)*gam(BE)*gam(GA)*gam(DE)*gam(SI)*D(MU,MU)
 + 2*gam(AL)*gam(BE)*gam(GA)*gam(DE)*gam(MU)*D(SI,MU)
 - 2*gam(AL)*gam(BE)*gam(GA)*gam(SI)*gam(MU)*D(DE,MU)
 + 2*gam(AL)*gam(BE)*gam(DE)*gam(SI)*gam(MU)*D(GA,MU)
 - 2*gam(AL)*gam(GA)*gam(DE)*gam(SI)*gam(MU)*D(BE,MU)
 + 2*gam(BE)*gam(GA)*gam(DE)*gam(SI)*gam(MU)*D(AL,MU) + 0.
Al,gam(MU~)*gam(AL~)*gam(BE~)*gam(GA~)*gam(DE~)*gam(MU~)=
 + gam(AL)*gam(BE)*gam(GA)*gam(DE)*D(MU,MU)
 - 2*gam(AL)*gam(BE)*gam(GA)*gam(MU)*D(DE,MU)
 + 2*gam(AL)*gam(BE)*gam(DE)*gam(MU)*D(GA,MU)
 - 2*gam(AL)*gam(GA)*gam(DE)*gam(MU)*D(BE,MU)
 + 2*gam(BE)*gam(GA)*gam(DE)*gam(MU)*D(AL,MU) + 0.
Al,gam(MU~)*gam(AL~)*gam(BE~)*gam(GA~)*gam(MU~)=
 - gam(AL)*gam(BE)*gam(GA)*D(MU,MU)
 + 2*gam(AL)*gam(BE)*gam(MU)*D(GA,MU)
 - 2*gam(AL)*gam(GA)*gam(MU)*D(BE,MU)
 + 2*gam(BE)*gam(GA)*gam(MU)*D(AL,MU) + 0.
Al,gam(MU~)*gam(AL~)*gam(BE~)*gam(MU~)=
  + gam(AL)*gam(BE)*D(MU,MU)
 - 2*gam(AL)*gam(MU)*D(BE,MU)
 + 2*gam(BE)*gam(MU)*D(AL,MU) + 0.
Al,gam(MU~)*gam(AL~)*gam(MU~)=
 - gam(AL)*D(MU,MU)
 + 2*gam(MU)*D(AL,MU) + 0.
Al,gam(MU~)*gam(MU~)=D(MU,MU)
ENDDO
*yep
Id,gam(AL~)*gam(MU)=-gam(MU)*gam(AL)+2*D(AL,MU)
Id,gam(AL~)*gam(MU)=-gam(MU)*gam(AL)+2*D(AL,MU)
Id,gam(AL~)*gam(MU)=-gam(MU)*gam(AL)+2*D(AL,MU)
Id,gam(MU~)*gam(MU~)=D(MU,MU)
Id,gam(P1)*gam(AL~)=-gam(AL)*gam(P1)+2*P1(AL)
Id,gam(P1)*gam(AL~)=-gam(AL)*gam(P1)+2*P1(AL)
Id,gam(P1)*gam(AL~)=-gam(AL)*gam(P1)+2*P1(AL)
Id,gam(MU~)*gam(MU~)=D(MU,MU)
Id,N^4=256+256*EP
Al,N^3=64+48*EP
Al,N^2=16+8*EP
Al,N=4+EP
Id,Commu,DF
Id,gam(MU)*gam(P2)*gam(P1)*gam6=XXX6_1
Al,gam(MU)*gam(P2)*gam6=XXX6_2
Al,gam(MU)*gam(P1)*gam6=XXX6_3
Al,gam(P1)*P1(MU)*gam6=XXX6_4
Al,gam(P1)*P2(MU)*gam6=XXX6_5
Al,gam(P2)*P1(MU)*gam6=XXX6_6
Al,gam(P2)*P2(MU)*gam6=XXX6_7
Al,gam(MU)*gam6=XXX6_8
Al,P1(MU)*gam6=XXX6_9
Al,P2(MU)*gam6=XXX6_0

Al,gam(MU)*gam(P2)*gam(P1)*gam7=XXX7_1
Al,gam(MU)*gam(P2)*gam7=XXX7_2
Al,gam(MU)*gam(P1)*gam7=XXX7_3
Al,gam(P1)*P1(MU)*gam7=XXX7_4
Al,gam(P1)*P2(MU)*gam7=XXX7_5
Al,gam(P2)*P1(MU)*gam7=XXX7_6
Al,gam(P2)*P2(MU)*gam7=XXX7_7
Al,gam(MU)*gam7=XXX7_8
Al,P1(MU)*gam7=XXX7_9
Al,P2(MU)*gam7=XXX7_0
*yep
ENDBLOCK

BLOCK color{}
Id,Adiso,T(be~,si~,a~)*T(al~,de~,a~)=
     1/2*D(be,de)*D(si,al) -1/6*D(be,si)*D(al,de)
Id,T(al~,al~,a0~)=0
Al,T(c3,c1,a0)=1 ; g=1
ENDBLOCK

C This block counts the masses and momenta in the final output;
  The result should be proportional to (mass)^2 .
BLOCK massdm{}
Id,Count,xxmm,m,1,Mb,1,Ms,1,P1,1,P2,1,[Mb^2-Ms^2],2,[Mb^2-m^2],2,[Ms^2-m^2],2
Al,Count,xxmm,PM,1
Al,Funct,gam,P1(MU~)=xxmm*P1(MU)
Al,Funct,gam,P2(MU~)=xxmm*P2(MU)
Al,Funct,Epf,P1(MU~)=xxmm*P1(MU)
Al,Funct,Epf,P2(MU~)=xxmm*P2(MU)
IF xxmm^2
Id,Addfa,0
ENDIF

ENDBLOCK
End

