C The triangle anomaly.
  Letter to Jackiw, Jan 20, 1991.

C Anomaly 1. Evaluation of the coefficients C(i,j), i=1,2, in terms
     of C0 and B0.
C Anomaly 2. The axial current triangle graphs. Vertex:  i*G5*G(al).
C Anomaly 3. The axial current triangle graphs. Vertex:  i*G5*G(al).
     An expansion in terms of the external momenta is done
     (assuming them to be small with respect to the loop mass m).
     The result shows that the axial current is at least of third
     order in the momenta.
C Anomaly 4. The pseudo scalar graphs. Vertex: 2*m*G5.

*end

C Anomaly 1. Evaluation of the coefficients C(i,j), i=1,2, in terms
     of C0 and B0.

P ninput

BLOCK BFUN{}
Id,B22(x~,M~,m~)=(-0.5*Ax(m)+M**2*B0(x,M,m)
      -0.5*(x+m^2-M**2)*B1(x,M,m))/[1-N]
Id,B21(x~,M~,m~)=-((0.5*N-1)*Ax(m)
       -0.5*N*(x+m^2-M**2)*B1(x,M,m)
       +M**2*B0(x,M,m) )/x/[1-N]
Id,B1(x~,M~,m~)= (0.5*Ax(M)-0.5*Ax(m)
              -0.5*(x+m^2-M**2)*B0(x,M,m) )/x
ENDBLOCK


BLOCK CASE6{}

C Case: all masses equal.

Id,M3=m
Al,M2=m
Al,M1=m
Al,B0(x~,M1~,M2~)=B0(x,m)
Id,Ax(M1~)=Ax(m)
Al,B0(x~,M1~,M2~)=B0(x,m)
ENDBLOCK

A Pi,N,N_,m,M,M1,M2,M3,x,y
V p,k
F Ax

D XX(I)= pDp,-pDk,-pDk,kDk

X X(I,J)= XX( 2*I-2+J )/Det

X f1=M1^2-M2^2-kDk
X f2=M2^2-M3^2-pDp-2*pDk
*fix

D R1(I)=(1/2*f1*c0+1/2*B0(qDq,M1,M3)-1/2*B0(pDp,M2,M3)),
 (1/2*f2*c0 + B0(kDk,M1,M2)/2 - B0(qDq,M1,M3)/2)

Z c11=DS(K,1,2,(X(1,K)*R1(K)))
Z c12=DS(K,1,2,(X(2,K)*R1(K)))
Id,Multi,pDk^2=kDk*pDp-Det
Keep c11,c12
B i,Pi,Det,c0
CASE6{}
*next

Z c24=i*Pi^2/4-1/2*M1^2*c0+1/4*(B0(pDp,M2,M3)-f1*c11-f2*c12)

Id,Multi,pDk^2=kDk*pDp-Det
CASE6{}
B i,Pi,Det,c0
Keep c11,c12,c24
*next

D R3(I)=(1/2*f1*c11+1/2*B1(qDq,M1,M3)+1/2*B0(pDp,M2,M3)-c24),
 (1/2*f2*c11+1/2*B1(kDk,M1,M2)-1/2*B1(qDq,M1,M3))
D R4(I)=(1/2*f1*c12+1/2*B1(qDq,M1,M3)-1/2*B1(pDp,M2,M3)),
 (1/2*f2*c12-1/2*B1(qDq,M1,M3)-c24)

Z c21=DS(K,1,2,(X(1,K)*R3(K)))
Z c23=DS(K,1,2,(X(2,K)*R3(K)))

Z C23p=DS(K,1,2,(X(1,K)*R4(K)))
Z c22=DS(K,1,2,(X(2,K)*R4(K)))

B i,Pi,Det,c0
BFUN{}
Id,Multi,pDk^2=kDk*pDp-Det
Id,N*[1-N]^-1=-1+[1-N]^-1
Id,Ax(m~)*[1-N]^-1= -1/3*Ax(m) + 2*i*Pi^2*m^2/9
Al,B0(x~,M~,m~)*[1-N]^-1= -1/3*B0(x,M,m) - 2*i*Pi^2/9
CASE6{}
Keep c11,c12,c24,c21,c23,C23p,c22
Nprint C23p
*next
P input

C Check: must be zero.

Z Diff23=c23-C23p
*end

C Anomaly 2. The axial current triangle graphs. Vertex:  i*G5*G(al).

C The triangle anomaly.
  Computing the axial current.
  The expressions for the C(i,j) have been computed separately,
  and are contained in the block CFU.

P ninput
BLOCK CFU{}
P ninput
Id,C(1,1,m) = 
 + Det^-1*C0(m)
  * ( 1/2*pDp*pDk + 1/2*pDp*kDk )
 
 - C0(m)
 
 + B0(pDp,m)*Det^-1
  * ( - 1/2*pDp )
 
 + B0(kDk,m)*Det^-1
  * ( - 1/2*pDk )
 
 + B0(qDq,m)*Det^-1
  * ( 1/2*pDp + 1/2*pDk )
 
Al,C(1,2,m) = 
 + Det^-1*C0(m)
  * ( - 1/2*pDp*kDk - 1/2*pDk*kDk )
 
 + B0(pDp,m)*Det^-1
  * ( 1/2*pDk )
 
 + B0(kDk,m)*Det^-1
  * ( 1/2*kDk )
 
 + B0(qDq,m)*Det^-1
  * ( - 1/2*pDk - 1/2*kDk ) + 0.
 
 
Al,C(2,4,m) = 
 + 1/4*i*Pi^2
 
 + Det^-1*C0(m)
  * ( - 1/4*pDp*pDk*kDk - 1/8*pDp*kDk^2 - 1/8*pDp^2*kDk )
 
 + C0(m)
  * ( - 1/2*m^2 )
 
 + B0(pDp,m)*Det^-1
  * ( 1/8*pDp*pDk + 1/8*pDp*kDk )
 
 + B0(kDk,m)*Det^-1
  * ( 1/8*pDp*kDk + 1/8*pDk*kDk )
 
 + 1/4*B0(qDq,m)
 
 + B0(qDq,m)*Det^-1
  * ( - 1/8*pDp*pDk - 1/4*pDp*kDk - 1/8*pDk*kDk ) + 0.
 
 
Al,C(2,1,m) = 
 + i*Pi^2*Det^-1
  * ( - 1/4*pDp )
 
 + Det^-2*C0(m)
  * ( 3/4*pDp^2*pDk*kDk + 3/8*pDp^2*kDk^2 + 3/8*pDp^3*kDk )
 
 + Det^-1*C0(m)
  * ( 1/2*m^2*pDp - pDp*pDk - pDp*kDk - 1/4*pDp^2 )
 
 + C0(m)
 
 + B0(pDp,m)*Det^-2
  * ( - 3/8*pDp^2*pDk - 3/8*pDp^2*kDk )
 
 + B0(pDp,m)*Det^-1
  * ( pDp )
 
 + B0(kDk,m)*Det^-2
  * ( - 3/8*pDp*pDk*kDk - 3/8*pDp^2*kDk )
 
 + B0(kDk,m)*Det^-1
  * ( 1/4*pDp + 3/4*pDk )
 
 + B0(qDq,m)*Det^-2
  * ( 3/8*pDp*pDk*kDk + 3/8*pDp^2*pDk + 3/4*pDp^2*kDk )
 
 + B0(qDq,m)*Det^-1
  * ( - 5/4*pDp - 3/4*pDk )
 
Al,C(2,3,m) = 
 + i*Pi^2*Det^-1
  * ( 1/4*pDk )
 
 + Det^-2*C0(m)
  * ( - 3/8*pDp*pDk*kDk^2 - 3/8*pDp^2*pDk*kDk - 3/4*pDp^2*kDk^2 )
 
 + Det^-1*C0(m)
  * ( - 1/2*m^2*pDk + pDp*kDk + 1/2*pDk*kDk )
 
 + B0(pDp,m)*Det^-2
  * ( 3/8*pDp*pDk*kDk + 3/8*pDp^2*kDk )
 
 + B0(pDp,m)*Det^-1
  * ( - 1/8*pDp - 1/2*pDk )
 
 + B0(kDk,m)*Det^-2
  * ( 3/8*pDp*pDk*kDk + 3/8*pDp*kDk^2 )
 
 + B0(kDk,m)*Det^-1
  * ( - 5/8*kDk )
 
 + B0(qDq,m)*Det^-2
  * ( - 3/4*pDp*pDk*kDk - 3/8*pDp*kDk^2 - 3/8*pDp^2*kDk )
 
 + B0(qDq,m)*Det^-1
  * ( 1/8*pDp + 1/2*pDk + 5/8*kDk )
 
Al,C(2,2,m) = 
 + i*Pi^2*Det^-1
  * ( - 1/4*kDk )
 
 + Det^-2*C0(m)
  * ( 3/4*pDp*pDk*kDk^2 + 3/8*pDp*kDk^3 + 3/8*pDp^2*kDk^2 )
 
 + Det^-1*C0(m)
  * ( 1/2*m^2*kDk - 1/4*kDk^2 )
 
 + B0(pDp,m)*Det^-2
  * ( - 3/8*pDp*pDk*kDk - 3/8*pDp*kDk^2 )
 
 + B0(pDp,m)*Det^-1
  * ( - 1/4*pDk + 1/4*kDk )
 
 + B0(kDk,m)*Det^-2
  * ( - 3/8*pDp*kDk^2 - 3/8*pDk*kDk^2 )
 
 + B0(qDq,m)*Det^-2
  * ( 3/8*pDp*pDk*kDk + 3/4*pDp*kDk^2 + 3/8*pDk*kDk^2 )
 
 + B0(qDq,m)*Det^-1
  * ( 1/4*pDk - 1/4*kDk ) + 0.
P input
ENDBLOCK
P input

V p,r,q,k
I al,mu,nu,L1,L2,L3
A N,N_,Pi,m,Ax,Det
F Fx,Cx,C,c,C0,Bx,B0,B1

C  Triangle graphs.
   (k,al) => (p,mu),(q,nu) with all momenta pointing inwards.
   There are two graphs, differing with respect to each other by
   reversal of the fermion direction (or by the interchange p <=> q
   and mu <=> nu).

Z A(al,mu,nu) =
 - i*Cx(m)*G5(1,2)*G(2,3,al)*
		   (i*G(3,4,k) + i*G(3,4,r) + m*Gi(3,4))
 		  *G(4,5,mu)*
		   (i*G(5,6,r) + i*G(5,6,k) + i*G(5,6,p) + m*Gi(5,6))
		  *G(6,7,nu)*
		   (i*G(7,1,r) + m*Gi(7,1))*Ax

 - i*Cx(m)*G5(1,2)*G(2,3,al)*
		   (- i*G(3,4,r) + m*Gi(3,4))
 		  *G(4,5,nu)*
		   (- i*G(5,6,r) - i*G(5,6,k) - i*G(5,6,p) + m*Gi(5,6))
		  *G(6,7,mu)*
		   (- i*G(7,1,r) - i*G(7,1,k) + m*Gi(7,1))*Ax

Id,Gammas,"C
*yep

C Try to work out terms with three r, to avoid the C(3,i).
  Such terms have more than one r inside the trace.
  Move them towards each other, to produce rDr
  Do this by moving them to the right.

Id,G(1,"t,"4,G5,al,r,L1~,L2~,L3~,L4~) =
 - G(1,"t,"4,G5,al,L1,r,L2,L3,L4)
 + 2*D(L1,r)*G(1,"t,"4,G5,al,L2,L3,L4)
Id,G(1,"t,"4,G5,al,L2~,r,L1~,L3~,L4~) =
 - G(1,"t,"4,G5,al,L2,L1,r,L3,L4)
 + 2*D(L1,r)*G(1,"t,"4,G5,al,L2,L3,L4)
Id,G(1,"t,"4,G5,al,L2~,L3~,r,L1~,L4~) =
 - G(1,"t,"4,G5,al,L2,L3,L1,r,L4)
 + 2*D(L1,r)*G(1,"t,"4,G5,al,L2,L3,L4)
Id,G(1,"t,"4,G5,al,L2~,L3~,L4~,r,L1~) =
 - G(1,"t,"4,G5,al,L2,L3,L4,L1,r)
 + 2*D(L1,r)*G(1,"t,"4,G5,al,L2,L3,L4)
Id,Gammas,"C
Id,G(1,"t,"4,G5,al,r,L1~,L2~,L3~,L4~) =
 - G(1,"t,"4,G5,al,L1,r,L2,L3,L4)
 + 2*D(L1,r)*G(1,"t,"4,G5,al,L2,L3,L4)
Id,G(1,"t,"4,G5,al,L2~,r,L1~,L3~,L4~) =
 - G(1,"t,"4,G5,al,L2,L1,r,L3,L4)
 + 2*D(L1,r)*G(1,"t,"4,G5,al,L2,L3,L4)
Id,G(1,"t,"4,G5,al,L2~,L3~,r,L1~,L4~) =
 - G(1,"t,"4,G5,al,L2,L3,L1,r,L4)
 + 2*D(L1,r)*G(1,"t,"4,G5,al,L2,L3,L4)
Id,G(1,"t,"4,G5,al,L2~,L3~,L4~,r,L1~) =
 - G(1,"t,"4,G5,al,L2,L3,L4,L1,r)
 + 2*D(L1,r)*G(1,"t,"4,G5,al,L2,L3,L4)
Id,Gammas,"C
*yep

C There may still be some traces with two r's left.

Id,G(1,"t,"4,G5,al,r,L1~,L2~) =
 - G(1,"t,"4,G5,al,L1,r,L2)
Id,Gammas,"C
*yep

C Work out the rDr terms, writing rDr = rDr+m^2 - m^2.
  In the resulting two point function one has
  1/((r+k)^2+m^2)*((r+p+k)^2+m^2). Shift r => r-k.

IF Cx(m)*rDr=Bx(m)*Shift - Cx(m)*m^2
IF Shift=1
Id,r(mu~)=r(mu)-k(mu)
Al,Func,r(mu~)=r(mu)-k(mu)
Al,Dotpr,r(mu~)=r(mu)-k(mu)
ENDIF
ENDIF
Id,Gammas,"C
*yep

C Now do the integration over the loop momentum r.

Id,All,r,N,Fx

Id,Adiso,Cx(m)*Fx(L1~,L2~)=
 + k(L1)*k(L2)*C(2,1,m) + p(L1)*p(L2)*C(2,2,m)
 + k(L1)*p(L2)*C(2,3,m) + p(L1)*k(L2)*C(2,3,m)
 + D(L1,L2)*C(2,4,m)
Id,Adiso,Cx(m)*Fx(L1~) = k(L1)*C(1,1,m) + p(L1)*C(1,2,m)
Al,Adiso,Bx(m)*Fx(L1~) = p(L1)*B1(pDp,m)
Id,Cx(m)= C0(m)
Al,Bx(m)= B0(pDp,m)

Id,Gammas
*yep

C Work out the C(i,j).

CFU{}

Id,B1(x~,m) = -0.5*B0(x,m)

Id,p(al)*Epf(mu,nu,la~,ka~)=
    p(mu)*Epf(al,nu,la,ka)
  + p(nu)*Epf(mu,al,la,ka)
  + p(la)*Epf(mu,nu,al,ka)
  + p(ka)*Epf(mu,nu,la,al)
Al,k(al)*Epf(mu,nu,la~,ka~)=
    k(mu)*Epf(al,nu,la,ka)
  + k(nu)*Epf(mu,al,la,ka)
  + k(la)*Epf(mu,nu,al,ka)
  + k(ka)*Epf(mu,nu,la,al)

Id,Multi,pDk^2=kDk*pDp-Det
Id,Det=kDk*pDp-pDk^2

*yep

C Write the result, i.e. the axial current, in the more standard form.

Id,k(mu~)=-q(mu)-p(mu)
Id,Func,k(mu~)=-q(mu)-p(mu)
Id,Dotpr,k(mu~)=-q(mu)-p(mu)
Id,Multi,pDq^2=qDq*pDp-Det
P output
*yep

C Take any one of the following three options.

Id,Ax=k(al)		! Taking the divergence of the axial current.
C Id,Ax=p(mu)		! Must be zero: gauge invariance.
C Id,Ax=q(nu)		! Must be zero: gauge invariance.
Id,k(mu~)=-q(mu)-p(mu)
Id,Func,k(mu~)=-q(mu)-p(mu)
Id,Dotpr,k(mu~)=-q(mu)-p(mu)
Id,Multi,pDq^2=qDq*pDp-Det
*end

C Anomaly 3. The axial current triangle graphs. Vertex:  i*G5*G(al).
     An expansion in terms of the external momenta is done
     (assuming them to be small with respect to the loop mass m).
     The result shows that the axial current is at least of third
     order in the momenta.

C The triangle anomaly.
  Computing the axial current to order 3 in the external momenta.

V p,r,q,k
I al,mu,nu,L1,L2,L3,L4
A N,N_,Pi,m,Ax,ax,Det,Den
F Ln,Fx,Cx,C,c,C0,Bx,B0,B1
X DY(L1,L2,L3,L4)=D(L1,L2)*D(L3,L4)+D(L1,L3)*D(L2,L4)+D(L1,L4)*D(L2,L3)
X DZ(L1,L2,L3,L4,L5,L6)=
   D(L1,L2)*DY(L3,L4,L5,L6)
 + D(L1,L3)*DY(L2,L4,L5,L6)
 + D(L1,L4)*DY(L3,L2,L5,L6)
 + D(L1,L5)*DY(L3,L4,L2,L6)
 + D(L1,L6)*DY(L3,L4,L5,L2)

C  Triangle graphs.
   (k,al) => (p,mu),(q,nu) with all momenta pointing inwards.
   There are two graphs, differing with respect to each other by
   reversal of the fermion direction (or by the interchange p <=> q
   and mu <=> nu).

Z A(al,mu,nu) =
 - i*Cx(m)*G5(1,2)*G(2,3,al)*
		   (i*G(3,4,k) + i*G(3,4,r) + m*Gi(3,4))
 		  *G(4,5,mu)*
		   (i*G(5,6,r) + i*G(5,6,k) + i*G(5,6,p) + m*Gi(5,6))
		  *G(6,7,nu)*
		   (i*G(7,1,r) + m*Gi(7,1))*Ax

 - i*Cx(m)*G5(1,2)*G(2,3,al)*
		   (- i*G(3,4,r) + m*Gi(3,4))
 		  *G(4,5,nu)*
		   (- i*G(5,6,r) - i*G(5,6,k) - i*G(5,6,p) + m*Gi(5,6))
		  *G(6,7,mu)*
		   (- i*G(7,1,r) - i*G(7,1,k) + m*Gi(7,1))*Ax

Id,Gammas,"C

C Cx(m) is the three point function:
   1 / (r^2+m^2)*((r+k)^2+m^2)*((r+k+p)^2+m^2)
  Expand the second and third denominator, use k+p = -q. Below Den stands
  for 1/(r^2+m^2).

Id,Cx(m)=Den^3*Dev2*Dev3
Id,Dev2= 1 - (2*kDr+kDk)*Den + (2*kDr+kDk)^2*Den^2 - (2*kDr+kDk)^3*Den^3
Al,Dev3= 1 - (-2*qDr+qDq)*Den + (-2*qDr+qDq)^2*Den^2 - (-2*qDr+qDq)^3*Den^3
Id,Multi,Den^7=0
*yep
Id,All,r,N,Fx

C Keep up to and including third order.

Id,Count,ax,"F,G,"F,Fx,k,1,q,1,p,1
Id,Multi,ax^4=0
Id,ax=1

C Doing the momentum integrals.

Id,Fx(L1~,L2~,L3~,L4~,L5~)=0
Al,Fx(L1~,L2~,L3~)=0
Al,Fx(L1~)=0

Id,Fx(L1~,L2~,L3~,L4~,L5~,L6~)*Den^6 =
 DZ(L1,L2,L3,L4,L5,L6)*i*Pi^2/960/m^2
Al,Fx(L1~,L2~,L3~,L4~,L5~,L6~)*Den^5 =
 DZ(L1,L2,L3,L4,L5,L6)*(i*DEL/192-i*Pi^2/192*Ln(m))
Al,Fx(L1~,L2~,L3~,L4~,L5~,L6~)*Den^4 =
 DZ(L1,L2,L3,L4,L5,L6)*m^2*(-i*DEL/48+i*Pi^2/48*(-1+Ln(m)))

Id,Fx(L1~,L2~,L3~,L4~)*Den^6 = i*Pi^2/480/m^4*DY(L1,L2,L3,L4)
Al,Fx(L1~,L2~,L3~,L4~)*Den^5 = i*Pi^2/96/m^2*DY(L1,L2,L3,L4)
Al,Fx(L1~,L2~,L3~,L4~)*Den^4 =
 DY(L1,L2,L3,L4)*(i*DEL/24 - i*Pi^2/24*Ln(m))
Al,Fx(L1~,L2~,L3~,L4~)*Den^3 =
 DY(L1,L2,L3,L4)*m^2*(-i*DEL/8 + i*Pi^2/8*(-1 + Ln(m)))

Id,Fx(L1~,L2~)*Den^5 = i*Pi^2/48/m^4*D(L1,L2)
Al,Fx(L1~,L2~)*Den^4 = i*Pi^2/12/m^2*D(L1,L2)
Al,Fx(L1~,L2~)*Den^3 = D(L1,L2)*(i*DEL/4 - i*Pi^2/4*Ln(m))

Id,Den^5=i*Pi^2/12/m^6
Al,Den^4=i*Pi^2/6/m^4
Al,Den^3=i*Pi^2/2/m^2

*yep

C Take the trace.

B DEL,i,Pi
Id,Gammas
*yep

Id,Multi,m^-4=0
Id,N=4+N_
Id,N_*DEL=-2*Pi^2
Id,N_=0
Id,k(mu~)=-q(mu)-p(mu)
Al,Func,k(mu~)=-q(mu)-p(mu)
Al,Dotpr,k(mu~)=-q(mu)-p(mu)
*yep

Id,p(al)*Epf(mu,nu,la~,ka~)=
    p(mu)*Epf(al,nu,la,ka)
  + p(nu)*Epf(mu,al,la,ka)
  + p(la)*Epf(mu,nu,al,ka)
  + p(ka)*Epf(mu,nu,la,al)
Al,q(al)*Epf(mu,nu,la~,ka~)=
    q(mu)*Epf(al,nu,la,ka)
  + q(nu)*Epf(mu,al,la,ka)
  + q(la)*Epf(mu,nu,al,ka)
  + q(ka)*Epf(mu,nu,la,al)

P output
*yep

C Take any one of the following three options.

C Id,Ax=k(al)		! Taking the divergence of the axial current.
C Id,Ax=p(mu)		! Must be zero: gauge invariance.
Id,Ax=q(nu)		! Must be zero: gauge invariance.
Id,k(mu~)=-q(mu)-p(mu)
Id,Func,k(mu~)=-q(mu)-p(mu)
Id,Dotpr,k(mu~)=-q(mu)-p(mu)
*end

C Anomaly 4. The pseudo scalar graphs. Vertex: 2*m*G5.

C The triangle anomaly.
  Computing the pseudo scalar triangle diagrams.

V p,r,q,k
I al,mu,nu,L1,L2,L3
A N,N_,Pi,m,Ax,Det
F Fx,Cx,C,c,C0,Bx,B0,B1

C  Triangle graphs.
   (k) => (p,mu),(q,nu) with all momenta pointing inwards.
   There are two graphs, differing with respect to each other by
   reversal of the fermion direction (or by the interchange p <=> q
   and mu <=> nu).

Z A(al,mu,nu) =
 -   Cx(m)*G5(1,3)*2*m*
		   (i*G(3,4,k) + i*G(3,4,r) + m*Gi(3,4))
 		  *G(4,5,mu)*
		   (i*G(5,6,r) + i*G(5,6,k) + i*G(5,6,p) + m*Gi(5,6))
		  *G(6,7,nu)*
		   (i*G(7,1,r) + m*Gi(7,1))*Ax

 -   Cx(m)*G5(1,3)*2*m*
		   (- i*G(3,4,r) + m*Gi(3,4))
 		  *G(4,5,nu)*
		   (- i*G(5,6,r) - i*G(5,6,k) - i*G(5,6,p) + m*Gi(5,6))
		  *G(6,7,mu)*
		   (- i*G(7,1,r) - i*G(7,1,k) + m*Gi(7,1))*Ax

Id,Gammas,"C
*yep

C Now do the integration over the loop momentum r.

Id,All,r,N,Fx

Id,Adiso,Cx(m)*Fx(L1~,L2~)=
 + k(L1)*k(L2)*C(2,1,m) + p(L1)*p(L2)*C(2,2,m)
 + k(L1)*p(L2)*C(2,3,m) + p(L1)*k(L2)*C(2,3,m)
 + D(L1,L2)*C(2,4,m)
Id,Adiso,Cx(m)*Fx(L1~) = k(L1)*C(1,1,m) + p(L1)*C(1,2,m)

Id,Cx(m)= C0(m)

Id,Gammas

C Write the result in the more standard form.

Id,k(mu~)=-q(mu)-p(mu)
Id,Func,k(mu~)=-q(mu)-p(mu)
Id,Dotpr,k(mu~)=-q(mu)-p(mu)
Id,Multi,pDq^2=qDq*pDp-Det
*end
