C Takes about 22 sec.

C A test of N-traces (Stephan Titard).

C Counter-terms in CDR (dim. regularization)
C~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
C Compute d3,d2,dm,dg,d2c
C Z3=1+d3*g^2 ...
C counterterms(in p-space): w/ rescaling and Zksi=Z3
C d3*g^2*(D(mu,nu)*pDp-p(mu)*p(nu)) --> from gluon self-energy
C d1F*g^2*(i*g*PSIb*gam(mu)*PSI*G(mu)) -->get d1F from quark-quark-gluon vertex
C                                        and dg using  d1F=d2+1/2*d3+dg  
C d2*g^2*(PSIb*gam(p)*PSI)  
C (d2+dm)*g^2*(PSIb*m*PSI) --> from quark self-energy
C  for Nf flavours  T(R) --> Nf*T(R)
CCCCC
P ni

BLOCK LISTS{}
C
A N,N_,A,R,flag3,flag4,g,m,M,m0,m1,m2,rep,Gr
F nom,Rf,f,A0,B0,C0
F VE4,VE4p,SVE4,VE3,PROP,FK,CAS2,Tg,KRO
C U1=K+P1,U2=K+P2,U3=K-P3=K+P1+P2
V P1,P2,P3,P,K,U,U1,U2,U3
C
C all purpose indices
I mu,nu,la
I AL,BE,GA
I a,b,c,d
C
C ~~~special indices~~~~~
C Lorentz indices dim=4
I MU4,NU4,LA4
C Lorentz indices dim=N
I L1=N,L2=N,L3=N,L4=N,L5=N,L6=N,L7=N,L8=N,L9=N,L0=N
C I L1,L2,L3,L4,L5,L6,L7,L8,L9,L0
C spinor indices
I s1,s2,s3,s4,s5,s6,s7,s8,s9,s0,sA,sB,sC,sD,sE,sF
C indices for quark-rep dim=R
C I c1=R,c2=R,c3=R,c4=R,c5=R,c6=R,c7=R,c8=R,c9=R,c0=R
I c1,c2,c3,c4,c5,c6,c7,c8,c9,c0
C indices for adjoint rep. dim=A
C I a1=A,a2=A,a3=A,a4=A,a5=A,a6=A,a7=A,a8=A,a9=A,a0=A
I a1,a2,a3,a4,a5,a6,a7,a8,a9,a0
C
ENDBLOCK
C
BLOCK QCDRUL{1,8,9,2,3}
X dede(l0,l1,l2,l3)=D(l0,l2)*D(l1,l3)-D(l0,l3)*D(l1,l2)
X q_q(l1,s1,c1,a1,l2,s2,c2,a2,k)=nom(k,m)*{-i*G(s2,s1,k)+Gi(s2,s1)*m}*D(c2,c1)
X gg(l1,s1,c1,a1,l2,s2,c2,a2,k)=nom(k,m0)*D(a1,a2)*D(l1,l2)
'1'X c_c(l1,s1,c1,a1,l2,s2,c2,a2,k)=nom(k,m0)*D(a2,a1)
X gq_q(l0,s0,c0,a0,k0,l1,s1,c1,a1,k1,l2,s2,c2,a2,k2)=
       i*g*G(s1,s2,l0)*Rf(a0,c1,c2)
X gq_r(l0,s0,c0,a0,k0,l1,s1,c1,a1,k1,l2,s2,c2,a2,k2)=
       i*g*G(s1,s2,G5,l0)*Rf(a0,c1,c2)
X gqr_(l0,s0,c0,a0,k0,l1,s1,c1,a1,k1,l2,s2,c2,a2,k2)=
       i*g*G(s2,s1,l0,G5)*Rf(a0,c2,c1)
'1'X c_cg(l0,s0,c0,a0,k0,l1,s1,c1,a1,k1,l2,s2,c2,a2,k2)=
'1'          i*g*f(a2,a0,a1)*k0(l2) !*flag5
C  fermions in representation Rf :mat.elts Rf"a0/c1c2"
X ggg(l0,s0,c0,a0,k0,l1,s1,c1,a1,k1,l2,s2,c2,a2,k2)=
          flag3*i*g*f(a0,a1,a2)*{(k0(l2)-k1(l2))*D(l0,l1)
                          +(k1(l0)-k2(l0))*D(l1,l2)
                          +(k2(l1)-k0(l1))*D(l2,l0)}
C  stucture constants f(a,b,c) taken fully 
C     antisymmetric
'8'X gggg(l0,a0,l1,a1,l2,a2,l3,a3)=
'8'   -flag4*g^2*{f(a0,a1,a2,a3)*dede(l0,l1,l2,l3)
'8'              +f(a0,a2,a3,a1)*dede(l0,l2,l3,l1)
'8'              +f(a0,a3,a1,a2)*dede(l0,l3,l1,l2)}
'9'X gggg(l0,a0,K,l1,a1,P1,l2,a2,P2,l3,a3,P3)=
'9'   -flag4*g^2*{f(a0,a1,a2,a3)*dede(l0,l1,l2,l3)
'9'              +f(a0,a2,a3,a1)*dede(l0,l2,l3,l1)
'9'              +f(a0,a3,a1,a2)*dede(l0,l3,l1,l2)}
X q_qx(l1,s1,c1,a1,k1,l2,s2,c2,a2,k2,l0,s0,c0,a0,k0)=
       G(s1,s2,G5,l0)*D(c1,c2)
X q_qy(l1,s1,c1,a1,k1,l2,s2,c2,a2,k2,l0,s0,c0,a0,k0)=
       G(s1,s2,G5)*D(c1,c2)*m
C x is fictitious particle associated w/ current g5gl
C (d_la j_5la) --> factor i(-P1-P2) --> -i after ddP1_la
C y the same for mg5
C we will need to multiply the matrix elements of j5 by 2
C cf  divj= 2m j5+...
C
C FFtilde
'9'X fgg(L0,s0,c0,a0,K,L1,s1,c1,a1,P1,L2,s2,c2,a2,P2)=
'9'      -8*g^2*i*D(a1,a2)*Epf(L1,L2,P1,P2)*flaFF1
'9'X fggg(L0,a0,K,L1,a1,P1,L2,a2,P2,L3,a3,P3)=
'9'      -8*g^3*f(a1,a2,a3)*Epf(L1,L2,L3,P1)*flaFF2
'9'      -8*g^3*f(a1,a2,a3)*Epf(L1,L2,L3,P2)*flaFF2
'9'      -8*g^3*f(a1,a2,a3)*Epf(L1,L2,L3,P3)*flaFF2
C counter-terms
C convention: diag + counterdiag= finite
C                 ****
C in DR:
'2'X q_q5(l1,s1,c1,a1,k1,l2,s2,c2,a2,k2,l0,s0,c0,a0,k0)=
'2'       -2*N_^-1*g^2*CAS2(Rep)*D(c1,c2)*(i*G(s1,s2,k2)+4*m*Gi(s1,s2))
C in PV:
'3'X q_q5(L3,s3,c3,a3,P,L4,s4,c4,a4,K,L5,s5,c5,a5,Z0)=
'3'       -CAS2(Rep)*D(c3,c4)*g^2*ln_M2*( i*G(s3,s4,K)+4*m*Gi(s3,s4) )
'3'X q_qx1(L3,s3,c3,a3,P,L4,s4,c4,a4,K,L5,s5,c5,a5,Z0)=
'3'        CAS2(Rep)*D(c3,c4)*g^2*ln_M2*G(s3,s4,G5,L5)
'3'X q_qy1(L3,s3,c3,a3,P,L4,s4,c4,a4,K,L5,s5,c5,a5,Z0)=
'3'        CAS2(Rep)*D(c3,c4)*g^2*ln_M2*G(s3,s4,G5)*4*i*m
'3'C CAS2(Rep,Gr)=CAS2(Rep)-1/2CAS2(Gr)
'3'X gq_q1(L3,s3,c3,a3,P,L4,s4,c4,a4,K,L5,s5,c5,a5,Z0)=
'3'        Rf(a3,c4,c5)*CAS2(Rep,Gr)*g^3*ln_M2*G(s4,s5,L3)
'3'X gq_q3(L3,s3,c3,a3,P,L4,s4,c4,a4,K,L5,s5,c5,a5,Z0)=
'3'        Rf(a3,c4,c5)*CAS2(Gr)*g^3*ln_M2*G(s4,s5,L3)
C
T TAP: g,x,y,1,3,5,f
T TFE: q
'1'T TGH: c
T TC: q=1,g=0,c=0,x=0,y=0,1=0,3=0,5=0,r=1,f=0
'1'T TCG: q=0,g=0,x=0,c=1,1=0,3=0,5=0,r=0,f=0
Anti,TAP
ENDBLOCK
C
BLOCK COMPO{2}
*yep
Id,Compo,<X>,VE4,VE4p,SVE4,VE3,PROP
'2'Id,VE4(gg~,L4~,a4~,L5~,a5~,L6~,a6~,L7~,a7~)=gg(L4,a4,L5,a5,L6,a6,L7,a7)
'2'Al,VE4p(gg~,L4~,a4~,K~,L5~,a5~,P1~,L6~,a6~,P2~,L7~,a7~,P3~)=
'2'      gg(L4,a4,K,L5,a5,P1,L6,a6,P2,L7,a7,P3)
'2'Al,SVE4(gq_q1~,MU4~,s1~,c1~,a1~,P~,L4~,s4~,c4~,a4~,K~,L5~,s5~,c5~,a5~,Q~)=
'2'        gq_q1(MU4,s1,c1,a1,P,L4,s4,c4,a4,K,L5,s5,c5,a5,Q)
'2'Al,VE3(gg~,MU4~,s1~,c1~,a1~,K~,L4~,s4~,c4~,a4~,Q~,L5~,s5~,c5~,a5~,P~)=
'2'       gg(MU4,s1,c1,a1,K,L4,s4,c4,a4,Q,L5,s5,c5,a5,P)
'2'Al,PROP(gg~,L4~,s4~,c4~,a4~,K~,L5~,s5~,c5~,a5~,P~)=
'2'        gg(L4,s4,c4,a4,L5,s5,c5,a5,P)
'2'Id,flagA=1
'2'I Na1=A,Na2=A
'2'I Na1,Na2
'2'DO ii=1,2
'2'Id,f(a0~,a1~,a2~,a3~)=flagA*f(a0,a1,a2,a3)
'2'Id,flagA^n~*f(a0~,a1~,a2~,a3~)=f(a0,a1,Na'ii')*f(a2,a3,Na'ii')
'2'ENDDO
'2'Sum,Na1,Na2
'2'*yep
'2'Id,Even,nom,1
'2'Id,Commu,nom,Rf,f
*yep
ENDBLOCK
C
BLOCK PFF{3,4,5}
C
Id,Commu,nom
Id,nom(K,m~)*nom(U1,m1~)*nom(U3,m2~)=C0(m,m1,m2,P1,P2)
Al,nom(K,m~)*nom(U1,m1~)=B0(m,m1,P1)
Al,nom(K,m~)*nom(U2,m1~)=B0(m,m1,P2)
Al,nom(K,m~)*nom(U3,m1~)=B0(m,m1,-P3)
Al,nom(K,m~)=A0(m)
Id,Gammas,"C

C remains U1=K+P1,U2=K+P2,U3=K+P1+P2,P3=-P1-P2
C order of vectors:P1,P2,P3,K,U1,U2,U3
'3'Id,U1(mu~)=K(mu)+P1(mu)
'3'Al,Dotpr,U1(mu~)=K(mu)+P1(mu)
'3'Al,Funct,G,Epf,U1(mu~)=K(mu)+P1(mu)
'3'Id,U2(mu~)=K(mu)+P2(mu)
'3'Al,Dotpr,U2(mu~)=K(mu)+P2(mu)
'3'Al,Funct,G,Epf,U2(mu~)=K(mu)+P2(mu)
'3'Id,U3(mu~)=K(mu)+P1(mu)+P2(mu)
'3'Al,Dotpr,U3(mu~)=K(mu)+P1(mu)+P2(mu)
'3'Al,Funct,G,Epf,U3(mu~)=K(mu)+P1(mu)+P2(mu)
'3'Id,P3(mu~)=-P1(mu)-P2(mu)
'3'Al,Dotpr,P3(mu~)=-P1(mu)-P2(mu)
'3'Al,Funct,G,Epf,P3(mu~)=-P1(mu)-P2(mu)
'3'Id,flagA=1
'3'Id,Adiso,nom(U1,m~)*nom(U3,m1~)=B0(m,m1,P2)*flagA
'3'IF flagA=1
'3'Al,K(mu~)=K(mu)-P1(mu)
'3'Al,Dotpr,K(mu~)=K(mu)-P1(mu)
'3'Al,Funct,G,Epf,K(mu~)=K(mu)-P1(mu)
'3'ENDIF
'4'INTEG{}
'4'Id,P3(mu~)=-P1(mu)-P2(mu)
'4'Al,Dotpr,P3(mu~)=-P1(mu)-P2(mu)
'5'Id,Gammas
'5'Id,N=N_+4
*yep
ENDBLOCK
C
BLOCK GROUPF{}
*yep
C exterior colour indices: a_0-3,c_0-3
Id,flagA=1
C group factor
Id,Asymm,f,1,2,3
C first products of 3 fs
Id,Adiso,f(a1~,a4~,a5~)*f(a2~,a5~,a6~)*f(a3~,a6~,a4~)=Nc/2*f(a1,a2,a3)
Al,Adiso,f(a1~,a5~,a4~)*f(a2~,a5~,a6~)*f(a3~,a6~,a4~)=-Nc/2*f(a1,a2,a3)
Al,Adiso,f(a1~,a4~,a5~)*f(a2~,a6~,a5~)*f(a3~,a6~,a4~)=-Nc/2*f(a1,a2,a3)
Al,Adiso,f(a1~,a4~,a5~)*f(a2~,a5~,a6~)*f(a3~,a4~,a6~)=-Nc/2*f(a1,a2,a3)
Al,Adiso,f(a1~,a5~,a4~)*f(a2~,a6~,a5~)*f(a3~,a6~,a4~)=Nc/2*f(a1,a2,a3)
Al,Adiso,f(a1~,a5~,a4~)*f(a2~,a5~,a6~)*f(a3~,a4~,a6~)=Nc/2*f(a1,a2,a3)
Al,Adiso,f(a1~,a4~,a5~)*f(a2~,a6~,a5~)*f(a3~,a4~,a6~)=Nc/2*f(a1,a2,a3)
Id,Nc=CAS2(Gr)
Id,Asymm,f,1,2,3
C
DO ii=1,3
Id,Adiso,Rf(a4~,c4~,c5~)*Rf(a5~,c5~,c4~)=Tg(Rep)*D(a4,a5)
Al,Adiso,Rf(a4~,c4~,c5~)*Rf(a4~,c5~,c6~)=CAS2(Rep)*D(c4,c6)
Al,Rf(a4~,c4~,c4~)=0
ENDDO
C
IF Adiso,Rf(a4~,c4~,c5~)*Rf(a5~,c5~,c6~)*Rf(a4~,c6~,c7~)*Rf(a6~,c7~,c4~)
OR Adiso,Rf(a5~,c4~,c5~)*Rf(a4~,c5~,c6~)*Rf(a6~,c6~,c7~)*Rf(a4~,c7~,c4~)
Al,Addfa,flagA
ENDIF
C 
DO ii=1,3
Id,Adiso,Rf(a4~,c4~,c5~)*Rf(a5~,c5~,c6~)*Rf(a4~,c6~,c7~)=
         Rf(a4,c4,c5)*Rf(a4,c5,c6)*Rf(a5,c6,c7)+
         i*f(a5,a4,c6)*Rf(a4,c4,c5)*Rf(c6,c5,c7)
Id,Adiso,Rf(a4~,c4~,c5~)*Rf(a4~,c5~,c6~)=CAS2(Rep)*D(c4,c6)
ENDDO
C here write RR=1/2{R,R}+1/2[R,R] anticommut.piece --> 0
DO ii=1,3
Id,Asymm,f,1,2,3
Id,Adiso,f(a4~,a5~,a6~)*Rf(a5~,c4~,c5~)*Rf(a6~,c5~,c6~)=
         f(a4,a5,a6)*i*f(a5,a6,c5)*Rf(c5,c4,c6)*1/2
Al,Adiso,f(a4~,a6~,a5~)*Rf(a5~,c4~,c5~)*Rf(a6~,c5~,c6~)=
         - f(a4,a5,a6)*i*f(a5,a6,c5)*Rf(c5,c4,c6)*1/2
Al,Adiso,f(a5~,a6~,a4~)*Rf(a5~,c4~,c5~)*Rf(a6~,c5~,c6~)=
         f(a4,a5,a6)*i*f(a5,a6,c5)*Rf(c5,c4,c6)*1/2
Al,Adiso,f(a6~,a5~,a4~)*Rf(a5~,c4~,c5~)*Rf(a6~,c5~,c6~)=
         - f(a4,a5,a6)*i*f(a5,a6,c5)*Rf(c5,c4,c6)*1/2
Al,Adiso,f(a5~,a4~,a6~)*Rf(a5~,c4~,c5~)*Rf(a6~,c5~,c6~)=
         - f(a4,a5,a6)*i*f(a5,a6,c5)*Rf(c5,c4,c6)*1/2
Al,Adiso,f(a6~,a4~,a5~)*Rf(a5~,c4~,c5~)*Rf(a6~,c5~,c6~)=
         f(a4,a5,a6)*i*f(a5,a6,c5)*Rf(c5,c4,c6)*1/2
Id,Adiso,Rf(a4~,c4~,c5~)*Rf(a4~,c5~,c6~)=CAS2(Rep)*D(c4,c6)
ENDDO
Id,Asymm,f,1,2,3
C
DO ii=1,3
Id,Adiso,Rf(a4~,c4~,c5~)*Rf(a5~,c5~,c4~)=Tg(Rep)*D(a4,a5)
Al,Adiso,Rf(a4~,c4~,c5~)*Rf(a4~,c5~,c6~)=CAS2(Rep)*D(c4,c6)
Id,Adiso,f(a4~,a6~,a7~)*f(a5~,a6~,a7~)=CAS2(Gr)*D(a4,a5)
Al,Adiso,f(a6~,a4~,a7~)*f(a5~,a6~,a7~)= - CAS2(Gr)*D(a4,a5)
Al,Adiso,f(a6~,a7~,a4~)*f(a5~,a6~,a7~)=CAS2(Gr)*D(a4,a5)
Al,Adiso,f(a4~,a6~,a7~)*f(a6~,a5~,a7~)= - CAS2(Gr)*D(a4,a5)
Al,Adiso,f(a6~,a4~,a7~)*f(a6~,a5~,a7~)=CAS2(Gr)*D(a4,a5)
Al,Adiso,f(a6~,a7~,a4~)*f(a6~,a5~,a7~)= - CAS2(Gr)*D(a4,a5)
Al,Adiso,f(a4~,a6~,a7~)*f(a6~,a7~,a5~)=CAS2(Gr)*D(a4,a5)
Al,Adiso,f(a6~,a4~,a7~)*f(a6~,a7~,a5~)= - CAS2(Gr)*D(a4,a5)
Al,Adiso,f(a6~,a7~,a4~)*f(a6~,a7~,a5~)=CAS2(Gr)*D(a4,a5)
ENDDO
C
C trace of 3 diff. Rs ( for fund. repr. of SU(N) put Tg(Rep)=1/2)
Id,Adiso,Rf(a1~,a4~,a5~)*Rf(a2~,a5~,a6~)*Rf(a3~,a6~,a4~)=
         1/2*Tg(Rep)*i*f(a1,a2,a3)
        +1/2*Tg(Rep)*dsym(a1,a2,a3)
Id,Symme,dsym,1,2,3
C
Id,Asymm,f,1,2,3
Id,Rf(a4~,c4~,c4~)=0
Id,Commu,CAS2,Tg
Id,D(a1,a2)=KRO(a1,a2)
*yep
C
Id,Adiso,CAS2(Rep)*Tg(Rep)*KRO(a1,a2)=GRF#1
Al,Adiso,CAS2(Gr)*Tg(Rep)*KRO(a1,a2)=GRF#2
Al,Adiso,CAS2(Rep,Gr)*Tg(Rep)*KRO(a1,a2)=GRF#3
IF NOT flag3
Al,flagA*GRF#2=-2*GRF#3+2*GRF#1
Al,CAS2(Rep)*g^3=(CAS2(Rep,Gr)+1/2*CAS2(Gr))*g^3
ENDIF
Id,flagA=1
C GRF#3 involves C2(R)-C2(G).1/2 >CAS2(Rep,Gr)
Id,g^4*GRF#1=GRF1
Al,g^4*GRF#2=GRF2
Al,g^4*GRF#3=GRF3
*yep
C
ENDBLOCK
C
BLOCK INTEG{}
Id,Count,1,G,1,dsym,-1
Id,Count,3,"F,G,K,1

IF NOT G(s4,"t,"4,MU4,K,NU4,K,LA4,K)
Id,Addfa,0
ENDIF

P output
*yep
Id,All,K,N,FK
P output

Id,C0(m~,m1~,m2~,P1~,P2~)*FK(AL~,BE~,GA~)=
      P1(AL)*P1(BE)*P1(GA)*C31(m,m1,m2,P1,P2)
     +P2(AL)*P2(BE)*P2(GA)*C32(m,m1,m2,P1,P2)     
     +P1(AL)*P1(BE)*P2(GA)*C33(m,m1,m2,P1,P2)
     +P1(AL)*P2(BE)*P1(GA)*C33(m,m1,m2,P1,P2)
     +P2(AL)*P1(BE)*P1(GA)*C33(m,m1,m2,P1,P2)
     +P1(AL)*P2(BE)*P2(GA)*C34(m,m1,m2,P1,P2)
     +P2(AL)*P1(BE)*P2(GA)*C34(m,m1,m2,P1,P2)
     +P2(AL)*P2(BE)*P1(GA)*C34(m,m1,m2,P1,P2)
     +P1(AL)*D(BE,GA)*C35(m,m1,m2,P1,P2)
     +P1(BE)*D(AL,GA)*C35(m,m1,m2,P1,P2)
     +P1(GA)*D(AL,BE)*C35(m,m1,m2,P1,P2)
     +P2(AL)*D(BE,GA)*C36(m,m1,m2,P1,P2)
     +P2(BE)*D(AL,GA)*C36(m,m1,m2,P1,P2)
     +P2(GA)*D(AL,BE)*C36(m,m1,m2,P1,P2)
Al,C0(m~,m1~,m2~,P1~,P2~)*FK(AL~,BE~)=
      P1(AL)*P1(BE)*C21(m,m1,m2,P1,P2)
     +P2(AL)*P2(BE)*C22(m,m1,m2,P1,P2)
     +P1(AL)*P2(BE)*C23(m,m1,m2,P1,P2)
     +P2(AL)*P1(BE)*C23(m,m1,m2,P1,P2)
     +D(AL,BE)*C24(m,m1,m2,P1,P2)
Al,C0(m~,m1~,m2~,P1~,P2~)*FK(AL~)=
      P1(AL)*C11(m,m1,m2,P1,P2)
     +P2(AL)*C12(m,m1,m2,P1,P2)
Id,B0(m~,m1~,P1~)*FK(AL~,BE~)=
      P1(AL)*P1(BE)*B21(m,m1,P1)
     +D(AL,BE)*B22(m,m1,P1)
Al,B0(m~,m1~,P1~)*FK(AL~)=P1(AL)*B1(m,m1,P1)
Id,A0(m~)*FK(AL~)=0
Id,Even,B0,3,B1,3,B21,3,B22,3
C

IF NOT C35(m,m,m,P1,P2)
Id,Addfa,0
ENDIF

IF G(s4,"t,"4,MU4,Naa~,NU4,Naa~,LA4,P1)
Id,Addfa,Xx1
ENDIF

IF G(s4,"t,"4,MU4,Naa~,NU4,P1,LA4,Naa~)
Id,Addfa,Xx2
ENDIF
IF G(s4,"t,"4,MU4,P1,NU4,Nac~,LA4,Nac~)
Id,Addfa,Xx3
ENDIF
Id,Numer,Xx3,0
P output
*yep
P output
C *end
C Id,Xx2=0
Id,G(s4,"t,"4,MU4,Naa~,NU4,Naa~,LA4,P1)=D(Naa,Naa)
Al,G(s4,"t,"4,MU4,Naa~,NU4,P1,LA4,Naa~)=D(Naa,Naa)
*end

ENDBLOCK
C
BLOCK DELS{1,2,3,4}
*yep
Id,N = N_ + 4.
Id,N_*A0(m~)= 2*m^2*ipi2  
Al,N_*B0(m~,m1~,K~)= - 2*ipi2
Al,N_*B1(m~,m1~,K~)= + ipi2
Al,N_*B21(m~,m1~,K~)= -2/3*ipi2
Al,N_*B22(m~,m1~,K~)= +1/2*ipi2*(m^2+m1^2+KDK/3)
Al,N_*C24(m~,m1~,m2~,P1~,P2~)= -1/2*ipi2
Al,N_*C35(m~,m1~,m2~,P1~,P2~)= + ipi2/3
Al,N_*C36(m~,m1~,m2~,P1~,P2~)= + ipi2/6
Al,N_*D422(m~,m1~,m2~,m0~)= - ipi2/12
*yep
C
'1'Id,A0(m~)= -DEL*m^2
'2'Id,B0(m~,m1~,K~)= DEL 
'2'Al,B1(m~,m1~,K~)= - 1/2*DEL
'2'Al,B21(m~,m1~,K~)= DEL/3
'2'Al,B22(m~,m1~,K~)= -1/4*DEL*(m^2+m1^2+KDK/3)
'2'*yep
'3'Id,C0(m~,m1~,m2~,P1~,P2~)=0
'3'Al,C11(m~,m1~,m2~,P1~,P2~)=0
'3'Al,C12(m~,m1~,m2~,P1~,P2~)=0
'3'Al,C21(m~,m1~,m2~,P1~,P2~)=0
'3'Al,C22(m~,m1~,m2~,P1~,P2~)=0
'3'Al,C23(m~,m1~,m2~,P1~,P2~)=0
'3'Al,C24(m~,m1~,m2~,P1~,P2~)= DEL/4
'3'Al,C31(m~,m1~,m2~,P1~,P2~)=0
'3'Al,C32(m~,m1~,m2~,P1~,P2~)=0
'3'Al,C33(m~,m1~,m2~,P1~,P2~)=0
'3'Al,C34(m~,m1~,m2~,P1~,P2~)=0
'3'Al,C35(m~,m1~,m2~,P1~,P2~)=-DEL/6
'3'Al,C36(m~,m1~,m2~,P1~,P2~)=-DEL/12
'3'*yep
'4'Id,D0(m~,m1~,m2~,m0~)=0
'4'DO J=1,3
'4'Al,D1'J'(m~,m1~,m2~,m0~)=0
'4'ENDDO
'4'DO J=1,7
'4'Al,D2'J'(m~,m1~,m2~,m0~)=0
'4'ENDDO
'4'DO J=1,13
'4'Al,D3'J'(m~,m1~,m2~,m0~)=0
'4'ENDDO
'4'*yep
'4'DO J=1,21
'4'Al,D4'J'(m~,m1~,m2~,m0~)=0
'4'ENDDO
'4'Al,D422(m~,m1~,m2~,m0~)= DEL/24
*yep
Id,N_=0.
Id,DEL= - 2*ipi2*N_^-1
*yep
ENDBLOCK
C
BLOCK DOTP1L{1}
C
*yep
C reduction dot-products
'1'C powercounting
'1'Id,Count,flagD,K,-1,nom,2
'1'Al,Addfa,flagD^-4
'1'Id,flagD=0
'1'Al,Multi,flagD^-1=1
C step1
Id,P2DK=-P1DP2+1/2*(U3DU3-U1DU1-P2DP2) ! U3=P2+U1
Al,P1DK=1/2*(U1DU1-KDK-P1DP1)
DO ii=1,3
Id,U3DU3^n~*nom(U3,m~)=U3DU3^n/U3DU3-U3DU3^n/U3DU3*m^2*nom(U3,m)
Al,U1DU1^n~*nom(U1,m~)=U1DU1^n/U1DU1-U1DU1^n/U1DU1*m^2*nom(U1,m)
ENDDO
Id,6,KDK^n~*nom(K,m~)=KDK^n/KDK-KDK^n/KDK*m^2*nom(K,m)
C
Id,U3DU3=KDK+2*P2DK+2*P1DK+2*P1DP2+P2DP2+P1DP1
Al,U1DU1=KDK+2*P1DK+P1DP1
'1'C powercounting
'1'Id,Count,flagD,K,-1,nom,2
'1'Al,Addfa,flagD^-4
'1'Id,flagD=0
'1'Al,Multi,flagD^-1=1
Id,6,KDK^n~*nom(K,m~)=KDK^n/KDK-KDK^n/KDK*m^2*nom(K,m)
C
Id,Count,flagA,nom,1
IF flagA^2*nom(U1,m1~)*nom(U3,m2~)=nom(K,m1)*nom(U2,m2)
Al,Dotpr,K(AL~)=K(AL)-P1(AL)
ENDIF
Id,flagA=1
Id,6,KDK^n~*nom(K,m~)=KDK^n/KDK-KDK^n/KDK*m^2*nom(K,m)
IF NOT nom(K~,m~)
Al,Addfa,0
ENDIF
C
*yep
C step2
C shift the A0s eliminate odd powers of K
Id,Count,flagA,nom,1
IF flagA*nom(U1,m~)=nom(K,m)*flagA
Al,Dotpr,K(AL~)=K(AL)-P1(AL)
ENDIF
IF flagA*nom(U2,m~)=nom(K,m)*flagA
Al,Dotpr,K(AL~)=K(AL)-P2(AL)
ENDIF
IF flagA*nom(U3,m~)=nom(K,m)*flagA
Al,Dotpr,K(AL~)=K(AL)-P1(AL)-P2(AL)
ENDIF
Id,Multi,flagA^2=flagB
Id,flagA*flagB^n~=1
Al,flagB=1
IF flagA=1
Al,Count,flagC,K,1
ENDIF
Id,Multi,flagC^2=1
Id,flagC=0
Id,6,KDK^n~*nom(K,m~)=KDK^n/KDK-KDK^n/KDK*m^2*nom(K,m)
IF NOT nom(K~,m~)
Al,Addfa,0
ENDIF
C end shift A0s
C
C step3
Id,Count,flagA,nom,1
Id,All,K,N,FK,"F_
IF flagA^2=1
Al,Adiso,FK(AL~)*nom(K,m~)*nom(U1,m1~)=
   P1(AL)*P1DK*P1DP1^-1*nom(K,m)*nom(U1,m1)
Al,Adiso,FK(AL~)*nom(K,m~)*nom(U2,m1~)=
   P2(AL)*P2DK*P2DP2^-1*nom(K,m)*nom(U2,m1)
Al,Adiso,FK(AL~)*nom(K,m~)*nom(U3,m1~)=
   P3(AL)*P3DK*P3DP3^-1*nom(K,m)*nom(U3,m1)
C
Al,Adiso,FK(AL~,BE~)*nom(K,m~)*nom(U1,m1~)=
 + P1(AL)*P1(BE)*nom(K,m)*nom(U1,m1)
  * ( - 1/9*N_*P1DP1^-2*P1DK^2 + 1/9*N_*P1DP1^-1*KDK + 1/27*N_^2*P1DP1^-2
  *P1DK^2 - 1/27*N_^2*P1DP1^-1*KDK + 4/3*P1DP1^-2*P1DK^2 - 1/3*P1DP1^-1*KDK )
 + D(AL,BE)*nom(K,m)*nom(U1,m1)
  * ( 1/9*N_*P1DP1^-1*P1DK^2 - 1/9*N_*KDK - 1/27*N_^2*P1DP1^-1*P1DK^2
  + 1/27*N_^2*KDK - 1/3*P1DP1^-1*P1DK^2 + 1/3*KDK )
Al,Adiso,FK(AL~,BE~)*nom(K,m~)*nom(U2,m1~)=
 + P2(AL)*P2(BE)*nom(K,m)*nom(U2,m1)
  * ( - 1/9*N_*P2DP2^-2*P2DK^2 + 1/9*N_*P2DP2^-1*KDK + 1/27*N_^2*P2DP2^-2
  *P2DK^2 - 1/27*N_^2*P2DP2^-1*KDK + 4/3*P2DP2^-2*P2DK^2 - 1/3*P2DP2^-1*KDK )
 + D(AL,BE)*nom(K,m)*nom(U2,m1)
  * ( 1/9*N_*P2DP2^-1*P2DK^2 - 1/9*N_*KDK - 1/27*N_^2*P2DP2^-1*P2DK^2
  + 1/27*N_^2*KDK - 1/3*P2DP2^-1*P2DK^2 + 1/3*KDK )
Al,Adiso,FK(AL~,BE~)*nom(K,m~)*nom(U3,m1~)=
 + P3(AL)*P3(BE)*nom(K,m)*nom(U3,m1)
  * ( - 1/9*N_*P3DP3^-2*P3DK^2 + 1/9*N_*P3DP3^-1*KDK + 1/27*N_^2*P3DP3^-2
  *P3DK^2 - 1/27*N_^2*P3DP3^-1*KDK + 4/3*P3DP3^-2*P3DK^2 - 1/3*P3DP3^-1*KDK )
 + D(AL,BE)*nom(K,m)*nom(U3,m1)
  * ( 1/9*N_*P3DP3^-1*P3DK^2 - 1/9*N_*KDK - 1/27*N_^2*P3DP3^-1*P3DK^2
  + 1/27*N_^2*KDK - 1/3*P3DP3^-1*P3DK^2 + 1/3*KDK )
Id,Once,N_^2=0
ENDIF
Id,flagA=1
C step4: start at step1 again
Id,P3DK=-1/2*(U3DU3-KDK-P3DP3)
Al,P2DK=1/2*(U2DU2-KDK-P2DP2)
Al,P1DK=1/2*(U1DU1-KDK-P1DP1)
DO ii=1,2
Id,U3DU3^n~*nom(U3,m~)=U3DU3^n/U3DU3-U3DU3^n/U3DU3*m^2*nom(U3,m)
Al,U2DU2^n~*nom(U2,m~)=U2DU2^n/U2DU2-U2DU2^n/U2DU2*m^2*nom(U2,m)
Al,U1DU1^n~*nom(U1,m~)=U1DU1^n/U1DU1-U1DU1^n/U1DU1*m^2*nom(U1,m)
ENDDO
Id,4,KDK^n~*nom(K,m~)=KDK^n/KDK-KDK^n/KDK*m^2*nom(K,m)
C
Id,U3DU3=KDK-2*P3DK+P3DP3
Al,U2DU2=KDK+2*P2DK+P2DP2
Al,U1DU1=KDK+2*P1DK+P1DP1
Id,4,KDK^n~*nom(K,m~)=KDK^n/KDK-KDK^n/KDK*m^2*nom(K,m)
C
*yep
C step5: step2 again
C shift the A0s eliminate odd powers of K
Id,Count,flagA,nom,1
IF flagA*nom(U1,m~)=nom(K,m)*flagA
Al,Dotpr,K(AL~)=K(AL)-P1(AL)
ENDIF
IF flagA*nom(U2,m~)=nom(K,m)*flagA
Al,Dotpr,K(AL~)=K(AL)-P2(AL)
ENDIF
IF flagA*nom(U3,m~)=nom(K,m)*flagA
Al,Dotpr,K(AL~)=K(AL)+P3(AL)
ENDIF
Id,Multi,flagA^2=flagB
Id,flagA*flagB^n~=1
Al,flagB=1
IF flagA=1
Al,Count,flagC,K,1
ENDIF
Id,Multi,flagC^2=1
Id,flagC=0
Id,6,KDK^n~*nom(K,m~)=KDK^n/KDK-KDK^n/KDK*m^2*nom(K,m)
IF NOT nom(K~,m~)
Al,Addfa,0
ENDIF
C end shift A0s
C
C step6: last
Id,Dotpr,P3(AL~)=-P1(AL)-P2(AL)
Id,Count,flagC,K,1
Id,Commu,nom
IF NOT flagC
Al,Adiso,nom(K,m~)*nom(U1,m1~)*nom(U3,m2~)=C0(m,m1,m2,P1,P2)
Al,Adiso,nom(K,m~)*nom(U1,m1~)=B0(m,m1,P1)
Al,Adiso,nom(K,m~)*nom(U2,m1~)=B0(m,m1,P2)
Al,Adiso,nom(K,m~)*nom(U3,m1~)=B0(m,m1,P3) ! B0 even in arg #3
Al,nom(K~,m~)=A0(m)
Id,N_*A0(m~)=2*m^2*ipi2
Al,N_*B0(m~,m1~,P1)=-2*ipi2
Al,N_*C0(m~,m1~,m2~,P1,P2)=0
Id,Symme,B0,1,2
ENDIF
*yep
C
ENDBLOCK

C Read qcdblocks1l


BLOCK TOPO1L{1,2}
C
V P1,P2,P3,K,U1,U2,U3
'1'Id,SELF(I1~,I2~)=
'1'    DS(I1;-J1;J2;Sym;-J1;J2;(
'1'    DC("C,TC,I2,-J2,J1)*DC("F,TFE,-1,J1,J2)*DC("F,TGH,-1,J1,J2)*
'1'    DIA(I1,I2,-J1,J1,-J2,J2) ))
'1'   +DS(I1;-J3;J3;I2;Sym;-J3;J3;(
'1'    DIB(I1;I2;-J3,J3) ))
'1'Id,Anti,TAP
'1'C             
'1'Id,DIA(I1~,I2~,K4~,K5~,K6~,K7~)=
'1'   VE3(I1,K4,K7,*,MU4,s1,c1,a1,P1,*,L4,s4,c4,a4,-U1,*,L7,s7,c7,a7,K)*
'1'   VE3(I2,K6,K5,*,NU4,s2,c2,a2,-P1,*,L6,s6,c6,a6,-K,*,L5,s5,c5,a5,U1)*
'1'   PROP(K5,K4,*,L5,s5,c5,a5,U1,*,L4,s4,c4,a4,-U1)*
'1'   PROP(K7,K6,*,L7,s7,c7,a7,K,*,L6,s6,c6,a6,-K)
'1'Al,DIB(I1~,I2~,K4~,K5~)=
'1'   VE4(I1,K4,K5,I2,*,MU4,a1,*,L4,a4,*,L5,a5,*,NU4,a2)*
'1'   PROP(K5,K4,*,L5,s5,c5,a5,K,*,L4,s4,c4,a4,-K)
'1'C
'1'Id,PTF3(I1~,I2~,I3~)=
'1'    DS(I1;-J1;J3;(
'1'    DS(I3;-J2;J1;(
'1'    DC("C,TC,I2,-J3,J2)*DC("F,TFE,-1,J1,J2,J3)*DC("F,TGH,-1,J1,J2,J3)*
'1'    DIC(I1,I2,I3,-J1,J1,-J2,J2,-J3,J3) )) ))
'1'   +DS(I3;I2;-J5;J4;Sym;-J5;J4;(
'1'    DC("C,TC,I1,-J4,J5)*DC("F,TGH,-1,J4,J5)*
'1'    VIR1(I1,I2,I3,-J4,J4,-J5,J5) ))
'1'   +DS(I1;I3;-J7;J6;Sym;-J7;J6;(
'1'    DC("C,TC,I2,-J6,J7)*DC("F,TGH,-1,J6,J7)*
'1'    VIR2(I1,I2,I3,-J6,J6,-J7,J7) ))
'1'   +DS(I2;I1;-J8;J9;Sym;-J8;J9;(
'1'    DC("C,TC,I3,-J9,J8)*DC("F,TGH,-1,J8,J9)*
'1'    VIR3(I1,I2,I3,-J8,J8,-J9,J9) ))
'1'Id,Anti,TAP
'1'Id,DIC(I1~,I2~,I3~,K4~,K5~,K6~,K7~,K8~,K9~)=
'1'   VE3(I1,K4,K9,*,MU4,s1,c1,a1,P1,*,L4,s4,c4,a4,K,*,L9,s9,c9,a9,-U1)*
'1'   VE3(I2,K8,K7,*,NU4,s2,c2,a2,P2,*,L8,s8,c8,a8,U1,*,L7,s7,c7,a7,-U3)*
'1'   VE3(I3,K6,K5,*,LA4,s3,c3,a3,P3,*,L6,s6,c6,a6,U3,*,L5,s5,c5,a5,-K)*
'1'   PROP(K5,K4,*,L5,s5,c5,a5,-K,*,L4,s4,c4,a4,K)*     
'1'   PROP(K7,K6,*,L7,s7,c7,a7,-U3,*,L6,s6,c6,a6,U3)*
'1'   PROP(K9,K8,*,L9,s9,c9,a9,-U1,*,L8,s8,c8,a8,U1)
'1'C                              -(P)
'1'C we used inverse conv here  -J ---> J  bec/ we change the internal vectors.
'1'Id,VIR1(I1~,I2~,I3~,K4~,K5~,K6~,K7~)=
'1'   VE4(I3,I2,K6,K5,*,LA4,a3,*,NU4,a2,*,L6,a6,*,L5,a5)*
'1'   VE3(I1,K4,K7,*,MU4,s1,c1,a1,P1,*,L4,s4,c4,a4,-U1,*,L7,s7,c7,a7,K)*
'1'   PROP(K5,K4,*,L5,s5,c5,a5,U1,*,L4,s4,c4,a4,-U1)*
'1'   PROP(K7,K6,*,L7,s7,c7,a7,K,*,L6,s6,c6,a6,-K)
'1'Al,VIR2(I1~,I2~,I3~,K4~,K5~,K6~,K7~)=    
'1'   VE4(I1,I3,K6,K5,*,MU4,a1,*,LA4,a3,*,L6,a6,*,L5,a5)*
'1'   VE3(I2,K4,K7,*,NU4,s2,c2,a2,P2,*,L4,s4,c4,a4,-U2,*,L7,s7,c7,a7,K)* 
'1'   PROP(K5,K4,*,L5,s5,c5,a5,U2,*,L4,s4,c4,a4,-U2)*
'1'   PROP(K7,K6,*,L7,s7,c7,a7,K,*,L6,s6,c6,a6,-K)
'1'Al,VIR3(I1~,I2~,I3~,K4~,K5~,K6~,K7~)=
'1'   VE4(I2,I1,K4,K7,*,NU4,a2,*,MU4,a1,*,L4,a4,*,L7,a7)*
'1'   VE3(I3,K6,K5,*,LA4,s3,c3,a3,P3,*,L6,s6,c6,a6,-K,*,L5,s5,c5,a5,U3)*
'1'   PROP(K5,K4,*,L5,s5,c5,a5,U3,*,L4,s4,c4,a4,-U3)*
'1'   PROP(K7,K6,*,L7,s7,c7,a7,K,*,L6,s6,c6,a6,-K)
C U1=K+P1, U2=K+P2, U3=K-P3=K+P1+P2
C
'2'Id,PTS3(I1~,I2~,I3~)=
'2'    DS(I1;-J1;J3;(
'2'    DS(I3;-J2;J1;(
'2'    DC("C,TC,I2,-J3,J2)*DC("F,TFE,-1,J1,J2,J3)*DC("F,TGH,-1,J1,J2,J3)*
'2'    DIC(I1,I2,I3,-J1,J1,-J2,J2,-J3,J3) )) ))
'2'   +DS(I3;I2;-J5;J4;Sym;-J5;J4;(
'2'    DC("C,TC,I1,-J4,J5)*DC("F,TGH,-1,J4,J5)*
'2'    VIR1(I1,I2,I3,-J4,J4,-J5,J5) ))
'2'   +DS(I1;I3;-J7;J6;Sym;-J7;J6;(
'2'    DC("C,TC,I2,-J6,J7)*DC("F,TGH,-1,J6,J7)*
'2'    VIR2(I1,I2,I3,-J6,J6,-J7,J7) ))
'2'   +DS(I2;I1;-J8;J9;Sym;-J8;J9;(
'2'    DC("C,TC,I3,-J9,J8)*DC("F,TGH,-1,J8,J9)*
'2'    VIR3(I1,I2,I3,-J8,J8,-J9,J9) ))
'2'Id,Anti,TAP
'2'Id,DIC(I1~,I2~,I3~,K4~,K5~,K6~,K7~,K8~,K9~)=
'2'   VE3(I1,K4,K9,*,MU4,s1,c1,a1,P1,*,L4,s4,c4,a4,K,*,L9,s9,c9,a9,-U1)*
'2'   VE3(I2,K8,K7,*,NU4,s2,c2,a2,P2,*,L8,s8,c8,a8,U1,*,L7,s7,c7,a7,-U3)*
'2'   VE3(I3,K6,K5,*,LA4,s3,c3,a3,P3,*,L6,s6,c6,a6,U3,*,L5,s5,c5,a5,-K)*
'2'   PROP(K5,K4,*,L5,s5,c5,a5,-K,*,L4,s4,c4,a4,K)*     
'2'   PROP(K7,K6,*,L7,s7,c7,a7,-U3,*,L6,s6,c6,a6,U3)*
'2'   PROP(K9,K8,*,L9,s9,c9,a9,-U1,*,L8,s8,c8,a8,U1)
'2'C                              -(P)
'2'C we used inverse conv here  -J ---> J  bec/ we change the internal vectors.
'2'Id,VIR1(I1~,I2~,I3~,K4~,K5~,K6~,K7~)=
'2'   VE4p(I3,I2,K6,K5,*,LA4,a3,P3,*,NU4,a2,P2,*,L6,a6,-K,*,L5,a5,U1)*
'2'   VE3(I1,K4,K7,*,MU4,s1,c1,a1,P1,*,L4,s4,c4,a4,-U1,*,L7,s7,c7,a7,K)*
'2'   PROP(K5,K4,*,L5,s5,c5,a5,U1,*,L4,s4,c4,a4,-U1)*
'2'   PROP(K7,K6,*,L7,s7,c7,a7,K,*,L6,s6,c6,a6,-K)
'2'Al,VIR2(I1~,I2~,I3~,K4~,K5~,K6~,K7~)=    
'2'   VE4p(I1,I3,K6,K5,*,MU4,a1,P1,*,LA4,a3,P3,*,L6,a6,-K,*,L5,a5,U2)*
'2'   VE3(I2,K4,K7,*,NU4,s2,c2,a2,P2,*,L4,s4,c4,a4,-U2,*,L7,s7,c7,a7,K)* 
'2'   PROP(K5,K4,*,L5,s5,c5,a5,U2,*,L4,s4,c4,a4,-U2)*
'2'   PROP(K7,K6,*,L7,s7,c7,a7,K,*,L6,s6,c6,a6,-K)
'2'Al,VIR3(I1~,I2~,I3~,K4~,K5~,K6~,K7~)=
'2'   VE4p(I2,I1,K4,K7,*,NU4,a2,P2,*,MU4,a1,P1,*,L4,a4,-U3,*,L7,a7,K)*
'2'   VE3(I3,K6,K5,*,LA4,s3,c3,a3,P3,*,L6,s6,c6,a6,-K,*,L5,s5,c5,a5,U3)*
'2'   PROP(K5,K4,*,L5,s5,c5,a5,U3,*,L4,s4,c4,a4,-U3)*
'2'   PROP(K7,K6,*,L7,s7,c7,a7,K,*,L6,s6,c6,a6,-K)
'2'C U1=K+P1, U2=K+P2, U3=K-P3=K+P1+P2
C
ENDBLOCK


C Read topo1l.bl



LISTS{}
QCDRUL{,,~,~,~}
A N_=2
*fix
C BLOCK WORK{}
C TOPO1L{}
C COMPO{}
C GROUPF{}
C PFF{,}
C DELS{,,,~}
C IF NOT N_^-1
C Al,Addfa,0.
C ENDIF
C Id,Multi,flag5^2=1
C ENDBLOCK
C
P input
Z vertg=PTF3("g,"g,"g)
TOPO1L{}
COMPO{}
GROUPF{}
PFF{,,}
*end
DELS{,,,~}
IF NOT N_^-1
Al,Addfa,0.
ENDIF
Id,Multi,flag5^2=1
Id,flag3=1;flag4=1
Id,D(MU4,NU4)=DELTA(MU4,NU4)
Id,P1(LA4)*DELTA(MU4,NU4)=GLU3(MU4,NU4,LA4,P1,P2)
  -(  - D(MU4,NU4)*P2(LA4)
      - 2*D(MU4,LA4)*P1(NU4)
      - D(MU4,LA4)*P2(NU4)
      + D(NU4,LA4)*P1(MU4)
      + 2*D(NU4,LA4)*P2(MU4)  )
Id,DELTA(MU4,NU4)=D(MU4,NU4)
C Id,GLU3(MU4,NU4,LA4,P1,P2)=
        P1(LA4)*D4(MU4,NU4)
      - D(MU4,NU4)*P2(LA4)
      - 2*D(MU4,LA4)*P1(NU4)
      - D(MU4,LA4)*P2(NU4)
      + D(NU4,LA4)*P1(MU4)
      + 2*D(NU4,LA4)*P2(MU4)


*end
Z selfq=SELF("q,"q_)
WORK{}
*next
Z selfc=SELF("c,"c_)
WORK{}
*next
Z selfg=SELF("g,"g)
WORK{}
Id,m0=0
Id,flag3=1;flag4=1
Id,CAS2(Gr)=1/5*[5*CAS2(Gr)-4*Tg(Rep)]+4/5*Tg(Rep)
Id,D(MU4,NU4)=P1DP1^-1*([D(MU4,NU4)P1DP1-P1(MU4)P1(NU4)]+P1(MU4)*P1(NU4))
*next
Z vertq=PTF3("q,"q_,"g)
WORK{}
*next
Z vertc=PTF3("c,"c_,"g)
WORK{}
Id,flag3=1
*end
