; Schoonschip, a program for symbol handling 
; Copyright (C) 1997 M.J.G. Veltman
;
; This file is part of Schoonschip.  It is free software; you
; can redistribute it and/or modify it under the terms of the
; GNU Lesser General Public License as published by the Free
; Software Foundation; either version 3 of the License, or (at
; your option) any later version.  That license incorporates the
; terms and conditions of version 3 of the GNU General Public
; License, supplemented by additional permissions.
;
; This software is distributed in the hope that it will be
; useful, but WITHOUT ANY WARRANTY; without even the implied
; warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
; PURPOSE.  See the GNU General Public License for more
; details.
;
; You should have received copies of the GNU Lesser General
; Public License and the GNU General Public License along with
; this program.  If not, see <http://www.gnu.org/licenses/>.
;
; If you take advantage of the option in the GNU LGPL to put a
; particular version of this library under the GNU GPL, the
; author(s) would regard it as polite if you would put any
; direct modifications under the GNU LGPL as well, and include a
; copy of this request near the beginning of the modified
; library source.  A "direct modification" is one that enhances
; or extends the library in line with its original concept, as
; opposed to developing a distinct application or library which
; might use it.

;Schoonschip macro's.
;Compile with .Key<0 for tests: gives very small output space.

.SET XTEST=0		;Test long X-expr nr.

.SYNO Textblok=.BLOCK /text/
.SYNO Textbloi=.BLOCK /text/
.SYNO Textblox=.BLOCK /text/
.SYNO Textbloo=.BLOCK /text/
.SYNO Datablok=.BLOCK /data/
.SYNO Bssblok=.BLOCK Bsspace

.SET FilleR=0xA5AA55A5
.SET BufW=10064
.SET BufR=10160
;.SET BufW=5032
;.SET BufR=5080
.SET SMALO=200		;Output sizes for tests (.Key < 0).
.SET StackS=4000	;Stack size assumed.
.SET SubFS=220000	;Subfile size.

.SET VSIZE=10160	;Size presort space.

.READIF .Key<0
.COPY
Small Version.
.ENDC
.SET VSIZE=SMALO
.ENDIF

.SET FlineS=64			;Fortran line size (72-6 -2).
.SET StaL=8192			;Length of the long string table.
.SET SuxL=2048			;Length of Subexpr space (for expr as fu arg)
.SET MaxiF=8
.SET IfcoL=8*MaxiF
.SET IEPSZ=2*BufR
.SET Locdim=3120
.SET IeplenG=7500
.SET IscaL=1300
.SET Liscal=IscaL-30
.SET Ndimi=BufW
.SET NsSiz=640
.SET NdSiz=NsSiz/4	;Max nr of dummies. Must be < 256, else make 252.
.SET NsdSiz=32		;Special dummies.
.SET NsyN=10	;Number of synonym entries.
.SET NrsW=12
.SET NusE=40	;Maximum of Use (created indices) entries.
.SET NdeL=10	;By default length of one entry in Nageh etc.
.SET NxeL=16	;Length of one entry in Nxgeh.
.SET MaxX=1023	;Maximum Nxgeh entries (X-expressions etc.).
.SET NxgS=MaxX*NxeL+NxeL	;Dimension Nxgeh
.SET NblO=64	;Maximum number of blocks.
.SET IpiL=10	;Length Idgeh entries header
.SET SubE=140	;Length subexpression buffer

.READIF NxeL=16
.MACRO MULX{a}
 lsll #4,D'a'
.ENDM
.MACRO DIVX{a}
 lsrl #4,D'a'
.ENDM
.ELSE
.MACRO MULX{a}
 mulu #NxeL,D'a'
.ENDM
.MACRO DIVX{a}
 divu #NxeL,D'a'
.ENDM
.ENDIF

;Must be in same order as in Lovbug.a, jmpaddr.
;
.MACRO JumperS{LOC,a,b}
'LOC' _'a'exp'b',_'a'add'b',_'a'cfi'b'
'LOC' _'a'cif'b',_'a'div'b',_'a'mul'b',_'a'rac'b'
'LOC' _'a'stox'b',_'a'xtos'b',_'a'indcr'b'
'LOC' _'a'evnum'b',_'a'xprint'b',_'a'bdump'b'
'LOC' _'a'get'b',_'a'put'b',_'a'afman'b',_'a'afmanc'b'
'LOC' _'a'openl'b',_'a'readl'b',_'a'writl'b'
'LOC' _'a'delel'b',_'a'stats'b',_'a'check'b'
.ENDM
;
.MACRO AddreS{LOC,a}
'LOC' Igetn'a'
'LOC' Nageh'a',Nalge'a',Ipr'a'
'LOC' Nvigeh'a',Nvind'a',Nqx'a',Ipr1'a'
'LOC' Nvgeh'a',Nvect'a',Ndoti'a',Iscal'a'
'LOC' Nfgeh'a',Nfun'a',Neps'a',Iep'a'
'LOC' Nxgeh'a',Nxex'a'
.ENDM

.STRUCTURE HOLY
.LOCALS Holy

.MACRO EXPRNR
;
.STRUCTURE _Storag
.LOCALS Itin,ISIZE,Itout,OSIZE		;Symbolic.

.STRUCTURE HIGHMEM
.LOCALS IidgehX,IEPSZ,BufX,BufR,CombufX,BufR,NxgehX,NxgS
.EQU HighS=.-HIGHMEM
;
.SYNO Reado=&-6		|.SYNO Requesto=&-9
.SYNO Rewindo=&-7	|.SYNO Rweofro=&-10
.SYNO Weofo=&-8		|.SYNO Weofro=&-4
.SYNO Writeo=&-5	|.SYNO Searby=&-3
.SET Yeptap=4
.SET Starbeg=1
.SET Starend=2
.SET Starnex=3
.SET Staryep=4
.SET Starfix=5
.ENDM

.MACRO ExpR{a}
 .SET NexP=NexP+1
 .SET EX'a'=4*'a'
.ENDM

.SET NexP=0

ExpR{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20}

.SET DimEx=4*NexP

.MACRO BLANK

.STRUCTURE AREA
;.BLOCK //
;
;Up to BlankZ is zeroed at start.
;
Blankst:
.LOCALS Expressions,DimEx,_Foutp,6,_Fout,6
Jumpers:
JumperS{.LOCALS,F,{,6}}		;Result: .LOCALS _Fexp,6 etc.
;
.EVEN 4
;
.LOCALS Stringsp,Itbase,Isize,Osize,ITin,ITend,Memstart,Totsize
.LOCALS Ndimux,Ndimuo,Ndimtx
;
.LOCALS Schoon,Schrijf
;
.LOCALS Sflag,Flag,Flags,8,Zerofl,Extaddr,8,Beepxae,8,Starts,64,Dotcr,1024
.LOCALS Lay1,2,Lay2,2,Lay4,2,Bloknamc,2,Antilistt,Antilistf,Ncont,12
.LOCALS Donr,2,Nq1,2,Bldoc,2,Ovflow,2,Direct,Crecord,256,Statcnt,18,Nqu,8
.LOCALS Totbytes,Mergefiles,88,Maddr,Mlength,Mcount,Lstart,Large,Dryrun
.LOCALS Round,2,Domore,2,Synos,Nsyno,Subxpr,Switches,NrsW,Swaddr,Reserve
;
.LOCALS nreT,44,memT,44,memR,44,zeroesT,20		;Tafman locals.
;
.EVEN 4
;
.LOCALS Bldef,1,Comment,1,Ecomm,1,Isplay,1
.LOCALS Mfout,1,Names,1,Nrep,1,Nvra,1
.LOCALS Yepflag,1,Nblankflag,1,Volcnt,1,Not_Yet,1
;
.EVEN 4
;
BlankZ:
;
;From here to BlankS zeroed in Schoon.
;
.LOCALS Mmbu,2,Mneps,2,I1001,Level,2,Outful,2,Ncrin,2,Kkuit,2
.LOCALS Yterm,Ntem,Nweg,Nzelf,Idaan,Crind,2,Nspec,2
.LOCALS Nmult,Lntem,Vnzelf,Vnweg,Mergers,Mtail,2
.LOCALS Invisible,Anneke,Helene,Hugo,Martijn
;
.EVEN 4
;
BlankS:
;
.LOCALS Bargli,144,Bladdr,Blargc,2,Blokarga,40
.LOCALS Blokarli,1280,Blokarls,Bloklev,2,Bloklic,Bloknam,NblO*16
.LOCALS Bufaddr,Bufin1,4112,Bufin3,4112,Bufin9,4112
.LOCALS Bufp,Chtable,Comadr,2,Interrupt,24,Pointers,24
.LOCALS Doarg,80,Dolist,160,Idadr,Afour,Linp,2,Maxrecord,2,Maximum
.LOCALS Idgeh,Iidgehx,Instack,40,Instackp,Afive,Iepfuad,Ieplim
.LOCALS Line,160,Line1,40,Line2,50,Lline,160,Maxid,2,Niuse,2,Mbe,Mbr,200
.LOCALS Mbu,Mmbe,N5ps,Strsize,2,Yepmem,6
.LOCALS Mulsp,Na,2,Nalge,2,Nanu,2,Nasff,2,Nbr,2
.LOCALS Ndoti,2,Neps,2,Nffo,Nfun,2,Np,2,Nqx,2,Cmode,2
.LOCALS Vprev,Vpres,Aprev,Apres,Ns,NsSiz,Iget,4,Igetn,16,Nsa,NsSiz
;
;To correspond to structure SORT
;
.LOCALS Nsubs,Lndimt,Ndimu,Jeerst,S1red
.LOCALS Lnp,2,Lna,2,Lnsaff,2,Lans,Lansa,Lacoef,Largsm,4
;
.LOCALS Vnsubs,Ndimt,Vndimu,Vjeerst,Vs1red
.LOCALS Vnp,2,Vna,2,Vnasff,2,Vans,Vansa,Vacoef,Vlargsm,4
;
.LOCALS Nsum,2,Ntap1,Ntap2,Ntap3,Ntap4,Ntap5,Ntap6,Ntap7,Ntap8
.LOCALS Ntap9,NtapA,Ntema,Ntime,Nvect,2,Nvind,2
.LOCALS Nwoc,Nxex,2,Skip,2,Outlim,Stdin,Stdout,Sxr4
.LOCALS Tapcnt,40,Tapenam,8,Tapuse,40,Tbytes,Volum,400
;
Cvaria:
AddreS{.LOCALS,A}		;Result: .LOCALS IgetA etc.
;
.EVEN 
;
.LOCALS nnoti,eqtapes,2,sp6kep,8,spkep,sttime		;Schoonschip locals.
.LOCALS Regkeep,64,Bytedump,80
;
.LOCALS rr3L,16,kk1L,8,itcL,2,ii2L,2,lineW,80		;Lovbug, Wrong locals.
.LOCALS lin2W,lin6W
;
.LOCALS Nusegeh,10*NusE,Nvigeh,2600,Nxgeh,Nvgeh,320,Nfgeh,2240,Filcrs,200
.LOCALS Filnam,1000,Nageh,2600,Loc,Locdim,Mref,70,Mrefh,72,Mtab,80
.LOCALS Ipr1,300,Ipr,520,Iscal,IscaL,Naant,42,Nid,168
.LOCALS Bytes,12,Combuf,Bufx,Regsi,12
;
.LOCALS Endbl
;
.EVEN 4
Blanke:

.EQU Fram6=Blankst+0x7FF0

.EQU printbr=Ncont+4
.EQU printhd=Ncont+6
.EQU printci=Ncont+5
.EQU printco=Ncont+9
.EQU printer=Ncont+7
.EQU printi=Ncont+2
.EQU printli=Ncont+10
.EQU printo=Ncont+1
.EQU printst=Ncont+8
.EQU puncho=Ncont
.EQU showtap=Ncont+11

.ASSUME A6=Fram6

.ENDM

.MACRO Movexpr{a,b}
 movel Expressions+'a','b'
.ENDM


;Note on Ordering.
; The natural way to order characters and anti-characters is
; like A A_ B B_ or A_ A B_B etc rather then ordering by ascii
; code with bit seven set for antiparticles: A B A_ B_.
; For symmetrization one must order the first way; consider a
; situation like Sym, D1,-D2. Now let W U occur, and therefore
; also U W. If W but not U is its own antiparticle then the
; first case gives W U_ and the second U W. By 'natural ordering'
; one would keep the second case, the ascii ordering keeps both
; which is wrong.
; The natural ordering can be achieved simply by rotating the byte
; by one, making the anti-bit the least significant. Inverting
; the anti bit makes the anti characters first.
;On top of this one wants numbers after characters. This can
; be achieved with an eor 0x40 on the characters. This changes
; 1  into q
; Q  into \Q
; q  into 1
; \Q into Q
;The ordering becomes: Q q \Q 1.
; This is acceptable if no control characters (=dummies) occur.
;
.MACRO Natur{D0}
 eorb #0xC0,'D0' |rolb #1,'D0'
.ENDM

;This macro gives ordering including zero, although @ and 0 compete.
;
.MACRO Naturz{D0}
 tstb D0 |beq 1f |eorb #0xC0,'D0' |rolb #1,'D0'
1:
.ENDM

;This macro gives ordering putting _ after a,A but before numbers.
;
.MACRO Naturu{D0}
 cmpb #"_",'D0' |beq 1f |eorb #0xC0,'D0'
1: rolb #1,'D0'
.ENDM

.MACRO Natur_{D0}
 rorb #1,'D0' |eorb #0xC0,'D0'
.ENDM

.MACRO Error{n}
 jsr _Fout |.WORD 'n'
.ENDM

.MACRO Errorp{n}
 jsr _Foutp |.WORD 'n'
.ENDM

.MACRO PCREL{A1,a}
1: movel #'a'-1b,'A1' |jsr 1b('A1')
.ENDM

.MACRO PCRELB{A1,a}
1: movel #'a'-1b,'A1' |jmp 1b('A1')
.ENDM

.MACRO ten{D0,D1}
 addw 'D0','D0' |movew 'D0','D1'
 addw 'D1','D1' |addw 'D1','D1' |addw 'D1','D0'
.ENDM

.MACRO tens{D0,D1}
 mulu #10,'D0'
.ENDM

.MACRO twelve{D0,D1}
 addw 'D0','D0' |addw 'D0','D0'
 movew 'D0','D1' |addw 'D1','D1' |addw 'D1','D0'
.ENDM

.MACRO twelves{D0,D1}
 mulu #12,'D0'
.ENDM

.MACRO INCOM
.STRUCTURE INSTOR
;.BLOCK //
Incomst:
.LOCALS Incom,Aa,Pilot,Ccode,2,Delmask,2,Ds1,2,Erexp,2,Expofl,2,Fite,2
.LOCALS Ia,8,Ial,2,Ib,8,Idlin,6,Ido1,2
.LOCALS Ifaddr,Ifcode,IfcoL,Ifdepth,Iminus,2,Intcon,2,Ita,4,Itta
.LOCALS Jani,Jdvf,Kterm,Lda1,14,Levch,2,Levcl,2,Levhy,2,Levlo,2
.LOCALS Nxxo,Lvec,Maxbrx,2,Ncind,2,Ndumy,2,Nhak,Nhak1
.LOCALS Ni,2,Norder,2,Np31,Nrfix,8,Nrfloat,32,Nxxx,Slash,2,Symb1,256
.LOCALS Subs,Symb2,Symb3,Tapma1,Temp1,6,Tus1a,Systart,2,Sycnt,2
.LOCALS Symb4,10,Vlag,Vlagt,2,Ww1,Xdre,Xxgeh,Csflag,12,Group,2,Argc,2
.LOCALS Azpmem,1,Bba,1,Bbb,1,Datafl,1,Dsxi1,1
.LOCALS Frvec,1,Fuarg,1,Idind,1,Idofl,1
.LOCALS Ilk,1,Nbind,1,Nblan,1,Nnum,1
.LOCALS Nrflag,1,Nteken,1,Rind,1,Sqbr,1,Tabin,1
.LOCALS Vecin,1
.EVEN
;
.LOCALS xxxI,16,rr1I,16,nn1I,8,idoI,8			;Inlay, Inp locals.
.LOCALS lsignI,2,indI,2,itcI,2
;
Incomz:
;
.SET IdumS=400
.SET IeplenGI=IeplenG+BufR-IdumS
.SET Liep=IeplenGI-80
;
.LOCALS Idum,IdumS,Iep,IeplenGI
;
.EVEN 4
.LOCALS Incomend
Income:

.EQU A=Ipr1+150		;input line (150 maximum)

Textblok
.ASSUME INSTOR=Blanke
.ENDM

.MACRO EXCOM
.SET IdumS=1024

.STRUCTURE EXSTOR
;.BLOCK //
Excomst:
.LOCALS A1stor,Anthau,B1b,Pilot,Ccode,2,Keypres,2,Comm,32
.LOCALS Compl,Conser,8,Gstatus,12,Fild,12,Levelrest,2,Excnt,2
.LOCALS Firstjmp,Iepfu,128,Idgfu,44,Idum,IdumS		;Allow Iepfu overshoot
.LOCALS Arglist,12,Spdum,NsdSiz,Iswi,Numlist,Keyd,Lastid,Nflag	; (for Gammas).
.LOCALS Levbuf,Marker,Mbe1,Mbe11,Mbe2,Mbe4,Mbef,Mben,Mbeww
.LOCALS Mbu1,2,Mbu5,2,Mbuw,336,Mbuww,2,Ndum,2,Nmdum,Nepsg,Nextid
.LOCALS Nqb,Returr,336,SPkeep,Stcrind,6,Zexprnr,2
.LOCALS Epsm,Namefl
Excomz:
;
;Used for character sum evaluation (strictly contained within dschar).
; May (and is) be used elsewhere.
;
.LOCALS Ccount,Mbeprev,Image,32,Symlist,12,Grlist,16,Strings,Xcstart,Xcend
.LOCALS Antilist,Dposit,8,Istring,18,Cstring,10
.EQU ChaL=Istring-Ccount	;Part to be zeroed.
;
.EVEN 4
.LOCALS Filbuf,BufR,Iep,IeplenG		;Together is large buffer.
Excomend:

.STRUCTURE SORT
 .LOCALS Nsubs_l,Ndimt_l,Ndimu_l,Jeerst_l,S1red_l
 .LOCALS Np_l,2,Na_l,2,Nasff_l,2,ANs_l,ANsa_l,ACoef_l,Largsm_l,2

Textblok
.ASSUME EXSTOR=Blanke
.ENDM

.MACRO OUTCOM
.STRUCTURE OUSTOR
;.BLOCK //
Outcomst:
.LOCALS Algebp,Bracket,2,Nuri,6,Dcont,8,Lstring
.LOCALS Filnrrec,Filnmrec,Hline,60,Ireg,2,Oexp,2
.LOCALS Llim,Nfol,Nklops,Norpr,2,Pucnt,2,Npa,Nrecor
.LOCALS Nreco,Nrem,Nwor,Nwords,Outlad
.LOCALS Puflags,Poutcnt,8,Putap,Tus1,Vectp
.LOCALS Delflag,1,Keepfl,1,Nfirst,1
.EVEN
.LOCALS nrbuO,32,xxxO,16,rr1O,16,rr2O,16,rr3O,16	;Outlay locals
.LOCALS nn1O,8,nn2O,8,iupO,8,idoO,8,kk1O,8,nraddrO,4
.LOCALS araddrO,8,nprecO,6,tryO,2,lsignO,2,indO,2,icrO,2
.LOCALS itcO,2,kk4O,2,ii2O,2,iexO,2
Outcomz:
.EVEN 4
.LOCALS Subexpr,SubE,Outline,200,Pubuf,700,Rubbis,44
.LOCALS Filbuf,BufR,Iep,IeplenG		;Together is large buffer.
.EVEN 4
Outcomend:

Textblok
.ASSUME OUSTOR=Blanke
.ENDM
