C Selected tests and examples.
C Essay 1. Beep command and Ratio command, using [] type symbols.
C Essay 2. Ratio command.
C Essay 3. Use of .... in front of statements.
C Essay 4. Symbolic integration of x^n from A to B.
C Essay 5. Numbers: Precision, Digits and Rationalization.
C Essay 6. Complex conjugation spinors and gammas.
C Essay 7. Simple G-string.
C Essay 8. Gamma command, "C and "A options.
C Essay 9. Gamma command, options "I, "W and "P.
C Essay 10. Gamma command, options "I, "W and "P.
C Essay 11. Projecting out basic gamma 3- and 1-strings.
C Essay 12. Projecting out basic gamma 4-, 2- and 0-strings.
C Essay 13. Various gamma try-outs.
C Essay 14. Order command.
C Essay 15. Gamma command, no "S option.
C Essay 16. Gamma command, with "S option.
C Essay 17. Spin summation.
C Essay 18. Gamma command test.
C Essay 19. Order command with "C option.
C Essay 20. Collecting Gammas and Spinors.
C Essay 21. Order command with various options.
C Essay 22. Some simple N-dimensional traces.
C Essay 23. Various traces and strings.
C Essay 24. DC function. Symmetrized Id argument.
C Essay 25. The All command.
C Essay 26. An N-dimensional trace.
C Essay 27. A product of two N_dimensional traces.
C Essay 28. Various N-dimensional traces.
C Essay 29. Test of IF etc. statements.
C Essay 30. All command and Gamma matrices.
C Essay 31. All command with function as argument.
C Essay 32. All with G-function as argument and Gamma, Ndotpr commands.
C Essay 33. All with G-function as argument and Gamma, Ndotpr commands.
C Essay 34. Epf function reduction.
C Essay 35. Mixed N- and 4-dimensional traces.
C Essay 36. A trace of 10 gammas.
C Essay 37. Traces and Ndotpr command.
C Essay 38. Trace and Ndotpr command.
C Essay 39. Gamma with "A option
C Essay 40. Overflow.
C Essay 41. Miscellaneous gamma tests.
C Essay 42. Miscellaneous gamma tests.
C Essay 43. Miscellaneous gamma tests.
C Essay 44. Miscellaneous gamma tests.
C Essay 45. Miscellaneous gamma tests.
C Essay 46. Numerical "common" files.
C Essay 47. Numerical "next" files.
C Essay 48. Miscellaneous gamma tests.
C Essay 49. Miscellaneous gamma tests.
C Essay 50. Miscellaneous gamma tests.
C Essay 51. Miscellaneous gamma tests.
C Essay 52. Miscellaneous gamma tests.
C Essay 53. Freeze test with Excl on B-line.

*end

C Essay 1. Beep command and Ratio command, using [] type symbols.

B [b-a]

Z xxx = 1/[x+a] * 1/[x+b]

Id,Ratio,[x+a],[x+b],[b-a]
Beep 20
*end

C Essay 2. Ratio command.

B bma

Z xxx = xpa^-1 * xpb^-1

Id,Ratio,xpa,xpb,bma
*end

C Essay 3. Use of .... in front of statements.

Z xx = a + b*x^3 + c*x^-1

IF Multi,x^-1
OR x
Id,aaa=7
..IF x^-1
..Id,x^-1 = [log(B/A)]
..ENDIF
Id,x^n~=B^(n+1)/(n+1) - A^(n+1)/(n+1)
ELSE
Id,Addfa,(B-A)
ENDIF
Al,aaa=7
*end

C Essay 4. Symbolic integration of x^n from A to B.

Z xx = a + b*x

IF NOT x
Id,Addfa,(B-A)
ELSE
Id,x^n~=B^(n+1)/(n+1) - A^(n+1)/(n+1)
ENDIF

*end

C Essay 5. Numbers: Precision, Digits and Rationalization.

Precision 15
Rationalization 5
Digits 3
Z xx=3.141592654 + 0x12Ab*a + 1/3*ab + 7.1234567E-10*c
 + 1E15*abc + abc - 1E15*abc
 + 1E14*abd + abd - 1E14*abd
*end

C Essay 6. Complex conjugation spinors and gammas.

I mu=N,nu=N
V p,q
Z xx = Conjg( G6(i0,i1)*G(i1,i2,mu)*G(i2,i3,nu)*Ubg(i0,M,p)*Ug(i3,M,q))
Id,Gammas,"C
*end

C Essay 7. Simple G-string.

I mu=N,nu=N
Z xx = G(i1,i2,mu)*G(i2,i1,nu)
Id,Gammas
*end

C Essay 8. Gamma command, "C and "A options.

I mu=N,nu=N
Z xx = G(i1,i2,mu)*G5(i2,i3)*G(i3,i4,mu)
Id,Gammas,"C
Keep xx
*next
Z x1=xx
Id,Gammas
Keep xx
*next
Z x2=xx
Id,Gammas,"A
*end

C Essay 9. Gamma command, options "I, "W and "P.

I mu=N,nu=N
Z xx= G(i1,"s,"4,mu,G5) * F1(mu)
      + G(i1,"s,"4,mu,nu,G5) * F1(mu,nu)
Id,Gammas,"I_,"W_,"P_
P output
*yep
Id,Gammas
*end

C Essay 10. Gamma command, options "I, "W and "P.

I mu=N, nu=N, al=N, be=N, ga=N
Z xx=  { G(i1,i2,mu,ga,nu,al,be,ga)
      + G(i1,i1,mu,ga,nu,al,be,ga) }*F1(mu,nu,al,be)
Id,Gammas,"I,"W_,"P_
P output
*yep
Id,Gammas
P output
*end

C Essay 11. Projecting out basic gamma 3- and 1-strings.

I mu=N, nu=N, al=N, be, b1=N, b2=N, b3=N, b4=N

Z xx=  { 1/(4*DB(3)) * G(L,"t,"4,mu,nu,al,b1,b2,b3)} * AG(L,b3,b2,b1)
       + 1/(4*DB(1)) * G(L,"t,"4,mu,nu,al,b1) * AG(L,b1)

Id,Gammas
Id,Asymm,AG,2,3,4,5,6
*end

C Essay 12. Projecting out basic gamma 4-, 2- and 0-strings.

I mu=N, nu=N, al=N, be=N, b1=N, b2=N, b3=N, b4=N

Z xx = { 1/(4*DB(4)) * G(L,"t,"4,mu,nu,al,be,b1,b2,b3,b4)} * AG(L,b4,b3,b2,b1)
       + 1/(4*DB(2)) * G(L,"t,"4,mu,nu,al,be,b1,b2) * AG(L,b2,b1)
       + 1/4 * G(L,"t,"4,mu,nu,al,be) * AG(L)

Id,Gammas
Id,Asymm,AG,2,3,4,5,6
*end

C Essay 13. Various gamma try-outs.

P stats
I mu=N, nu=N, ga=N, la=N, al=N, be=N

X Gstr(i1,i2,n,mu,nu,la,ga,al,be) =
  G(i1,n,mu)*G(n,n+1,nu)*G(n+1,n+2,la)*G(n+2,n+3,ga)*G(n+3,n+4,al)*G(n+4,i2,be)

Z s0 = Gstr(i1,i2,1,mu,mu,la,ga,al,be)
Z t0 = Gstr(i1,i1,1,mu,mu,la,ga,al,be)
Z s1 = Gstr(i1,i2,1,mu,nu,mu,ga,al,be)
Z t1 = Gstr(i1,i1,1,mu,nu,mu,ga,al,be)
Z s2 = Gstr(i1,i2,1,mu,nu,la,mu,al,be)
Z t2 = Gstr(i1,i1,1,mu,nu,la,mu,al,be)
Z s3 = Gstr(i1,i2,1,mu,nu,la,ga,mu,be)
Z t3 = Gstr(i1,i1,1,mu,nu,la,ga,mu,be)
Z s4 = Gstr(i1,i2,1,mu,nu,la,ga,al,mu)
Z t4 = Gstr(i1,i1,1,mu,nu,la,ga,al,mu)

Id,Gammas
P output
*yep
Id,Gammas,Trace,i1
Id,N_=N-4
Keep s0,t0,s1,t1,s2,t2,s3,t3,s4,t4
*next

C Results should be all zero.

Z x0 = s0 - t0
Z x1 = s1 - t1
Z x2 = s2 - t2
Z x3 = s3 - t3
Z x4 = s4 - t4
*end

C Essay 14. Order command.

Z xx = Fab(4,5,ddd)*Fab(2,3,bbb)*Fab(1,2,aaa)*Fab(3,4,ccc)
 *Faa(14,15,ddd)*Faa(12,13,bbb)*Faa(11,12,aaa)*Faa(13,14,ccc)
Id,Order,"C,Faa,Fab
*next
Z xx = Fab(4,5,ddd)*Fab(2,3,bbb)*Fab(1,2,aaa)*Fab(3,4,ccc)
 *Faa(14,15,ddd)*Faa(12,13,bbb)*Faa(11,12,aaa)*Faa(13,14,ccc)

Id,Order,Faa,Fab
*next
Z xx = Fab(4,5,ddd)*Fab(2,3,bbb)*Fab(1,2,aaa)*Fab(3,4,ccc)
 *Faa(14,15,ddd)*Faa(12,13,bbb)*Faa(11,12,aaa)*Faa(13,14,ccc)

Id,Order,90,Faa,Fab
*end

C Essay 15. Gamma command, no "S option.

I mu=N,nu=N,al=N,be=N
X Sin(i1,i2,mu) = ag*G(i1,i2,mu) + a1*Gi(i1,i2) + a5*G5(i1,i2)
 + a6*G6(i1,i2) + a7*G7(i1,i2)
Z xs=Sin(i1,i2,mu)
Z xd=Sin(i1,i2,mu)*Sin(i2,i3,nu)

Id,Gammas,"S_
*end

C Essay 16. Gamma command, with "S option.

I mu,nu,al,be
X Sin(i1,mu) = ag*G(i1,mu) + a1*Gi(i1) + a5*G5(i1)
 + a6*G6(i1) + a7*G7(i1)
Z xs=Sin(i1,mu)
Z xd=Sin(i1,mu)*Sin(i1,nu)
Id,Gammas
*end

C Essay 17. Spin summation.

I mu=N,nu=N,al=N,be=N
V p,q,k

Z xx = Ubg(i1,M,p)*G(i1,"S,"7,mu)*Ug(i1,m,q)
 *Ubg(i2,m,q)*G(i2,"S,"7,al)*Ug(i2,M,p)
Keep xx
*next
Z x1=xx
Id,Spin,q
Keep xx
*next
Z x1=xx
Id,Spin,p,q
*end

C Essay 18. Gamma command test.

I a1=N,a2=N,a3=N,a4=N,a5=N,a6=N
I b1,b2,b3,b4,b5,b6,b7,b8
F F1
V p,q
S m,m1
Z x1=Fa(aa,bb)*Fb(aa,bb)*G(1,2,a1,b1,a1,a2,b2,a3)*F1(a2,a3)*Fc(aa,bb)
Z x2=Fa(aa,bb)*Fb(aa,bb)*G(1,2,a1,b1,a1,a2,b2,a3)*F1(a2,a3)*Ubg(1,m1,q)
  *Fc(aa,bb)
Z x3=Fa(aa,bb)*Ug(2,m,p)*Fb(aa,bb)*G(1,2,a1,b1,a1,a2,b2,a3)*F1(a2,a3)
  *Fc(aa,bb)
Z x4=Fa(aa,bb)*Ug(2,m,p)*Fb(aa,bb)*G(1,2,a1,b1,a1,a2,b2,a3)*F1(a2,a3)
  *Ubg(1,m1,q)*Fc(aa,bb)
Z x5=Fa(aa,bb)*G(3,1,a4)*Fb(aa,bb)*G(1,2,a1,b1,a1,a2,b2,a3)*F1(a2,a3)
 *G(2,3,a4)*Fc(aa,bb)
Id,Gammas
*end

C Essay 19. Order command with "C option.

Z x1 = Fab(4,5,ddd)*Fab(2,3,bbb)*Fab(1,2,aaa)*Fab(3,4,ccc)*
 (  Faa(12,13,bbb)*Faa(11,12,aaa)*Faa(13,14,ccc)
  + Faa(12,13,bbb)*Faa(13,14,ccc)*Faa(11,12,aaa)
  + Faa(11,12,aaa)*Faa(12,13,bbb)*Faa(13,14,ccc)
  + Faa(11,12,aaa)*Faa(13,14,ccc)*Faa(12,13,bbb)
  + Faa(13,14,ccc)*Faa(11,12,aaa)*Faa(12,13,bbb)
  + Faa(13,14,ccc)*Faa(12,13,bbb)*Faa(11,12,aaa) )

Id,Order,"C,Faa,Fab
*end

C Essay 20. Collecting Gammas and Spinors.

C I aaa=N,bbb=N,ccc=N,ddd=N
I aaa,bbb,ccc,ddd
V p
S m
B A1,A2,A3,A4,A5
X Str(i1,i2) =    G(12,13,bbb)*G(i1,12,aaa)*G(13,i2,ccc)
		+ G(12,13,bbb)*G(13,i2,ccc)*G(i1,12,aaa)
		+ G(i1,12,aaa)*G(12,13,bbb)*G(13,i2,ccc)
		+ G(i1,12,aaa)*G(13,i2,ccc)*G(12,13,bbb)
		+ G(13,i2,ccc)*G(i1,12,aaa)*G(12,13,bbb)
		+ G(13,i2,ccc)*G(12,13,bbb)*G(i1,12,aaa)

Z xx= 	  A1*Str(i1,i2)
	+ A2*Str(i1,i2)*G(i2,i1,ddd)
	+ A2*G(i2,i1,ddd)*Str(i1,i2)
        + A3*Ubg(i1,m,p)*Str(i1,i2)
	+ A3*Str(i1,i2)*Ubg(i1,m,p)
	+ A4*Ug(i2,m,p)*Str(i1,i2)
	+ A4*Str(i1,i2)*Ug(i2,m,p)
        + A5*Ug(i2,m,p)*Ubg(i1,m,p)*Str(i1,i2)
        + A5*Ubg(i1,m,p)*Ug(i2,m,p)*Str(i1,i2)
        + A5*Ug(i2,m,p)*Str(i1,i2)*Ubg(i1,m,p)
        + A5*Ubg(i1,m,p)*Str(i1,i2)*Ug(i2,m,p)
        + A5*Str(i1,i2)*Ug(i2,m,p)*Ubg(i1,m,p)
        + A5*Str(i1,i2)*Ubg(i1,m,p)*Ug(i2,m,p)
Id,Gammas,"C
*end

C Essay 21. Order command with various options.

Z xx=Fa(aa,ab)*F1(2,3,bb)*Fb(aa,ab)*F1(1,2,aa)*F1(3,4,cc)*Fc(aa,ab)
Keep xx
*next
Z x1=xx
Id,Order,F1
Keep xx
*next
Z x1=xx
Id,Order,0,F1
Keep xx
*next
Z x1=xx
Id,Order,10,F1
Keep xx
*next
Z x1=xx
Id,Order,"C,F1
Keep xx
*next
Z x1=xx
Id,Order,0,"C,F1
Keep xx
*next
Z x1=xx
Id,Order,10,"C,F1
*end

C Essay 22. Some simple N-dimensional traces.

P stats
I a1=N,a2=N,a3=N,a4=N,a5=N,a6=N
I b1,b2,b3,b4,b5,b6,b7,b8
V p
Z x1 = G(1,"t,"4,a1,a2,a3,a4,a1,a2,a3,a4)
Z x2 = G(1,"t,"4,a1,b2,b3,b4,a1,b2,b3,b4)
Id,Gammas
Id,N=N_+4
*end

C Essay 23. Various traces and strings.

I al=N, be=N, mu, nu

Z x0=
 + a0s*G(1,"s,"4)
 + a0t*G(1,"t,"4)
 + a0s_*G(1,"s,"_)
 + a0t_*G(1,"t,"_)

 + a0S*G(1,"s,"4,Gi) + a05S*G(1,"s,"4,G5)
 + a06S*G(1,"s,"4,G6) + a07S*G(1,"s,"4,G7)

 + a0T*G(1,"t,"4,Gi) + a05T*G(1,"t,"4,G5)
 + a06T*G(1,"t,"4,G6) + a07T*G(1,"t,"4,G7)

Z x1=
 + F1(al)*{
 + a1s*G(1,"s,"4,al)
 + a1t*G(1,"t,"4,al)
 + a1s_*G(1,"s,"_,al)
 + a1t_*G(1,"t,"_,al) }

 + a1S*G(1,"s,"4,Gi,mu) + a15S*G(1,"s,"4,G5,mu)
 + a16S*G(1,"s,"4,G6,mu) + a17S*G(1,"s,"4,G7,mu)

 + a1T*G(1,"t,"4,Gi,mu) + a15T*G(1,"t,"4,G5,mu)
 + a16T*G(1,"t,"4,G6,mu) + a17T*G(1,"t,"4,G7,mu)

Z x2=
 + F2(al,be)*{
 + a2s*G(1,"s,"4,al,be)
 + a2t*G(1,"t,"4,al,be)
 + a2s_*G(1,"s,"_,al,be)
 + a2t_*G(1,"t,"_,al,be) }

 + a2S*G(1,"s,"4,Gi,mu,nu) + a25S*G(1,"s,"4,G5,mu,nu)
 + a26S*G(1,"s,"4,G6,mu,nu) + a27S*G(1,"s,"4,G7,mu,nu)

 + a2T*G(1,"t,"4,Gi,mu,nu) + a25T*G(1,"t,"4,G5,mu,nu)
 + a26T*G(1,"t,"4,G6,mu,nu) + a27T*G(1,"t,"4,G7,mu,nu)

Id,Gammas,1:"S_

*end

C Essay 24. DC function. Symmetrized Id argument.

P lists
X XAX_(I1,I2,K1,K2,L1,L2): Fchar(I1,I2,K1,K2,L1,L2)
T AP: A,Z
Z xx=AX_X("A,"A_,"Y,"Y_,"X,"X_) + ~YAY_~K
 + a1*DC("P,AP,-3,"A_,"A,"B,"A,"B)
 + a2*DC("P,AP,3,"A_,"A,"B,"A,"B)
 + a3*DC("P,AP,-7,"A,"Z_,"A,"B,"Z,"A_,"C,"B,"Z,"C,"D)
 + a7*DC("P,AP,-1,"A,"A,"B,"A,"B,"B,"A)
 + a8*DC("P,AP,-1,"A_,"A,"A,"B,"A,"B,"B,"A)
 + a9*DC("P,AP,-1,"A_,"A,"A,"A,"B,"A,"B,"B,"A)
 + a10*DC("P,AP,-1,"A_,"A,"A,"A,"A,"B,"A,"B,"B,"A)
 + a11*DC("P,AP,-1,"A_,"A,"A,"A,"A,"A,"B,"A,"B,"B,"A)
 + a12*DC("P,AP,-1,"A_,"A,"A,"A,"A,"A,"A,"B,"A,"B,"B,"A)
 + bb1*(6*2)^-3 + bb2*(6*2)^3+ bb3*(6*6*2*2)^-7
 + c4*24*(b4 + 5*(b5 + 6*(b6 + 7*(b7+8*(bb8+9*bb9)))))*6
 + c8*40320*(b8+ 9*(b9 + 10*(b10 + 11*(b11+12*(b12+13*b13)))))
Id,~YAY_~K: 24*aaa
*end

C Essay 25. The All command.

P lists
V p,q
F F
I mu=N,nu=N

Z xx=3*pDp^2*pDq^3*F1(p,p,q,p)*p(mu)*q(nu)

Id,All,p,N,F
Id,F(i1~,i2~,i3~,i4~,i5~,i6~,i7~,i8~,i9~,i10~,i11~)=
 F(i1,i2,i3,i6,i7,i8,i9,i10,i11)*D(i4,i5)
*end

C Essay 26. An N-dimensional trace.

I mu1=N,mu2=N,mu3=N,mu4=N,mu5=N,mu6=N,mu7=N,mu8=N
S N,N_
F F1,F2,F3,F4
V P

Z xx=G(i1,1,mu1)*G(1,2,mu2)*G(2,3,mu3)*G(3,4,mu4)*G(4,5,mu5)
 *G(5,6,mu6)*G(6,7,mu1)*G(7,8,mu2)*G(8,9,mu3)*G(9,10,mu4)*G(10,11,mu5)
 *G(11,i1,mu6)
 -2*a4*4*4^5
Sum,mu1,mu2,mu3,mu4,mu5,mu6,mu7,mu8
Id,Gammas,"C
P output
*yep
Id,Gammas
P output
Id,N=N_+4
*end

C Essay 27. A product of two N_dimensional traces.

I mu1=N,mu2=N,mu3=N,mu4=N,mu5=N,mu6=N,mu7=N,mu8=N
S N,N_
F F1,F2,F3,F4
V P

Z xx=G(i1,1,mu1)*G(1,2,mu2)*G(2,3,mu3)*G(3,4,mu4)*G(4,5,mu5)
 *G(5,i1,mu6)*G(i2,7,mu1)*G(7,8,mu2)*G(8,9,mu3)*G(9,10,mu4)*G(10,11,mu5)
 *G(11,i2,mu6)

Sum,mu1,mu2,mu3,mu4,mu5,mu6,mu7,mu8
Id,Gammas,"C
P output
*yep
Id,Gammas
Id,N=N_+4
*end

C Essay 28. Various N-dimensional traces.

I mu1=N,mu2=N,mu3=N,mu4=N,mu5=N,mu6=N,mu7=N,mu8=N
S N,N_
F F1,F2,F3,F4
V P
B Tr4,Tr6,t00,t11,t000,t011,t020,t121,t222
 ,Tr8,t0000,t0011,t0020,t0121,t0222,t0231,t1111,t1221,t1322,t2332,t3333
Z xx=
 Tr4*{t00*G(i1,1,mu1)*G(1,2,mu1)*G(2,3,mu2)*G(3,i1,mu2)
 + t11*G(i1,1,mu1)*G(1,2,mu2)*G(2,3,mu1)*G(3,i1,mu2) }
 +
 Tr6*{
   t000*G(i1,1,mu1)*G(1,2,mu1)*G(2,3,mu2)*G(3,4,mu2)*G(4,5,mu3)*G(5,i1,mu3)
 + t011*G(i1,1,mu1)*G(1,2,mu1)*G(2,3,mu2)*G(3,4,mu3)*G(4,5,mu2)*G(5,i1,mu3)
 + t020*G(i1,1,mu1)*G(1,2,mu1)*G(2,3,mu2)*G(3,4,mu3)*G(4,5,mu3)*G(5,i1,mu2)
 + t121*G(i1,1,mu1)*G(1,2,mu2)*G(2,3,mu1)*G(3,4,mu3)*G(4,5,mu2)*G(5,i1,mu3)
 + t222*G(i1,1,mu1)*G(1,2,mu2)*G(2,3,mu3)*G(3,4,mu1)*G(4,5,mu2)*G(5,i1,mu3)
  }
 + Tr8*{
   t0000*G(i1,1,mu1)*G(1,2,mu1)*G(2,3,mu2)*G(3,4,mu2)*G(4,5,mu3)*G(5,6,mu3)
  *G(6,7,mu4)*G(7,i1,mu4)
 +  t0011*G(i1,1,mu1)*G(1,2,mu1)*G(2,3,mu2)*G(3,4,mu2)*G(4,5,mu3)*G(5,6,mu4)
  *G(6,7,mu3)*G(7,i1,mu4)
 + t0020*G(i1,1,mu1)*G(1,2,mu1)*G(2,3,mu2)*G(3,4,mu2)*G(4,5,mu3)*G(5,6,mu4)
  *G(6,7,mu4)*G(7,i1,mu3)
 + t0121*G(i1,1,mu1)*G(1,2,mu1)*G(2,3,mu2)*G(3,4,mu3)*G(4,5,mu2)*G(5,6,mu4)
  *G(6,7,mu3)*G(7,i1,mu4)
 + t0222*G(i1,1,mu1)*G(1,2,mu1)*G(2,3,mu2)*G(3,4,mu3)*G(4,5,mu4)*G(5,6,mu2)
  *G(6,7,mu3)*G(7,i1,mu4)
 + t0231*G(i1,1,mu1)*G(1,2,mu1)*G(2,3,mu2)*G(3,4,mu3)*G(4,5,mu4)*G(5,6,mu2)
  *G(6,7,mu4)*G(7,i1,mu3)
 + t1111*G(i1,1,mu1)*G(1,2,mu2)*G(2,3,mu1)*G(3,4,mu2)*G(4,5,mu3)*G(5,6,mu4)
  *G(6,7,mu3)*G(7,i1,mu4)
 + t1221*G(i1,1,mu1)*G(1,2,mu2)*G(2,3,mu1)*G(3,4,mu3)*G(4,5,mu2)*G(5,6,mu4)
  *G(6,7,mu3)*G(7,i1,mu4)
 + t1322*G(i1,1,mu1)*G(1,2,mu2)*G(2,3,mu1)*G(3,4,mu3)*G(4,5,mu4)*G(5,6,mu2)
  *G(6,7,mu3)*G(7,i1,mu4)
 + t2332*G(i1,1,mu1)*G(1,2,mu2)*G(2,3,mu3)*G(3,4,mu1)*G(4,5,mu4)*G(5,6,mu2)
  *G(6,7,mu3)*G(7,i1,mu4)
 + t3333*G(i1,1,mu1)*G(1,2,mu2)*G(2,3,mu3)*G(3,4,mu4)*G(4,5,mu1)*G(5,6,mu2)
  *G(6,7,mu3)*G(7,i1,mu4)
 }
Sum,mu1,mu2,mu3,mu4,mu5,mu6,mu7,mu8

Id,Gammas
P stats
Id,N_=N-4
P output
*yep
B Tr4,Tr6,t00,t11,t000,t011,t020,t121,t222
 ,Tr8,t0000,t0011,t0020,t0121,t0222,t0231,t1111,t1221,t1322,t2332,t3333
Id,N=4
*end

C Essay 29. Test of IF etc. statements.

B A1,B1,A2,B2,A3,B3,A4,B4

Z xx=a*b + a + b + c

IF a
AND b
Id,Addfa,A1
ELSE
Id,Addfa,B1
ENDIF

IF NOT a
OR b
Id,Addfa,A2
ELSE
Id,Addfa,B2
ENDIF

IF a
OR NOT b
Id,Addfa,A3
ELSE
Id,Addfa,B3
ENDIF

IF a
AND NOT b
Id,Addfa,A4
ELSE
Id,Addfa,B4
ENDIF

C Output must be:
C   A1*A2*A3*B4  * ( a*b ) + B1*A2*A3*B4 * ( c )
C + B1*A2*B3*B4 * ( b )    + B1*B2*A3*A4 * ( a )
*end

C Essay 30. All command and Gamma matrices.

I al,be,mu,nu
A N,N_
V p,k
F F,F20,F22

Z xx = G(1,1,al,be,p,al,be,p)

Id,All,p,N,F
Id,F(i1~,i2~) = D(i1,i2)*F20(k) + k(i1)*k(i2)*F22(k)

Id,Gammas
*end

C Essay 31. All command with function as argument.

I al,be,mu,nu
A N,N_
V p,k
F F,F20,F22

Z xx = G(1,1,al,be,p,al,be,p)

Id,All,G,N,F
*end

C Essay 32. All with G-function as argument and Gamma, Ndotpr commands.

F F1
I mu,nu,al=N,be=N,ga=N,de=N
V p,q,k,l
Z ft = G(1,1,k,G5,p,q,l,G5,q,p)
Id,All,G,N,F1
P output
*yep
Id,Gammas
P output
*yep
Id,Ndotpr,F1
P output
*yep
P lists
*end

C Essay 33. All with G-function as argument and Gamma, Ndotpr commands.

F F1
I mu,nu
V p,q
A N,N_
Z ft = G(1,1,mu,G5,p,nu,G5,q)
Id,All,G,N,F1
C P output
C *yep
Id,Gammas,"A
C P output
C *yep
Id,Ndotpr,F1
C P output
C *yep
C P lists
*end

C Essay 34. Epf function reduction.

I Naa
V P,K,W2
Z xx= Epf(Naa,P,K,W2)*Epf(Naa,P,K,W2)
Id,Trick
*end

C Essay 35. Mixed N- and 4-dimensional traces.

I mu,nu,al=N,be=N,ga=N,de=N
V p,q
Z ft1 = G(1,mu)*G5(1)*G(1,al)*G(1,be)*G(1,nu)*G5(1)*G(1,be)*G(1,al) 
Z ft2 = G(1,mu)*G5(1)*G(1,nu)*G5(1) 
Z ft1 = G(1,mu)*G5(1)*G(1,al)*G(1,be)*G(1,nu)*G5(1)*G(1,al)*G(1,be) 
Id,Gammas,Trace,1
*end

C Essay 36. A trace of 10 gammas.

P stats
I a1,a2,a3,a4,a5,a6
I b1,b2,b3,b4,b5,b6,b7,b8
V p
Z xx = G(1,"T,"4,a1,a2,a3,a4,a5,p,b1,b2,b3,p)
Id,Gammas
P noutp
*end

C Essay 37. Traces and Ndotpr command.

F F1
I mu,nu,al=N,be=N,ga=N,de=N
V p,q,k,P,Q,K
Z ft = G(1,1,p,G5,q,k,P,G5,Q,K)
Z fp = G(1,1,q,k,P,G5,Q,K,p,G5)
Id,All,G,N,F1
Id,Gammas,"A
Id,Ndotpr,F1
P stats
*yep
Id,pq_=pDq-pq4
Al,kP_=kDP-kP4
Al,QK_=QDK-QK4
Al,pk_=pDk-pk4
Al,qP_=qDP-qP4
Al,pP_=pDP-pP4
Al,qk_=qDk-qk4
Id,pQ_=pDQ-pQ4
Al,PK_=PDK-PK4
Al,pK_=pDK-pK4
Al,PQ_=PDQ-PQ4
Al,kQ_=kDQ-kQ4
Al,qQ_=qDQ-qQ4
Al,kK_=kDK-kK4
Al,qK_=qDK-qK4
Keep ft,fp
*next
Z xx=ft-fp
P stats
*end

C Essay 38. Trace and Ndotpr command.

P stats
I mu,nu,al=N,be=N,ga=N,de=N
V p,q
Z ft = G(1,1,mu,G5,al,be,nu,G5,ga,de) * F1(al,be,ga,de)
Id,Trick,Trace,1
P output
Sum al,be,ga,de
*yep
Id,Ndotpr,F1,p,q,q,p
P output
*yep
P lists
*end

C Essay 39. Gamma with "A option

P stats
I mu,nu,al=N,be=N,ga=N,de=N
V p,q
Z ft1 = G(1,1,mu,G5,al,be,nu,G5,be,al) 
Z ft2 = G(1,1,mu,G5,nu,G5) 
Z ft3 = G(1,1,mu,G5,al,be,nu,G5,al,be) 
Z ft1p = G(2,2,mu,G5,al,be,nu,G5,be,al) 
Z ft2p = G(2,2,mu,G5,nu,G5) 
Z ft3p = G(2,2,mu,G5,al,be,nu,G5,al,be) 
Id,Gammas,1:"A,2
*end

C Essay 40. Overflow.

Overflow off
Z xx= + a1^120*a1^10 + a2^-120*a2^-10
*end

C Essay 41. Miscellaneous gamma tests.

A N,N_
V P
I MU=N,s1,s2,s3
*fix
Z aa0=G(s1,s1,MU,P,G6)*G(s2,s3,MU,G6)
Z aa1=G(s1,s1,MU,P,G5)*G(s2,s3,MU,G6)
     +G(s1,s1,MU,P)*G(s2,s3,MU,G6)
Id,Gammas
P output
*next
Z aa2=G(s2,s3,MU,G6)*G(s1,s1,MU,P,G6)
Id,Gammas
*end

C Essay 42. Miscellaneous gamma tests.

A N,N_
I mu,nu,la,ga
I s3
Z xx2=G(s3,s3,ga,mu)
Id,Gammas
Keep xx2
*next
P list
A aa
Z xxp=aa*xx2
*end

C Essay 43. Miscellaneous gamma tests.

A N,N_
I mu=N,nu=N,la,si
Z xx=G(1,2,mu)*G(3,3,mu,nu,la,si)*fff(nu)
Id,Gammas
*end

C Essay 44. Miscellaneous gamma tests.

C Needs two gamma commands if results from one are to become
  implemented in the other.

I mu,nu,ga
Z xx=G(1,2,mu,nu)*G(3,3,mu,nu)
Id,Gammas
*end

C Essay 45. Miscellaneous gamma tests.

A N,N_
I mu,nu
Z xx=G(3,4,mu,nu)
Z xy=G(1,2,mu,nu)
Id,Gammas,1:"C,3:"U,"A_,"S_,"I_,"P_,"W_,"i_
*end

C Essay 46. Numerical 'common" files.

Rat 0
Common xx
Z xx=1/4*3/17*56
*next

C This works only if xx integer < 2^29.

Z cc=a/{xx}
*end

C Essay 47. Numerical "next" files.

Rat 0
Z xx=1/4*3/17*56
Keep xx
*next
Z cc=a/{xx}
*end

C Essay 48. Miscellaneous gamma tests.

A N,N_
I mu,nu
Z xx=G(1,2,mu,mu,nu)
Id,Gammas,"C
*end

C Essay 49. Miscellaneous gamma tests.

I mu1=N,mu2=N,mu3=N,mu4=N
*fix

Z aa1=G(3,4,mu1,mu2,mu3,mu4)*G(1,1,mu1,mu2,mu3,mu4)
Id,Gammas,"U
Id,Gammas
Id,N_=N-4
*end

C Essay 50. Miscellaneous gamma tests.

I mu5,mu1=N,mu2=N,mu3=N,mu4=N
*fix

Z aa=Epf(mu1,mu2,mu3,mu4)*G(1,1,mu1,mu2,mu3,mu4,G5)
Id,Gammas
*end

C Essay 51. Miscellaneous gamma tests.

I mu1=N,mu2=N,mu3=N,mu4=N      
*fix
Z aa2=G(1,1,mu1,mu2,G6)*G(3,4,mu1,mu2)
Id,Gammas
*end

C Essay 52. Miscellaneous gamma tests.

I mu1=N,mu2=N,mu3=N,mu4=N      
*fix

Z aa0=G(3,4,mu1,mu2,mu3,mu4,G5)*G(1,1,mu1,mu2,mu3,mu4,G5)
Id,Gammas						
*end

C Essay 53. Freeze test with Excl on B-line.

P ni
F gam,gam6,gam7,NOM
V P,Q,K
I AL,BE,GA,DE,MU,NU
*fix
Common aa
Z aa= gam(s1,s2,AL)*gam(s2,s3,MU)*NOM(K,XM)*(1-x)
     +gam(s1,s2,BE)*gam(s2,s3,GA)*NOM(K,XM)*(1-x)
B Excl,x
*begin
Names aa
Freeze aa
Z cc=aa
P ou
*end
