C Miscellaneous 1.  N-4 trace of 20 gamma's with paired indices.
C Miscellaneous 2.  A test of N-traces.
C Miscellaneous 3.  Simple freeze example, with B Excl use.
C Miscellaneous 4.  Example Use statement.
C Miscellaneous 5.  Example Chain and Use statements.
C Miscellaneous 6.  Example invisible function.
C Miscellaneous 7.  Options in Commu command.
C Miscellaneous 8.  Example symmetrization X-expressions and substitions.
C Miscellaneous 9.  Switches Sw0 etc. Run with S=62. The Synonym statement.
C Miscellaneous 10. Trace of 12 gamma's. Writes xg12.
C Miscellaneous 11. Numerical evaluation of previous. Needs xg12.
C Miscellaneous 12. Trace of 14 or 16 gamma's.
C Miscellaneous 13. Indexed file manipulations.
*end

C Miscellaneous 1.  N-4 trace of 20 gamma's with paired indices.

A N,N_
I i1=N,i2=N,i3=N,i4=N,i5=N,i6=N,i7=N,i8=N,i9=N,iA=N

Z xx=G(1,"t,"_,i1,i2,i3,i4,i5,i6,i7,i8,i9,iA,i1,i2,i3,i4,i5,i6,i7,i8,i9,iA)

Id,Gammas
Id,N=N_+4
*yep
C To get result as published (Nucl. Phys. B319 (1989) 253):

Id,Addfa,N_^-1*[N-4]
Id,N_=N-4
B [N-4]
*end

C Miscellaneous 2.  A test of N-traces.

I al=N,be=N,mu=N,nu=N,ro=N
F F
A N,N_,EP
P stats
P list

C The second term is the rotated of the first. The result must be zero.

Z zero=G(1,2,G6,al,G7,mu,be)*
       (G(5,5,G6,al,G7,nu,be,ro)-G(5,5,nu,be,ro,G6,al,G7))/4*
        F(mu,nu,ro)

C The second term is the reversed of the first. The result must be zero.

Z zerp=G(1,2,G6,al,G7,mu,be)*
       (G(5,5,G6,al,G7,nu,be,ro)-G(5,5,ro,be,nu,G7,al,G6))/4*
        F(mu,nu,ro)

Id,Gammas
Id,N=4-2*EP
Sum be,mu,nu,ro
*end

C Miscellaneous 3.  Simple freeze example, with B Excl use.

Common xx
F F1,F2
Z xx=F1(a1)*(a1+a2+a3)^2 + F2(a2)*(a1+a2-a3)^2
B Excl,a1
*begin
Freeze xx
Z x1=xx
*begin
Z x2=xx
Id,Expand,xx
B Excl,a1
*end

C Miscellaneous 4.  Example Use statement.

I al,be=N,ga
I ia=3,ib=3,ic=3,id=3

Z xx=F1(al,be,ga,ia,ib,ic,id)*F2(al,be,ga,ia,ib,ic,id)

Sum al,be,ga,ia,ib,ic,id
Use mu,nu,3,ic,id,N,na
*end

C Miscellaneous 5.  Example Chain and Use statements.

I i1,i2,i3,i4,i5,i6
F Tr

Z xx =
 f1(ab1,i2,i3,def)*f2(ab1,i1,i2)*f3(i3,i1,ab3)
 + f1(ab1,i2,i3,def)*f2(ab1,i2)*f3(i3,ab3)

Id,Chain,Tr,i1,i2,i3,i4
*begin

C Next, using also the Use statement:

F X_,Y,Wg,Tr,U
I mu,nu,ic,id

Z xx = Wg(mu,ic,id)*U(mu)*X_(nu,ic)*Y(id,nu)

Id,Chain,Tr,ic,id
Id,Commu,Tr
Sum,mu,nu
Use mu,nu
*begin

C Open ended. Nothing is done:

F X_,Y,Wg,Tr,U
I mu,nu,ic,id

Z xx = Wg(mu,ic,id)*U(mu)*X_(nu,ic)*Y(nu)

Id,Chain,Tr,ic,id,ie,if
Id,Commu,Tr
Sum,mu,nu
Use mu,nu
*begin

C Now specifying the "S option:

F X_,Y,Wg,Tr,U
I mu,nu,ic,id

Z xx = Wg(mu,ic,id)*U(mu)*X_(nu,ic)*Y(nu)

Id,Chain,"S,Tr,ic,id,ie,if
Id,Commu,Tr
Sum,mu,nu
Use mu,nu
*end

C Miscellaneous 6.  Example invisible function.

C First a simple expression, no invisible statement.
C Output second differs as F2 is removed before printing:

F F1,F2
Z xx=F1(-a,b)*a1*a2*a3^2*F1(a,b,c)
 - F3(-a,b)*a1*a2^-2*a3^2*F1(a,b,c)
 + abc*def*a3

Id,Count,"N,F2,a3,-7 : a1,1,a2,3

*begin


F F1,F2
Z xx=F1(-a,b)*a1*a2*a3^2*F1(a,b,c)
 - F3(-a,b)*a1*a2^-2*a3^2*F1(a,b,c)
 + abc*def*a3

Id,Count,"N,F2,a3,-7 : a1,1,a2,3
Invisible F2
*begin

C Another example, involving algebraic quantities with negative exponent.

Z xx=(a+b)^5/a^2
*begin

F F1

Z xx=(a+b)^5/a^2

Id,Count,"N,F1,a,1
Invisible F1
*end

C Miscellaneous 7.  Options in Commu command.

C Without options.

F f3,f1,f2,f4

Z xx=f1(a,b,c)*f2(a1,a2)*f3*f4(b1,b2)

Id,Commu,f1,f3
*begin

C With the "B option:

F f3,f1,f2,f4

Z xx=f1(a,b,c)*f2(a1,a2)*f3*f4(b1,b2)

Id,Commu,"B,f1,f3
*begin

C With the "N option:
 
F f3,f1,f2,f4

Z xx=f1(a,b,c)*f2(a1,a2)*f3*f4(b1,b2)
Id,Commu,"N,f1,f3
*begin

C With both "B and "N option:
 
F f3,f1,f2,f4

Z xx=f1(a,b,c)*f2(a1,a2)*f3*f4(b1,b2)
Id,Commu,"N,"B,f1,f3
*end

C Miscellaneous 8.  Example symmetrization X-expressions and substitions.

F F1
X BAC(b1,b2,a1,a2,c1,c2): F1(a1,a2,b1,b2,c1,c2)
X BAC~AB(b1,b2,a1,a2,c1,c2): F1(a1,a2,b1,b2,c1,c2)
X K~BAC~AB(b1,b2,a1,a2,c1,c2): F1(a1,a2,b1,b2,c1,c2)
X L~BAC~AB(x1,x2;b1,b2,a1,a2,c1,c2;z1,z2): F1(x1,x2,a1,a2,b1,b2,c1,c2,z1,z2)
P lists

Z xx = t1*ABC(1,2,3,4,5,6)
     + t2*ABCAB(1,2,3,4,5,6)
     + t3*KABCAB(1,2,3,4,5,6)
     + t4*LABCAB(xx1,xx2,1,2,3,4,5,6,yy1,yy2)
     + labck(p1,p2,y1,y2,y3,q1,q2)

Id,l~bac~k(x1~,x2~;xb~,xa~,xc~;z1~,z2~): hello*F1(x1,x2,xa,xb,xc,z1,z2)
*end

C Miscellaneous 9.  Switches Sw0 etc. Run with S=62. The Synonym statement.

C If on the command line S=# is specified (# byte size, range -128,127)
  then Sw0=#. Default setting is zero.

Synonym Xxx = _Sw0

Set _Sw9 = 3
Set _Sw1 = 2-3*(22/2-4)
Set _Sw2 = 2-(22&2-4)*_Sw9
Set _Sw3 = 6
Set _Sw4 = 1 | 0x20

Z xx = (a + b) ^ 3 + a0^'Xxx' + a1^_Sw1 + a2^_Sw2 + a3^_Sw3 + a4*_Sw4

Gotoif 20, _Sw3 > 5

Id, b = 20*c
Goto 21

@20
Id,b = a + c

@21
*end

C Miscellaneous 10. Trace of 12 gamma's. Writes xg12.

V p1,p2,p3,p4,p5,p6,p7,p8,p9,pA,pB,pC,pD,pE,pF
Common xx
*fix
Z xx = G(1,1,p1,p2,p3,p4,p5,p6,p7,p8,p9,pA,pB,pC)
P stats
Show
Id,Gammas
B p1,p2
P noutput
*begin
Write xg12
*end

C Miscellaneous 11. Numerical evaluation of previous. Needs xg12.

V p1,p2,p3,p4,p5,p6,p7,p8,p9,pA,pB,pC,pD,pE,pF
Enter xg12
*fix

Z xxx=xx

*yep

C If there is no numerical factor in the above trace then this
 must be the outcome, using the numbers below.

 Terms out 4383, in 4383.

 Terms in output 1
 Running time 33 sec			Used	Maximum
 Generated terms 4383 	Input space 	2726 	100000
 Equal terms 4382     	Output space 	32 	250000
 Cancellations 0   	Nr of expr.  	6 	255
 Multiplications 8766	String space 	0 	4096
 Records written 20 	Merging		0 	0

 
 xx =  + .3025863551D+48 + 0.

P Stats
P ninput

C The set of numbers below is for randomly chosen four-vectors.
 
N 10
Id,Numer,p1Dp2,72073513.,p1Dp3,84624678.,p1Dp4,52509276.,p1Dp5,51607603.
Al,Numer,p1Dp6,97117707.,p1Dp7,56091995.,p1Dp8,86086713.,p1Dp9,35361640.
Al,Numer,p1DpA,52382708.,p1DpB,73476464.,p1DpC,43256071.,p1DpE,73552929.
Al,Numer,p1DpF,73736029.,p1DpG,85237214.,p1DpH,57088000.,p2Dp3,99738370.
Al,Numer,p2Dp4,86314985.,p2Dp5,70453871.,p2Dp6,114248683.,p2Dp7,71422567.
Al,Numer,p2Dp8,111259313.,p2Dp9,53967084.,p2DpA,67563860.,p2DpB,105294076.
Al,Numer,p2DpC,80101547.,p2DpE,99741072.,p2DpF,89430253.,p2DpG,120620977.
Al,Numer,p2DpH,67901148.,p3Dp4,81886836.,p3Dp5,78333162.,p3Dp6,129931642.
Al,Numer,p3Dp7,73417210.,p3Dp8,114641070.,p3Dp9,53105168.,p3DpA,67662024.
Al,Numer,p3DpB,105931360.,p3DpC,65681146.,p3DpE,90384834.,p3DpF,102491670.
Id,Numer,p3DpG,119024304.,p3DpH,67785960.,p4Dp5,65638463.,p4Dp6,95841513.
Al,Numer,p4Dp7,57807475.,p4Dp8,91573602.,p4Dp9,48779546.,p4DpA,53427202.
Al,Numer,p4DpB,92602282.,p4DpC,70162391.,p4DpE,74670732.,p4DpF,77988563.
Al,Numer,p4DpG,102550456.,p4DpH,48875972.,p5Dp6,90443091.,p5Dp7,47695075.
Al,Numer,p5Dp8,76742276.,p5Dp9,40483748.,p5DpA,45773000.,p5DpB,77824668.
Al,Numer,p5DpC,48501848.,p5DpE,52444477.,p5DpF,75606173.,p5DpG,86766052.
Al,Numer,p5DpH,40718765.,p6Dp7,89530891.,p6Dp8,139462170.,p6Dp9,66035460.
Al,Numer,p6DpA,69714280.,p6DpB,130843196.,p6DpC,71080454.,p6DpE,93706193.
Al,Numer,p6DpF,129431917.,p6DpG,132445888.,p6DpH,64945659.,p7Dp8,83332720.
Al,Numer,p7Dp9,38621796.,p7DpA,45376392.,p7DpB,76558044.,p7DpC,51169940.
Id,Numer,p7DpE,68638885.,p7DpF,68739493.,p7DpG,82107028.,p7DpH,45576657.
Al,Numer,p8Dp9,60708938.,p8DpA,70447618.,p8DpB,119818042.,p8DpC,79864763.
Al,Numer,p8DpE,104522004.,p8DpF,107983346.,p8DpG,128570005.,p8DpH,69766703.
Al,Numer,p9DpA,31692264.,p9DpB,60384376.,p9DpC,41320406.,p9DpE,45083384.
Al,Numer,p9DpF,52958348.,p9DpG,62750528.,p9DpH,28237146.,pADpB,63384328.
Al,Numer,pADpC,52441382.,pADpE,73310168.,pADpF,53806792.,pADpG,81865676.
Al,Numer,pADpH,55017622.,pBDpC,78406262.,pBDpE,90686008.,pBDpF,103929492.
Al,Numer,pBDpG,122346824.,pBDpH,58392674.,pCDpE,83783556.,pCDpF,55609870.
Al,Numer,pCDpG,94241443.,pCDpH,52995366.,pEDpF,68270479.,pEDpG,116882021.
Al,Numer,pEDpH,83242387.,pFDpG,104799048.,pFDpH,47968569.,pGDpH,82563879.
*end

C Miscellaneous 12. Trace of 14 or 16 gamma's.
C By default the 14 gamma case is done. If on the command line
  a non-zero Sw0 is specified (with the S=.. option) then the 16 gamma
  case is executed.

Large 5
P stats
V p1,p2,p3,p4,p5,p6,p7,p8,p9,pA,pB,pC,pE,pF,pG,pH
B p1Dp2,p1Dp3,p1Dp4,p1Dp5,p1Dp6,p1Dp7,p1Dp8,p1Dp9,p1DpA,p1DpB,p1DpC,
  p1DpE,p1DpF,p1DpG,p1DpH

Gotoifn 16,_Sw0=0

Z xx=
  G(1,p1)*G(1,p2)*G(1,p3)*G(1,p4)
 *G(1,p5)*G(1,p6)*G(1,p7)*G(1,p8)
 *G(1,p9)*G(1,pA)*G(1,pB)*G(1,pC)
 *G(1,pE)*G(1,pF)
Goto 20

@16
Z xx=
  G(1,p1)*G(1,p2)*G(1,p3)*G(1,p4)
 *G(1,p5)*G(1,p6)*G(1,p7)*G(1,p8)
 *G(1,p9)*G(1,pA)*G(1,pB)*G(1,pC)
 *G(1,pE)*G(1,pF)
 *G(1,pG)*G(1,pH)

@20

Id,Trick,Trace,1
Outlimit,6500000
P noutput
Showl
*yep

C The set of numbers below is for randomly chosen four-vectors.

C Result should be:
  14 G:
 xx =  + .9427566923E+56 + 0.
 
 Running time 225 (91 first part) sec with *yep.
 Running time 180 sec (no *yep).
 Generated terms 31599


  16 G:
 xx =  + .7804709442D+64 + 0.

 Running time 1820 (1027 first part) sec with *yep
 Running time 1185 sec (no *yep).
 Generated terms 197541


P ninput

N 10
Id,Numer,p1Dp2,72073513.,p1Dp3,84624678.,p1Dp4,52509276.,p1Dp5,51607603.
Al,Numer,p1Dp6,97117707.,p1Dp7,56091995.,p1Dp8,86086713.,p1Dp9,35361640.
Al,Numer,p1DpA,52382708.,p1DpB,73476464.,p1DpC,43256071.,p1DpE,73552929.
Al,Numer,p1DpF,73736029.,p1DpG,85237214.,p1DpH,57088000.,p2Dp3,99738370.
Al,Numer,p2Dp4,86314985.,p2Dp5,70453871.,p2Dp6,114248683.,p2Dp7,71422567.
Al,Numer,p2Dp8,111259313.,p2Dp9,53967084.,p2DpA,67563860.,p2DpB,105294076.
Al,Numer,p2DpC,80101547.,p2DpE,99741072.,p2DpF,89430253.,p2DpG,120620977.
Al,Numer,p2DpH,67901148.,p3Dp4,81886836.,p3Dp5,78333162.,p3Dp6,129931642.
Al,Numer,p3Dp7,73417210.,p3Dp8,114641070.,p3Dp9,53105168.,p3DpA,67662024.
Al,Numer,p3DpB,105931360.,p3DpC,65681146.,p3DpE,90384834.,p3DpF,102491670.
Id,Numer,p3DpG,119024304.,p3DpH,67785960.,p4Dp5,65638463.,p4Dp6,95841513.
Al,Numer,p4Dp7,57807475.,p4Dp8,91573602.,p4Dp9,48779546.,p4DpA,53427202.
Al,Numer,p4DpB,92602282.,p4DpC,70162391.,p4DpE,74670732.,p4DpF,77988563.
Al,Numer,p4DpG,102550456.,p4DpH,48875972.,p5Dp6,90443091.,p5Dp7,47695075.
Al,Numer,p5Dp8,76742276.,p5Dp9,40483748.,p5DpA,45773000.,p5DpB,77824668.
Al,Numer,p5DpC,48501848.,p5DpE,52444477.,p5DpF,75606173.,p5DpG,86766052.
Al,Numer,p5DpH,40718765.,p6Dp7,89530891.,p6Dp8,139462170.,p6Dp9,66035460.
Al,Numer,p6DpA,69714280.,p6DpB,130843196.,p6DpC,71080454.,p6DpE,93706193.
Al,Numer,p6DpF,129431917.,p6DpG,132445888.,p6DpH,64945659.,p7Dp8,83332720.
Al,Numer,p7Dp9,38621796.,p7DpA,45376392.,p7DpB,76558044.,p7DpC,51169940.
Id,Numer,p7DpE,68638885.,p7DpF,68739493.,p7DpG,82107028.,p7DpH,45576657.
Al,Numer,p8Dp9,60708938.,p8DpA,70447618.,p8DpB,119818042.,p8DpC,79864763.
Al,Numer,p8DpE,104522004.,p8DpF,107983346.,p8DpG,128570005.,p8DpH,69766703.
Al,Numer,p9DpA,31692264.,p9DpB,60384376.,p9DpC,41320406.,p9DpE,45083384.
Al,Numer,p9DpF,52958348.,p9DpG,62750528.,p9DpH,28237146.,pADpB,63384328.
Al,Numer,pADpC,52441382.,pADpE,73310168.,pADpF,53806792.,pADpG,81865676.
Al,Numer,pADpH,55017622.,pBDpC,78406262.,pBDpE,90686008.,pBDpF,103929492.
Al,Numer,pBDpG,122346824.,pBDpH,58392674.,pCDpE,83783556.,pCDpF,55609870.
Al,Numer,pCDpG,94241443.,pCDpH,52995366.,pEDpF,68270479.,pEDpG,116882021.
Al,Numer,pEDpH,83242387.,pFDpG,104799048.,pFDpH,47968569.,pGDpH,82563879.
P output
*end

C Miscellaneous 13. Indexed file manipulations.

P ni
P no
Outlimit 4000000
D Eigen(n)=
   8,16,113/9,17/3,(-16/3*aa),(2/3+aa/12+del),(2/3+aa/12-del),
  28/3,(8-8/3*aa),32/3,64/9

*fix

BLOCK mulmat{AB,A,B,dim}
Common 'B'1(0)
DO K1=1,'dim'
Z 'B'1('K1')='B'
IF NOT x^'K1'=1
Id,Addfa,0
ENDIF
*next
ENDDO

Z 'AB'='A'
Id,y^n~='B'1(n)
*next
ENDBLOCK

P no
Common A0,B0,C0,AB,mat

R mat(WW) = 
  - 1/16*WW*Pi^-2*x*y*g^2 - 1/16*WW*Pi^-2*x^2*y^2*g^2 - 1/16*WW*Pi^-2
  *x^3*y^3*g^2 - 1/16*WW*Pi^-2*x^4*y^4*g^2 - 1/16*WW*Pi^-2*x^5*y^5
  *g^2 - 1/16*WW*Pi^-2*x^6*y^6*g^2 - 1/16*WW*Pi^-2*x^7*y^7*g^2
  - 1/16*WW*Pi^-2*x^8*y^8*g^2 - 1/16*WW*Pi^-2*x^9*y^9*g^2
  - 1/16*WW*Pi^-2*x^10*y^10*g^2 - 1/16*WW*Pi^-2*x^11*y^11*g^2
  - 1/16*WW*Pi^-2*x^12*y^12*g^2 - 1/16*WW*Pi^-2*x^13*y^13*g^2
  - 1/16*WW*Pi^-2*x^14*y^14*g^2 - 1/16*WW*Pi^-2*x^15*y^15*g^2
  - 1/16*WW*Pi^-2*x^16*y^16*g^2 - 1/16*WW*Pi^-2*x^17*y^17*g^2
  - 1/16*WW*Pi^-2*x^18*y^18*g^2 - 1/16*WW*Pi^-2*x^19*y^19*g^2
  - 1/16*WW*Pi^-2*x^20*y^20*g^2 - 1/16*WW*Pi^-2*x^21*y^21*g^2
  - 1/16*WW*Pi^-2*x^22*y^22*g^2 - 1/16*WW*Pi^-2*x^23*y^23*g^2
  - 1/16*WW*Pi^-2*x^24*y^24*g^2 - 1/16*WW*Pi^-2*x^25*y^25*g^2
  + 1/24*aa*Pi^-2*x^3*y^2*g^2 - 1/24*aa*Pi^-2*x^3*y^10*g^2
  + 1/24*aa*Pi^-2*x^3*y^14*g^2 + 1/8*aa*Pi^-2*x^4*y^2*g^2
  - 1/8*aa*Pi^-2*x^4*y^5*g^2 - 7/192*aa*Pi^-2*x^4*y^6*g^2
  - 1/8*aa*Pi^-2*x^4*y^10*g^2 - 1/12*aa*Pi^-2*x^4*y^11*g^2
  - 1/6*aa*Pi^-2*x^4*y^13*g^2 + 1/8*aa*Pi^-2*x^4*y^14*g^2
  - 1/6*aa*Pi^-2*x^4*y^15*g^2 + 7/192*aa*Pi^-2*x^4*y^16*g^2
  - 1/6*aa*Pi^-2*x^4*y^18*g^2 + 1/12*aa*Pi^-2*x^4*y^19*g^2
  - 1/6*aa*Pi^-2*x^4*y^21*g^2 + 1/6*aa*Pi^-2*x^5*y^2*g^2 - 1/3*aa*Pi^-2
  *x^5*y^5*g^2 - 1/6*aa*Pi^-2*x^5*y^10*g^2 + 1/6*aa*Pi^-2*x^5*y^14
  *g^2 + 3/32*aa*Pi^-2*x^6*y^3*g^2 + 3/32*aa*Pi^-2*x^6*y^4*g^2
  - 3/32*aa*Pi^-2*x^6*y^5*g^2 + 1/96*aa*Pi^-2*x^6*y^6*g^2
  - 1/12*aa*Pi^-2*x^6*y^11*g^2 - 1/6*aa*Pi^-2*x^6*y^13*g^2
  - 1/6*aa*Pi^-2*x^6*y^15*g^2 - 5/48*aa*Pi^-2*x^6*y^16*g^2
  - 1/6*aa*Pi^-2*x^6*y^18*g^2 - 1/12*aa*Pi^-2*x^6*y^19*g^2
  - 1/6*aa*Pi^-2*x^6*y^21*g^2 - 1/6*aa*Pi^-2*x^15*y^13*g^2
  - 1/6*aa*Pi^-2*x^15*y^15*g^2 - 1/6*aa*Pi^-2*x^15*y^18*g^2
  - 1/6*aa*Pi^-2*x^15*y^21*g^2 - 1/6*aa*Pi^-2*x^16*y^13*g^2
  - 1/6*aa*Pi^-2*x^16*y^15*g^2 - 1/6*aa*Pi^-2*x^16*y^18*g^2
  - 1/6*aa*Pi^-2*x^16*y^21*g^2 + 113/144*Pi^-2*x*y*g^2 + 1/6*Pi^-2
  *x*y^2*g^2 - 3/16*Pi^-2*x*y^3*g^2 + 3/16*Pi^-2*x*y^4*g^2
  + 1/48*Pi^-2*x*y^5*g^2 - 7/96*Pi^-2*x*y^6*g^2 + 2/9*Pi^-2*x*y^7*g^2
   - 1/6*Pi^-2*x*y^10*g^2 - 1/6*Pi^-2*x*y^11*g^2 - 5/2*Pi^-2*x*y^13
  *g^2 + 7/3*Pi^-2*x*y^14*g^2 - 71/32*Pi^-2*x*y^15*g^2 + 7/3*Pi^-2
  *x*y^16*g^2 - 5/2*Pi^-2*x*y^18*g^2 + 7/3*Pi^-2*x*y^19*g^2
  + Pi^-2*x*y^20*g^2 - 7/3*Pi^-2*x*y^21*g^2 + 2/3*Pi^-2*x*y^22*g^2
   - 1/8*Pi^-2*x^3*y^2*g^2 + 17/48*Pi^-2*x^3*y^3*g^2 - 7/192*Pi^-2
  *x^3*y^5*g^2 + 1/6*Pi^-2*x^3*y^8*g^2 - 1/24*Pi^-2*x^3*y^10*g^2
  + 1/8*Pi^-2*x^3*y^14*g^2 - 1/8*Pi^-2*x^4*y^2*g^2 + 7/96*Pi^-2*x^4
  *y^3*g^2 + 9/32*Pi^-2*x^4*y^4*g^2 - 17/32*Pi^-2*x^4*y^5*g^2
  + 1/6*Pi^-2*x^4*y^8*g^2 - 1/24*Pi^-2*x^4*y^10*g^2 + 1/8*Pi^-2*x^4
  *y^14*g^2 + 1/2*Pi^-2*x^5*y^14*g^2 + 15/32*Pi^-2*x^6*y^3*g^2
  + 49/96*Pi^-2*x^6*y^4*g^2 - 15/32*Pi^-2*x^6*y^5*g^2 - 19/96*Pi^-2
  *x^6*y^6*g^2 - 1/3*Pi^-2*x^6*y^9*g^2 + 1/12*Pi^-2*x^6*y^11*g^2
  - 1/2*Pi^-2*x^6*y^13*g^2 + 1/2*Pi^-2*x^6*y^14*g^2 - 1/2*Pi^-2*x^6
  *y^15*g^2 + 3/16*Pi^-2*x^6*y^16*g^2 - 1/2*Pi^-2*x^6*y^18*g^2
  + 3/4*Pi^-2*x^6*y^19*g^2 - 1/2*Pi^-2*x^6*y^21*g^2 + 7/12*Pi^-2*x^12
  *y^12*g^2 + 5/2*Pi^-2*x^12*y^13*g^2 - 3/2*Pi^-2*x^12*y^14*g^2
  + 71/32*Pi^-2*x^12*y^15*g^2 - 57/32*Pi^-2*x^12*y^16*g^2
  + 2/3*Pi^-2*x^12*y^17*g^2 + 5/2*Pi^-2*x^12*y^18*g^2 - 3/2*Pi^-2*x^12
  *y^19*g^2 - Pi^-2*x^12*y^20*g^2 + 2*Pi^-2*x^12*y^21*g^2
  - Pi^-2*x^12*y^22*g^2 + 1/2*Pi^-2*x^13*y^13*g^2 + 1/2*Pi^-2*x^14
  *y^14*g^2 + 1/2*Pi^-2*x^15*y^15*g^2 - 1/2*Pi^-2*x^15*y^21*g^2
  - 1/2*Pi^-2*x^16*y^13*g^2 + 1/2*Pi^-2*x^16*y^14*g^2 - 1/2*Pi^-2*x^16
  *y^15*g^2 + Pi^-2*x^16*y^16*g^2 - 1/2*Pi^-2*x^16*y^18*g^2
  + 1/2*Pi^-2*x^16*y^19*g^2 - 1/2*Pi^-2*x^16*y^21*g^2 + 2/3*Pi^-2*x^17
  *y^17*g^2 + 1/2*Pi^-2*x^18*y^18*g^2 + 1/2*Pi^-2*x^19*y^19*g^2
  + Pi^-2*x^20*y^20*g^2 + Pi^-2*x^21*y^21*g^2 + Pi^-2*x^22*y^22*g^2
   + 1/4*Pi^-2*x^23*y^20*KSI - 1/16*Pi^-2*x^24*y^7 + 1/4*Pi^-2*x^24
  *y^13*KSI - 1/4*Pi^-2*x^24*y^14*KSI + 1/4*Pi^-2*x^24*y^15*KSI
  - 1/4*Pi^-2*x^24*y^16*KSI + 1/4*Pi^-2*x^24*y^18*KSI - 1/4*Pi^-2*x^24
  *y^19*KSI + 1/4*Pi^-2*x^24*y^21*KSI - 1/8*Pi^-2*x^24*y^22*KSI
  - 1/2*Pi^-2*x^25*y^13*KSI + 1/2*Pi^-2*x^25*y^14*KSI - 1/2*Pi^-2*x^25
  *y^15*KSI + 1/2*Pi^-2*x^25*y^16*KSI - 1/2*Pi^-2*x^25*y^18*KSI
  + 1/2*Pi^-2*x^25*y^19*KSI + 1/4*Pi^-2*x^25*y^20*KSI - 1/2*Pi^-2*x^25
  *y^21*KSI + 1/4*Pi^-2*x^25*y^22*KSI + 0.
*yep
Id,Addfa,Pi^2*16*g^-2
Id,Addfa,3/8
P no
*next

Z C0=mat(WW)
Id,WW=0
*next

DO J1=1,10
Z B0=mat((Eigen('J1')) )
*next

mulmat{AB,C0,B0,25}

Z C0=AB
Id,Print,1,J1='J1' in process ...
*next
ENDDO

Z RES=C0
P ou
*end
