C Spinor and gamma-matrix checking.
C Compared to diagrammar:
 - Check signs of last two components of vd and vu.
 - Sign (A.15) wrong (no - sign for u| = u C^(-1), 1,4 and 2,3 cases).

C 1 Checking g5.
  2 Checking Dirac equation.
  3 Checking spin-sum equations.
  4 Checking charge conjugation.
  5 Checking charge conjugation transformation of gamma matrices.
  6 Checking time-reversal.
  7 Checking time-reversal transformation of gamma matrices.

A m,E,p1,p2,p3,p4,P1,P2,P3,P4,SIGN

D g1m(I1)=0,0,0,-i, 0,0,-i,0, 0,i,0,0, i,0,0,0
D g2m(I1)=0,0,0,-1, 0,0,1,0, 0,1,0,0, -1,0,0,0
D g3m(I1)=0,0,-i,0, 0,0,0,i, i,0,0,0, 0,-i,0,0
D g4m(I1)=1,0,0,0, 0,1,0,0, 0,0,-1,0, 0,0,0,-1
D g5m(I1)=0,0,-1,0, 0,0,0,-1, -1,0,0,0, 0,-1,0,0
D cc(I1) = 0,0,0,1, 0,0,-1,0, 0,1,0,0, -1,0,0,0
D cci(I1) = 0,0,0,-1, 0,0,1,0, 0,-1,0,0, 1,0,0,0
D tr(I1) = 0,1,0,0, -1,0,0,0, 0,0,0,1, 0,0,-1,0
D tri(I1) = 0,-1,0,0, 1,0,0,0, 0,0,0,-1, 0,0,1,0

X g1(I1,I2)=g1m(4*(I1-1)+I2)
X g2(I1,I2)=g2m(4*(I1-1)+I2)
X g3(I1,I2)=g3m(4*(I1-1)+I2)
X g4(I1,I2)=g4m(4*(I1-1)+I2)
X g5(I1,I2)=g5m(4*(I1-1)+I2)
X CC(I1,I2)=cc(4*(I1-1)+I2)
X CCI(I1,I2)=cci(4*(I1-1)+I2)
X TR(I1,I2)=tr(4*(I1-1)+I2)
X TRI(I1,I2)=tri(4*(I1-1)+I2)

D uu(I1)=1,0,P3,(P1+i*P2)
D ud(I1)=0,1,(P1-i*P2),-P3
D vd(I1)=-P3,(-P1-i*P2),-1,0
D vu(I1)=(P1-i*P2),-P3,0,1
end
*end
C 1 Checking g5.

Read Spincheck.e
*fix

DO i1=1,4
DO i2=1,4
Z xx'i1''i2' = GAM5('i1','i2')
ENDDO
ENDDO
Id,GAM5(I0~,I4~) =
  DS(I1,1,4,(
        DS(I2,1,4,(
         DS(I3,1,4,( g1(I0,I1)*g2(I1,I2)*g3(I2,I3)*g4(I3,I4) ))
                 )) )) - g5(I0,I4)
*end
C 2 Checking Dirac equation.

Read Spincheck.e
*fix

DO i1=1,4
C (i gamma p + m) u =0
Z uu'i1' = DS(I1,1,4,(
  ( i*g1('i1',I1)*p1 + i*g2('i1',I1)*p2
  + i*g3('i1',I1)*p3 + i*g4('i1',I1)*p4 + m*DK('i1',I1) )*uu(I1)
  ))
Z ud'i1' = DS(I1,1,4,(
  (+ i*g1('i1',I1)*p1 + i*g2('i1',I1)*p2
  + i*g3('i1',I1)*p3 + i*g4('i1',I1)*p4 + m*DK('i1',I1) )*ud(I1)
  ))
C (- i gamma p + m) v =0
Z vd'i1' = DS(I1,1,4,(
  (- i*g1('i1',I1)*p1 - i*g2('i1',I1)*p2
  - i*g3('i1',I1)*p3 - i*g4('i1',I1)*p4 + m*DK('i1',I1) )*vd(I1)
  ))
Z vu'i1' = DS(I1,1,4,(
  (- i*g1('i1',I1)*p1 - i*g2('i1',I1)*p2
  - i*g3('i1',I1)*p3 - i*g4('i1',I1)*p4 + m*DK('i1',I1) )*vu(I1)
  ))
ENDDO
Id,P1=p1/[m+E]
Al,P2=p2/[m+E]
Al,P3=p3/[m+E]
Al,p4=i*E
Id,p3^2=E^2 - m^2 - p1^2 - p2^2
Id,E=[m+E]-m
*end
C 3 Checking spin-sum equations.

Read Spincheck.e
*fix

DO i1=1,4
DO i2=1,4
C u u| = 1/(2E) ( - i gamma p + m)
Z us'i1''i2' = 
   [m+E]/2/E*uu('i1')*(
    DS(I1,1,4,(Conjg(uu(I1))*g4(I1,'i2') )) )
  +  [m+E]/2/E*ud('i1')*(
    DS(I2,1,4,(Conjg(ud(I2))*g4(I2,'i2') )) )

  - 1/2/E*(- i*g1('i1','i2')*p1 - i*g2('i1','i2')*p2
   - i*g3('i1','i2')*p3 - i*g4('i1','i2')*p4 + m*DK('i1','i2'))

C v v| = 1/(2E) ( - i gamma p - m)
Z vs'i1''i2' = 
   [m+E]/2/E*vu('i1')*(
    DS(I1,1,4,(Conjg(vu(I1))*g4(I1,'i2') )) )
  +  [m+E]/2/E*vd('i1')*(
    DS(I2,1,4,(Conjg(vd(I2))*g4(I2,'i2') )) )

  - 1/2/E*(- i*g1('i1','i2')*p1 - i*g2('i1','i2')*p2
   - i*g3('i1','i2')*p3 - i*g4('i1','i2')*p4 - m*DK('i1','i2'))

Id,P1=p1/[m+E]
Al,P2=p2/[m+E]
Al,P3=p3/[m+E]
Al,p4=i*E
Id,p3^2=E^2 - m^2 - p1^2 - p2^2
Id,E=[m+E]-m
*yep
Id,[m+E]=m+E
Id,m=[m+E]-E
*next
ENDDO
ENDDO
*end
C 4 Checking charge conjugation.

Read Spincheck.e
*fix

DO i1=1,4
C vu = - C uu|
Z vu'i1' = vu('i1') + DS(I1,1,4,(
   CC('i1',I1)*(DS(I2,1,4,(Conjg(uu(I2))*g4(I2,I1) )) ) ))
C vd = - C ud|
Z vd'i1' = vd('i1') + DS(I1,1,4,(
   CC('i1',I1)*(DS(I2,1,4,(Conjg(ud(I2))*g4(I2,I1) )) ) ))
C uu| = vu C^-1
Z udb'i1' = DS(I3,1,4,( Conjg(ud(I3))*g4(I3,'i1') ))
  - DS(I4,1,4,( vd(I4)*CCI(I4,'i1') ))
C ud| = vd C^-1
Z uub'i1' = DS(I3,1,4,( Conjg(uu(I3))*g4(I3,'i1') ))
  - DS(I4,1,4,( vu(I4)*CCI(I4,'i1') ))

C uu = - C vu|
Z uu'i1' = uu('i1') + DS(I1,1,4,(
   CC('i1',I1)*(DS(I2,1,4,(Conjg(vu(I2))*g4(I2,I1) )) ) ))
C ud = - C vd|
Z ud'i1' = ud('i1') + DS(I1,1,4,(
   CC('i1',I1)*(DS(I2,1,4,(Conjg(vd(I2))*g4(I2,I1) )) ) ))
C vu| = uu C^-1
Z vub'i1' = DS(I3,1,4,( Conjg(vu(I3))*g4(I3,'i1') ))
  - DS(I4,1,4,( uu(I4)*CCI(I4,'i1') ))
C vd| = ud C^-1
Z vdb'i1' = DS(I3,1,4,( Conjg(vd(I3))*g4(I3,'i1') ))
  - DS(I4,1,4,( ud(I4)*CCI(I4,'i1') ))
*yep
Id,P1=p1/[m+E]
Al,P2=p2/[m+E]
Al,P3=p3/[m+E]
Al,p4=i*E
Id,p3^2=E^2 - m^2 - p1^2 - p2^2
Id,E=[m+E]-m
*yep
Id,[m+E]=m+E
Id,m=[m+E]-E
*next
ENDDO
*end
C 5 Checking charge conjugation transformation of gamma matrices.

Read Spincheck.e
*fix

C C^-1 gamma C = - gamma~
  C^-1 gamma5 C = gamma5~

DO i1=1,4
DO i2=1,4
DO i3=1,5
Z xx'i1''i2''i3' = DS(I1,1,4,( DS(I2,1,4,(
  CCI('i1',I1)*g'i3'(I1,I2)*CC(I2,'i2') )) ))
  + SI'i3'*g'i3'('i2','i1')
Id,SI1=1
Al,SI2=1
Al,SI3=1
Al,SI4=1
Al,SI5=-1

*next
ENDDO
ENDDO
ENDDO

*end
C 6 Checking time-reversal.

Read Spincheck.e
*fix

DO i1=1,4
C uu(-p) = D g4~ ud|
Z uu'i1' = SIGN*uu('i1')
  -
  DS(I1,1,4,( DS(I2,1,4,(
  TR('i1',I1)*g4(I2,I1)*(DS(I3,1,4,( Conjg(ud(I3))*g4(I3,I2) )) )
  )) ))
C ud(-p) = - D g4~ uu|
Z ud'i1' = SIGN*ud('i1')
  +
  DS(I1,1,4,( DS(I2,1,4,(
  TR('i1',I1)*g4(I2,I1)*(DS(I3,1,4,( Conjg(uu(I3))*g4(I3,I2) )) )
  )) ))
C vu(-p)| = vd g4~ D^-1
Z vu'i1' = SIGN*DS(I1,1,4,(Conjg(vu(I1))*g4(I1,'i1') ))
  -
  DS(I2,1,4,( DS(I3,1,4,(
  vd(I2)*g4(I3,I2)*TRI(I3,'i1') )) ))
C vd(-p)| = - vu g4~ D^-1
Z vd'i1' = SIGN*DS(I1,1,4,(Conjg(vd(I1))*g4(I1,'i1') ))
  +
  DS(I2,1,4,( DS(I3,1,4,(
  vu(I2)*g4(I3,I2)*TRI(I3,'i1') )) ))
Id,SIGN*P1=-P1
Al,SIGN*P2=-P2
Al,SIGN*P3=-P3
Id,SIGN=1
*next
ENDDO
*end
C 7 Checking time-reversal transformation of gamma matrices.

Read Spincheck.e
*fix

C D^-1 gamma D = gamma~
  D^-1 gamma5 D = gamma5~

DO i1=1,4
DO i2=1,4
DO i3=1,5
Z xx'i1''i2''i3' = DS(I1,1,4,( DS(I2,1,4,(
 TRI('i1',I1)*g'i3'(I1,I2)*TR(I2,'i2') )) ))
 - g'i3'('i2','i1')
*next
ENDDO
ENDDO
ENDDO
*end
